/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.DiskFetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputCallback;
import org.apache.tez.runtime.library.common.shuffle.MemoryFetchedInput;
import org.apache.tez.runtime.library.common.shuffle.RemoteFetchedInput;
import org.apache.tez.runtime.library.common.shuffle.impl.SimpleFetchedInputAllocator;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutputFiles;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RssSimpleFetchedInputAllocator
extends SimpleFetchedInputAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(RssSimpleFetchedInputAllocator.class);
    private static final int IFILE_HEAD_CHECKSUM_LEN = 8;
    private final Configuration conf;
    private final TezTaskOutputFiles fileNameAllocator;
    private final LocalDirAllocator localDirAllocator;
    private final long memoryLimit;
    private final long maxSingleShuffleLimit;
    private final long maxAvailableTaskMemory;
    private final long initialMemoryAvailable;
    private final String srcNameTrimmed;
    private volatile long usedMemory = 0L;
    private final String uniqueIdentifier;
    private final String appAttemptId;
    private final boolean remoteSpillEnable;
    private FileSystem remoteFS;
    private String remoteSpillBasePath;

    public RssSimpleFetchedInputAllocator(String srcNameTrimmed, String uniqueIdentifier, int dagID, Configuration conf, long maxTaskAvailableMemory, long memoryAvailable, String appAttemptId) {
        super(srcNameTrimmed, uniqueIdentifier, dagID, conf, maxTaskAvailableMemory, memoryAvailable);
        this.srcNameTrimmed = srcNameTrimmed;
        this.conf = conf;
        this.maxAvailableTaskMemory = maxTaskAvailableMemory;
        this.initialMemoryAvailable = memoryAvailable;
        this.uniqueIdentifier = uniqueIdentifier;
        this.appAttemptId = appAttemptId;
        this.fileNameAllocator = new TezTaskOutputFiles(conf, uniqueIdentifier, dagID);
        this.localDirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        float maxInMemCopyUse = conf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.9f);
        if ((double)maxInMemCopyUse > 1.0 || (double)maxInMemCopyUse < 0.0) {
            throw new RssException("Invalid value for tez.runtime.shuffle.fetch.buffer.percent: " + maxInMemCopyUse);
        }
        long memReq = (long)((float)conf.getLong("tez.runtime.task.memory", Math.min(this.maxAvailableTaskMemory, Integer.MAX_VALUE)) * maxInMemCopyUse);
        this.memoryLimit = memReq <= this.initialMemoryAvailable ? memReq : this.initialMemoryAvailable;
        float singleShuffleMemoryLimitPercent = conf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.25f);
        if (singleShuffleMemoryLimitPercent <= 0.0f || singleShuffleMemoryLimitPercent > 1.0f) {
            throw new RssException("Invalid value for tez.runtime.shuffle.memory.limit.percent: " + singleShuffleMemoryLimitPercent);
        }
        this.maxSingleShuffleLimit = (long)Math.min((float)this.memoryLimit * singleShuffleMemoryLimitPercent, 2.1474836E9f);
        this.remoteSpillEnable = conf.getBoolean("tez.rss.reduce.remote.spill.enable", false);
        if (this.remoteSpillEnable) {
            this.remoteSpillBasePath = conf.get("tez.rss.remote.spill.storage.path");
            if (StringUtils.isBlank((CharSequence)this.remoteSpillBasePath)) {
                throw new RssException("You must set remote spill path!");
            }
            String remoteStorageConf = this.conf.get("tez.rss.remote.storage.conf");
            Map<String, String> remoteStorageConfMap = RemoteStorageInfo.parseRemoteStorageConf(remoteStorageConf);
            Configuration remoteConf = new Configuration(this.conf);
            for (Map.Entry<String, String> entry : remoteStorageConfMap.entrySet()) {
                remoteConf.set(entry.getKey(), entry.getValue());
            }
            int replication = this.conf.getInt("tez.rss.reduce.remote.spill.replication", 1);
            int retries = this.conf.getInt("tez.rss.reduce.remote.spill.retries", 5);
            try {
                remoteConf.setInt("dfs.replication", replication);
                remoteConf.setInt("dfs.client.block.write.retries", retries);
                this.remoteFS = HadoopFilesystemProvider.getFilesystem(new Path(this.remoteSpillBasePath), remoteConf);
            }
            catch (Exception e) {
                throw new RssException("Cannot init remoteFS on path:" + this.remoteSpillBasePath);
            }
        }
        LOG.info(srcNameTrimmed + ": RequestedMemory=" + memReq + ", AssignedMemory=" + this.memoryLimit + ", maxSingleShuffleLimit=" + this.maxSingleShuffleLimit);
    }

    @InterfaceAudience.Private
    public static long getInitialMemoryReq(Configuration conf, long maxAvailableTaskMemory) {
        float maxInMemCopyUse = conf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.9f);
        if ((double)maxInMemCopyUse > 1.0 || (double)maxInMemCopyUse < 0.0) {
            throw new RssException("Invalid value for tez.runtime.shuffle.fetch.buffer.percent: " + maxInMemCopyUse);
        }
        return (long)((float)conf.getLong("tez.runtime.task.memory", Math.min(maxAvailableTaskMemory, Integer.MAX_VALUE)) * maxInMemCopyUse);
    }

    public synchronized FetchedInput allocate(long actualSize, long compressedSize, InputAttemptIdentifier inputAttemptIdentifier) throws IOException {
        if (actualSize > this.maxSingleShuffleLimit || this.usedMemory + actualSize > this.memoryLimit) {
            if (this.remoteSpillEnable) {
                LOG.info("Allocate RemoteFetchedInput, length:{}", (Object)actualSize);
                return new RemoteFetchedInput(actualSize + 8L, inputAttemptIdentifier, (FetchedInputCallback)this, this.remoteFS, this.remoteSpillBasePath, this.uniqueIdentifier, this.appAttemptId);
            }
            LOG.info("Allocate DiskFetchedInput, length:{}", (Object)actualSize);
            return new DiskFetchedInput(actualSize + 8L, inputAttemptIdentifier, (FetchedInputCallback)this, this.conf, this.localDirAllocator, this.fileNameAllocator);
        }
        this.usedMemory += actualSize;
        if (LOG.isDebugEnabled()) {
            LOG.info(this.srcNameTrimmed + ": Used memory after allocating " + actualSize + " : " + this.usedMemory);
        }
        return new MemoryFetchedInput(actualSize, inputAttemptIdentifier, (FetchedInputCallback)this);
    }

    public synchronized FetchedInput allocateType(FetchedInput.Type type, long actualSize, long compressedSize, InputAttemptIdentifier inputAttemptIdentifier) throws IOException {
        switch (type) {
            case DISK: {
                if (this.remoteSpillEnable) {
                    LOG.info("AllocateType RemoteFetchedInput, compressedSize:{}", (Object)compressedSize);
                    return new RemoteFetchedInput(actualSize + 8L, inputAttemptIdentifier, (FetchedInputCallback)this, this.remoteFS, this.remoteSpillBasePath, this.uniqueIdentifier, this.appAttemptId);
                }
                LOG.info("AllocateType DiskFetchedInput, compressedSize:{}", (Object)compressedSize);
                return new DiskFetchedInput(actualSize + 8L, inputAttemptIdentifier, (FetchedInputCallback)this, this.conf, this.localDirAllocator, this.fileNameAllocator);
            }
        }
        return this.allocate(actualSize, compressedSize, inputAttemptIdentifier);
    }

    public synchronized void fetchComplete(FetchedInput fetchedInput) {
        switch (fetchedInput.getType()) {
            case DISK: 
            case DISK_DIRECT: 
            case MEMORY: {
                break;
            }
            default: {
                throw new RssException("InputType: " + fetchedInput.getType() + " not expected for Broadcast fetch");
            }
        }
    }

    public synchronized void fetchFailed(FetchedInput fetchedInput) {
        this.cleanup(fetchedInput);
    }

    public synchronized void freeResources(FetchedInput fetchedInput) {
        this.cleanup(fetchedInput);
    }

    private void cleanup(FetchedInput fetchedInput) {
        switch (fetchedInput.getType()) {
            case DISK: {
                break;
            }
            case MEMORY: {
                this.unreserve(((MemoryFetchedInput)fetchedInput).getSize());
                break;
            }
            default: {
                throw new RssException("InputType: " + fetchedInput.getType() + " not expected for Broadcast fetch");
            }
        }
    }

    private synchronized void unreserve(long size) {
        this.usedMemory -= size;
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.srcNameTrimmed + ": Used memory after freeing " + size + " : " + this.usedMemory);
        }
    }

    @VisibleForTesting
    public void setRemoteFS(FileSystem remoteFS) {
        this.remoteFS = remoteFS;
    }
}

