/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FileChunk;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeThread;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.RssMergeManager;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezMerger;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssInMemoryMerger
extends MergeThread<MapOutput> {
    private static final Logger LOG = LoggerFactory.getLogger(RssInMemoryMerger.class);
    private static final String SPILL_FILE_PATTERN = "%s/%s_src_%d_spill_%d.out";
    private final InputContext inputContext;
    private final Configuration conf;
    private final RssMergeManager manager;
    private final CompressionCodec codec;
    private final Combiner combiner;
    private final FileSystem remoteFs;
    private final Path spillPath;
    private final String appAttemptId;
    private volatile InputAttemptIdentifier srcTaskIdentifier;
    private volatile Path outputPath;
    private final TezCounter spilledRecordsCounter;
    private final TezCounter numMemToRemoteMerges;
    private final TezCounter additionalBytesRead;
    private final TezCounter additionalBytesWritten;

    public RssInMemoryMerger(RssMergeManager manager, Configuration conf, InputContext inputContext, Combiner combiner, ExceptionReporter reporter, CompressionCodec codec, FileSystem remoteFs, String spillPath, String appAttemptId) {
        super((MergeManager)manager, Integer.MAX_VALUE, reporter);
        this.setName("MemtoRemoteMerger [" + TezUtilsInternal.cleanVertexName((String)inputContext.getSourceVertexName()) + "]");
        this.setDaemon(true);
        this.manager = manager;
        this.inputContext = inputContext;
        this.conf = conf;
        this.remoteFs = remoteFs;
        this.spillPath = new Path(spillPath);
        this.appAttemptId = appAttemptId;
        this.codec = codec;
        this.combiner = combiner;
        this.spilledRecordsCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SPILLED_RECORDS);
        this.numMemToRemoteMerges = inputContext.getCounters().findCounter((Enum)Counter.NUM_MEM_TO_REMOTE_MERGES);
        this.additionalBytesRead = inputContext.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_READ);
        this.additionalBytesWritten = inputContext.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_WRITTEN);
    }

    public void merge(List<MapOutput> inputs) throws IOException, InterruptedException {
        if (inputs == null || inputs.size() == 0) {
            return;
        }
        this.numMemToRemoteMerges.increment(1L);
        this.inputContext.notifyProgress();
        this.srcTaskIdentifier = inputs.get(0).getAttemptIdentifier();
        ArrayList<TezMerger.Segment> inMemorySegments = new ArrayList<TezMerger.Segment>();
        this.manager.createInMemorySegments(inputs, inMemorySegments, 0L);
        int noInMemorySegments = inMemorySegments.size();
        String mergedFile = String.format(SPILL_FILE_PATTERN, this.appAttemptId, this.inputContext.getUniqueIdentifier(), this.srcTaskIdentifier.getInputIdentifier(), this.srcTaskIdentifier.getSpillEventId());
        this.outputPath = new Path(this.spillPath, mergedFile);
        long outFileLen = 0L;
        try (IFile.Writer writer = null;){
            writer = new IFile.Writer(this.conf, this.remoteFs, this.outputPath, ConfigUtils.getIntermediateInputKeyClass((Configuration)this.conf), ConfigUtils.getIntermediateInputValueClass((Configuration)this.conf), this.codec, null, null);
            LOG.info("Initiating in-memory merge with " + noInMemorySegments + " segments...");
            Path tmpDir = null;
            FileSystem tmpFs = null;
            TezRawKeyValueIterator rIter = TezMerger.merge((Configuration)this.conf, tmpFs, (Class)ConfigUtils.getIntermediateInputKeyClass((Configuration)this.conf), (Class)ConfigUtils.getIntermediateInputValueClass((Configuration)this.conf), inMemorySegments, (int)inMemorySegments.size(), tmpDir, (RawComparator)ConfigUtils.getIntermediateInputKeyComparator((Configuration)this.conf), (Progressable)this.manager.getProgressable(), (TezCounter)this.spilledRecordsCounter, null, (TezCounter)this.additionalBytesRead, null);
            if (null == this.combiner) {
                TezMerger.writeFile((TezRawKeyValueIterator)rIter, (IFile.Writer)writer, (Progressable)this.manager.getProgressable(), (long)10000L);
            } else {
                this.runCombineProcessor(rIter, writer);
            }
            writer.close();
            this.additionalBytesWritten.increment(writer.getCompressedLength());
            writer = null;
            outFileLen = this.remoteFs.getFileStatus(this.outputPath).getLen();
            LOG.info(this.inputContext.getUniqueIdentifier() + " Merge of the " + noInMemorySegments + " files in-memory complete. Remote file is " + this.outputPath + " of size " + outFileLen);
        }
        this.manager.closeOnDiskFile(new FileChunk(this.outputPath, 0L, outFileLen));
    }

    void runCombineProcessor(TezRawKeyValueIterator kvIter, IFile.Writer writer) throws IOException, InterruptedException {
        this.combiner.combine(kvIter, writer);
    }

    public void cleanup(List<MapOutput> inputs, boolean deleteData) throws IOException, InterruptedException {
        if (deleteData && this.manager.isCleanup()) {
            LOG.info("Try deleting stale data");
            MergeManager.cleanup((FileSystem)this.remoteFs, (Path)this.outputPath);
        }
    }

    public static enum Counter {
        NUM_MEM_TO_REMOTE_MERGES;

    }
}

