/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi.conditions;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.unomi.persistence.spi.conditions.datemath.DateMathParseException;
import org.apache.unomi.persistence.spi.conditions.datemath.DateMathParser;
import org.apache.unomi.persistence.spi.conditions.datemath.JavaDateFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DateUtils.class.getName());

    public static Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        JavaDateFormatter formatter = new JavaDateFormatter("strict_date_optional_time||epoch_millis");
        DateMathParser dateMathParser = new DateMathParser(formatter, DateTimeFormatter.ISO_DATE_TIME);
        try {
            Instant instant = dateMathParser.parse(value.toString(), System::currentTimeMillis, false, ZoneOffset.UTC);
            return Date.from(instant);
        }
        catch (DateMathParseException e) {
            LOGGER.warn("unable to parse date. See debug log level for full stacktrace");
            LOGGER.warn("unable to parse date {}", value, (Object)e);
            return null;
        }
    }
}

