/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.util.List;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.string.Strings;

public class MetaInfStaticResourceReference
extends PackageResourceReference {
    private static final long serialVersionUID = -1858339228780709471L;
    private static Boolean META_INF_RESOURCES_SUPPORTED = null;

    public MetaInfStaticResourceReference(Class<?> scope, String name) {
        super(scope, name);
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        String[] parts;
        if (!this.isMetaInfResourcesSupported()) {
            return null;
        }
        Url url = new Url();
        List<String> segments = url.getSegments();
        String packageName = Packages.extractPackageName(this.getScope());
        for (String p : parts = Strings.split(packageName, '.')) {
            segments.add(p);
        }
        for (String p : parts = Strings.split(this.getName(), '/')) {
            segments.add(p);
        }
        return url;
    }

    protected boolean isMetaInfResourcesSupported() {
        if (META_INF_RESOURCES_SUPPORTED == null) {
            int majorVersion = WebApplication.get().getServletContext().getMajorVersion();
            META_INF_RESOURCES_SUPPORTED = majorVersion >= 3;
        }
        return META_INF_RESOURCES_SUPPORTED;
    }
}

