/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.interpreter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.configuration.ExecutionOptions;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.api.rules.DirectiveConditional;
import org.islandoftex.arara.api.rules.Rule;
import org.islandoftex.arara.api.rules.RuleArgument;
import org.islandoftex.arara.api.rules.RuleCommand;
import org.islandoftex.arara.api.session.Command;
import org.islandoftex.arara.api.session.ExecutionStatus;
import org.islandoftex.arara.cli.interpreter.HaltExpectedException;
import org.islandoftex.arara.cli.interpreter.Interpreter;
import org.islandoftex.arara.cli.interpreter.InterpreterUtils;
import org.islandoftex.arara.cli.ruleset.RuleFormat;
import org.islandoftex.arara.cli.ruleset.RuleUtils;
import org.islandoftex.arara.cli.utils.DisplayUtils;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Session;
import org.islandoftex.arara.core.ui.InputHandling;
import org.islandoftex.arara.mvel.interpreter.AraraExceptionWithHeader;
import org.islandoftex.arara.mvel.rules.DirectiveConditionalEvaluator;
import org.islandoftex.arara.mvel.rules.SerialRuleCommand;
import org.islandoftex.arara.mvel.utils.MvelState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mvel2.templates.TemplateRuntime;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J4\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u00192\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001eH\u0002J$\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JB\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001e2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u00192\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\u0006\u0010(\u001a\u00020\u0001H\u0002J&\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0\u001eH\u0002J0\u0010,\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0\u001e2\b\u0010.\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/islandoftex/arara/cli/interpreter/Interpreter;", "", "executionOptions", "Lorg/islandoftex/arara/api/configuration/ExecutionOptions;", "currentFile", "Lorg/islandoftex/arara/api/files/ProjectFile;", "workingDirectory", "Lorg/islandoftex/arara/api/files/MPPPath;", "(Lorg/islandoftex/arara/api/configuration/ExecutionOptions;Lorg/islandoftex/arara/api/files/ProjectFile;Lorg/islandoftex/arara/api/files/MPPPath;)V", "haltKey", "", "logger", "Lmu/KLogger;", "execute", "Lorg/islandoftex/arara/api/session/ExecutionStatus;", "directive", "Lorg/islandoftex/arara/api/rules/Directive;", "executeCommand", "command", "Lorg/islandoftex/arara/mvel/rules/SerialRuleCommand;", "conditional", "Lorg/islandoftex/arara/api/rules/DirectiveConditional;", "rule", "Lorg/islandoftex/arara/api/rules/Rule;", "parameters", "", "getRule", "getUnknownKeys", "", "arguments", "", "Lorg/islandoftex/arara/api/rules/RuleArgument;", "parseArguments", "processArgument", "argument", "idInDirectiveParams", "", "context", "parameterValue", "resultToList", "result", "runBoolean", "value", "authors", "runCommand", "Lorg/islandoftex/arara/api/session/Command;", "ruleCommandExitValue", "cli"})
@SourceDebugExtension(value={"SMAP\nInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpreter.kt\norg/islandoftex/arara/cli/interpreter/Interpreter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,429:1\n1360#2:430\n1446#2,5:431\n288#2,2:436\n766#2:438\n857#2,2:439\n1789#2,3:441\n1789#2,3:444\n1549#2:447\n1620#2,3:448\n1855#2,2:451\n*S KotlinDebug\n*F\n+ 1 Interpreter.kt\norg/islandoftex/arara/cli/interpreter/Interpreter\n*L\n60#1:430\n60#1:431,5\n79#1:436,2\n211#1:438\n211#1:439,2\n212#1:441,3\n303#1:444,3\n349#1:447\n349#1:448,3\n385#1:451,2\n*E\n"})
public final class Interpreter {
    @NotNull
    private final ExecutionOptions executionOptions;
    @NotNull
    private final MPPPath workingDirectory;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String haltKey;

    public Interpreter(@NotNull ExecutionOptions executionOptions, @NotNull ProjectFile currentFile, @NotNull MPPPath workingDirectory) {
        Intrinsics.checkNotNullParameter(executionOptions, "executionOptions");
        Intrinsics.checkNotNullParameter(currentFile, "currentFile");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        this.executionOptions = executionOptions;
        this.workingDirectory = workingDirectory;
        this.logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
        this.haltKey = "arara:" + currentFile.getPath().getFileName() + ":halt";
    }

    /*
     * WARNING - void declaration
     */
    private final MPPPath getRule(Directive directive, MPPPath workingDirectory) throws AraraException {
        Object v0;
        Set<MPPPath> paths;
        block3: {
            void $this$firstOrNull$iv;
            void $this$flatMapTo$iv$iv;
            paths = this.executionOptions.getRulePaths();
            boolean bl = false;
            Iterable $this$flatMap$iv = paths;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MPPPath path2 = (MPPPath)element$iv$iv;
                boolean bl2 = false;
                MPPPath[] mPPPathArray = new MPPPath[]{InterpreterUtils.INSTANCE.construct$cli(path2, directive.getIdentifier(), RuleFormat.MVEL, workingDirectory), InterpreterUtils.INSTANCE.construct$cli(path2, directive.getIdentifier(), RuleFormat.KOTLIN_DSL, workingDirectory), InterpreterUtils.INSTANCE.construct$cli(path2, "arara-rule-" + directive.getIdentifier(), RuleFormat.MVEL, workingDirectory)};
                Iterable list$iv$iv = CollectionsKt.listOf(mPPPathArray);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MPPPath it = (MPPPath)element$iv;
                boolean bl3 = false;
                if (!it.getExists()) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        MPPPath mPPPath = v0;
        if (mPPPath == null) {
            String string = LanguageController.getMessages().getERROR_INTERPRETER_RULE_NOT_FOUND();
            Object[] objectArray = new Object[]{directive.getIdentifier(), directive.getIdentifier(), CollectionsKt.joinToString$default(paths, "; ", "(", ")", 0, null, getRule.1.3.INSTANCE, 24, null)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            throw new AraraException(string2);
        }
        return mPPPath;
    }

    private final boolean runBoolean(boolean value, DirectiveConditional conditional, List<String> authors) {
        boolean bl;
        boolean it = bl = value;
        boolean bl2 = false;
        this.logger.info((Function0<? extends Object>)new Function0<Object>(it){
            final /* synthetic */ boolean $it;
            {
                this.$it = $it;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string = LanguageController.getMessages().getLOG_INFO_BOOLEAN_MODE();
                Object[] objectArray = new Object[]{this.$it};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                return string2;
            }
        });
        if (this.executionOptions.getExecutionMode() == ExecutionMode.DRY_RUN) {
            DisplayUtils.INSTANCE.printAuthors(authors);
            String string = LanguageController.getMessages().getINFO_INTERPRETER_DRYRUN_MODE_BOOLEAN_MODE();
            Object[] objectArray = new Object[]{it};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            DisplayUtils.INSTANCE.printWrapped(string2);
            DisplayUtils.INSTANCE.printConditional(conditional);
        }
        return bl;
    }

    private final boolean runCommand(Command command2, DirectiveConditional conditional, List<String> authors, String ruleCommandExitValue) throws AraraException {
        this.logger.info((Function0<? extends Object>)new Function0<Object>(command2){
            final /* synthetic */ Command $command;
            {
                this.$command = $command;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string = LanguageController.getMessages().getLOG_INFO_SYSTEM_COMMAND();
                Object[] objectArray = new Object[]{this.$command};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                return string2;
            }
        });
        boolean success = true;
        if (this.executionOptions.getExecutionMode() != ExecutionMode.DRY_RUN) {
            Object object;
            int code = InterpreterUtils.INSTANCE.run$cli(command2);
            try {
                Map<String, Integer> context2 = MapsKt.mapOf(TuplesKt.to("value", code));
                StringBuilder stringBuilder = new StringBuilder().append("@{ ");
                String string = ruleCommandExitValue;
                if (string == null) {
                    string = "value == 0";
                }
                object = TemplateRuntime.eval(stringBuilder.append(string).append(" }").toString(), context2);
            }
            catch (RuntimeException exception) {
                throw new AraraExceptionWithHeader(LanguageController.getMessages().getERROR_INTERPRETER_EXIT_RUNTIME_ERROR(), exception);
            }
            Object object2 = object;
            Intrinsics.checkNotNull(object2);
            Object check2 = object2;
            if (!(check2 instanceof Boolean)) {
                throw new AraraExceptionWithHeader(LanguageController.getMessages().getERROR_INTERPRETER_WRONG_EXIT_CLOSURE_RETURN());
            }
            success = (Boolean)check2;
        } else {
            DisplayUtils.INSTANCE.printAuthors(authors);
            String string = LanguageController.getMessages().getINFO_INTERPRETER_DRYRUN_MODE_SYSTEM_COMMAND();
            Object[] objectArray = new Object[]{command2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            DisplayUtils.INSTANCE.printWrapped(string2);
            DisplayUtils.INSTANCE.printConditional(conditional);
        }
        return success;
    }

    private final List<Object> resultToList(Object result2) {
        return result2 instanceof List ? InputHandling.INSTANCE.flatten((List)result2) : CollectionsKt.listOf(result2);
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionStatus executeCommand(SerialRuleCommand command2, DirectiveConditional conditional, Rule rule, Map<String, ? extends Object> parameters2) throws AraraException {
        void $this$fold$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable<Object> iterable;
        try {
            String string = command2.getCommandString();
            Intrinsics.checkNotNull(string);
            Object object = TemplateRuntime.eval(string, parameters2);
            Intrinsics.checkNotNullExpressionValue(object, "eval(...)");
            iterable = this.resultToList(object);
        }
        catch (RuntimeException exception) {
            throw new AraraExceptionWithHeader(LanguageController.getMessages().getERROR_INTERPRETER_COMMAND_RUNTIME_ERROR(), exception);
        }
        iterable = iterable;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank(it.toString());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        ExecutionStatus initial$iv = new ExecutionStatus.Processing();
        boolean $i$f$fold = false;
        ExecutionStatus accumulator$iv = initial$iv;
        Iterator iterator3 = $this$fold$iv.iterator();
        while (iterator3.hasNext()) {
            boolean bl;
            Object element$iv;
            Object current = element$iv = iterator3.next();
            boolean bl3 = false;
            String string = rule.getDisplayName();
            Intrinsics.checkNotNull(string);
            String string2 = command2.getName();
            if (string2 == null) {
                string2 = LanguageController.getMessages().getINFO_LABEL_UNNAMED_TASK();
            }
            DisplayUtils.INSTANCE.printEntry(string, string2);
            Object object = current;
            if (object instanceof Boolean) {
                bl = this.runBoolean((Boolean)current, conditional, rule.getAuthors());
            } else if (object instanceof Command) {
                bl = this.runCommand((Command)current, conditional, rule.getAuthors(), command2.getExit());
            } else {
                throw new AraraExceptionWithHeader(LanguageController.getMessages().getERROR_INTERPRETER_WRONG_RETURN_TYPE());
            }
            boolean success = bl;
            DisplayUtils.INSTANCE.printEntryResult(success);
            if (Session.INSTANCE.contains(this.haltKey)) {
                throw new HaltExpectedException(LanguageController.getMessages().getERROR_INTERPRETER_USER_REQUESTED_HALT(), new ExecutionStatus.FinishedWithCode(Integer.parseInt(Session.INSTANCE.get(this.haltKey).toString())));
            }
            if (this.executionOptions.getHaltOnErrors() && !success) {
                object = LanguageController.getMessages().getERROR_INTERPRETER_COMMAND_UNSUCCESSFUL_EXIT();
                Object[] objectArray = new Object[]{command2.getName()};
                String string3 = String.format(object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
                throw new HaltExpectedException(string3, new ExecutionStatus.ExternalCallFailed());
            }
            accumulator$iv = success ? (ExecutionStatus)new ExecutionStatus.Processing() : (ExecutionStatus)new ExecutionStatus.ExternalCallFailed();
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExecutionStatus execute(@NotNull Directive directive) throws AraraException {
        ExecutionStatus executionStatus;
        Intrinsics.checkNotNullParameter(directive, "directive");
        this.logger.info((Function0<? extends Object>)new Function0<Object>(directive){
            final /* synthetic */ Directive $directive;
            {
                this.$directive = $directive;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string = LanguageController.getMessages().getLOG_INFO_INTERPRET_RULE();
                Object[] objectArray = new Object[]{this.$directive.getIdentifier()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                return string2;
            }
        });
        MPPPath file = this.getRule(directive, this.workingDirectory);
        this.logger.info((Function0<? extends Object>)new Function0<Object>(file){
            final /* synthetic */ MPPPath $file;
            {
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string = LanguageController.getMessages().getLOG_INFO_RULE_LOCATION();
                Object[] objectArray = new Object[]{this.$file.getParent()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                return string2;
            }
        });
        Rule rule = RuleUtils.INSTANCE.parseRule(file, directive.getIdentifier());
        Map<String, Object> parameters2 = MapsKt.plus(this.parseArguments(rule, directive), MvelState.getRuleMethods());
        DirectiveConditionalEvaluator evaluator = new DirectiveConditionalEvaluator(this.executionOptions);
        boolean available = InterpreterUtils.INSTANCE.runPriorEvaluation$cli(directive.getConditional()) ? evaluator.evaluate(directive.getConditional()) : true;
        if (!available) {
            executionStatus = new ExecutionStatus.Processing();
        } else if (Session.INSTANCE.contains(this.haltKey)) {
            executionStatus = new ExecutionStatus.FinishedWithCode(Integer.parseInt(Session.INSTANCE.get(this.haltKey).toString()));
        } else {
            ExecutionStatus executionStatus2;
            try {
                Object retValue = null;
                do {
                    void $this$fold$iv;
                    void initial$iv;
                    Iterable iterable = rule.getCommands();
                    ExecutionStatus executionStatus3 = new ExecutionStatus.Processing();
                    boolean $i$f$fold = false;
                    ExecutionStatus accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        RuleCommand command2 = (RuleCommand)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(command2, "null cannot be cast to non-null type org.islandoftex.arara.mvel.rules.SerialRuleCommand");
                        accumulator$iv = this.executeCommand((SerialRuleCommand)command2, directive.getConditional(), rule, parameters2);
                    }
                    retValue = accumulator$iv;
                } while (evaluator.evaluate(directive.getConditional()));
                executionStatus2 = retValue;
            }
            catch (HaltExpectedException e) {
                executionStatus2 = e.getStatus();
            }
            catch (AraraExceptionWithHeader e) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = LanguageController.getMessages().getERROR_RULE_IDENTIFIER_AND_PATH();
                Object[] objectArray = new Object[]{directive.getIdentifier(), file.getParent().toString()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                String string3 = stringBuilder.append(string2).append(' ').append(e.getMessage()).toString();
                Exception exception = e.getException();
                if (exception == null) {
                    exception = e;
                }
                throw new AraraException(string3, exception);
            }
            executionStatus = executionStatus2;
        }
        return executionStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getUnknownKeys(Map<String, ? extends Object> parameters2, List<? extends RuleArgument<?>> arguments2) {
        void $this$mapTo$iv$iv;
        Set<String> found = parameters2.keySet();
        Iterable $this$map$iv = arguments2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RuleArgument ruleArgument = (RuleArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getIdentifier());
        }
        List expected = (List)destination$iv$iv;
        return CollectionsKt.subtract((Iterable)found, expected);
    }

    private final Map<String, Object> parseArguments(Rule rule, Directive directive) throws AraraException {
        Set<String> unknown = SetsKt.minus(this.getUnknownKeys(directive.getParameters(), rule.getArguments()), "reference");
        if (!((Collection)unknown).isEmpty()) {
            String string = LanguageController.getMessages().getERROR_INTERPRETER_UNKNOWN_KEYS();
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default(unknown, ", ", "(", ")", 0, null, null, 56, null)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            throw new AraraExceptionWithHeader(string2);
        }
        Map resolvedArguments = new LinkedHashMap();
        resolvedArguments.put("reference", MapsKt.getValue(directive.getParameters(), "reference"));
        Pair[] pairArray = new Pair[]{TuplesKt.to("parameters", directive.getParameters()), TuplesKt.to("reference", MapsKt.getValue(directive.getParameters(), "reference"))};
        Map<String, Object> context2 = MapsKt.plus(MapsKt.mapOf(pairArray), MvelState.getRuleMethods());
        Iterable $this$forEach$iv = rule.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuleArgument argument2 = (RuleArgument)element$iv;
            boolean bl = false;
            String string = argument2.getIdentifier();
            Intrinsics.checkNotNull(argument2, "null cannot be cast to non-null type org.islandoftex.arara.api.rules.RuleArgument<kotlin.Any?>");
            resolvedArguments.put(string, this.processArgument(argument2, directive.getParameters().containsKey(argument2.getIdentifier()), context2, directive.getParameters().get(argument2.getIdentifier())));
        }
        return resolvedArguments;
    }

    private final List<?> processArgument(RuleArgument<Object> argument2, boolean idInDirectiveParams, Map<String, ? extends Object> context2, Object parameterValue) throws AraraException {
        List<String> list;
        block5: {
            block6: {
                block4: {
                    if (argument2.isRequired() && !idInDirectiveParams) {
                        String string = LanguageController.getMessages().getERROR_INTERPRETER_ARGUMENT_IS_REQUIRED();
                        Object[] objectArray = new Object[]{argument2.getIdentifier()};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                        throw new AraraExceptionWithHeader(string2);
                    }
                    if (!idInDirectiveParams) break block4;
                    list = argument2.getProcessor().invoke(parameterValue, context2);
                    break block5;
                }
                list = argument2.getDefaultValue();
                if (list == null) break block6;
                List<String> list2 = list;
                boolean bl = false;
                List<String> list3 = argument2.getProcessor().invoke(list2, context2);
                list = list3;
                if (list3 != null) break block5;
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

