; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=ipsccp -S | FileCheck %s

; Don't constant-propagate byval pointers, since they are not pointers!
; PR5038

%struct.MYstr = type { i8, i32 }
@mystr = internal global %struct.MYstr zeroinitializer ; <ptr> [#uses=3]
define internal void @vfu1(ptr byval(%struct.MYstr) align 4 %u) nounwind {
; CHECK-LABEL: @vfu1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr [[STRUCT_MYSTR:%.*]], ptr [[U:%.*]], i32 0, i32 1
; CHECK-NEXT:    store i32 99, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr [[STRUCT_MYSTR]], ptr [[U]], i32 0, i32 0
; CHECK-NEXT:    store i8 97, ptr [[TMP1]], align 4
; CHECK-NEXT:    br label [[RETURN:%.*]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  %0 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 1 ; <ptr> [#uses=1]
  store i32 99, ptr %0, align 4
  %1 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 0 ; <ptr> [#uses=1]
  store i8 97, ptr %1, align 4
  br label %return

return:                                           ; preds = %entry
  ret void
}

define internal i32 @vfu2(ptr byval(%struct.MYstr) align 4 %u) nounwind readonly {
; CHECK-LABEL: @vfu2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr getelementptr inbounds nuw (i8, ptr @mystr, i64 4), align 4
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr @mystr, align 1
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = add i32 [[TMP2]], [[TMP0]]
; CHECK-NEXT:    ret i32 [[TMP3]]
;
entry:
  %0 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 1 ; <ptr> [#uses=1]
  %1 = load i32, ptr %0
  %2 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 0 ; <ptr> [#uses=1]
  %3 = load i8, ptr %2
  %4 = zext i8 %3 to i32
  %5 = add i32 %4, %1
  ret i32 %5
}

define i32 @unions() nounwind {
; CHECK-LABEL: @unions(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @vfu1(ptr byval([[STRUCT_MYSTR:%.*]]) align 4 @mystr) #[[ATTR0:[0-9]+]]
; CHECK-NEXT:    [[RESULT:%.*]] = call i32 @vfu2(ptr byval([[STRUCT_MYSTR]]) align 4 @mystr) #[[ATTR0]]
; CHECK-NEXT:    ret i32 [[RESULT]]
;
entry:
  call void @vfu1(ptr byval(%struct.MYstr) align 4 @mystr) nounwind
  %result = call i32 @vfu2(ptr byval(%struct.MYstr) align 4 @mystr) nounwind
  ret i32 %result
}

