; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=infer-address-spaces %s | FileCheck %s

define i1 @is_constant_global_to_flat(ptr addrspace(1) %ptr) {
; CHECK-LABEL: define i1 @is_constant_global_to_flat(
; CHECK-SAME: ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call i1 @llvm.is.constant.p1(ptr addrspace(1) [[PTR]])
; CHECK-NEXT:    ret i1 [[RET]]
;
  %cast = addrspacecast ptr addrspace(1) %ptr to ptr
  %ret = call i1 @llvm.is.constant.p0(ptr %cast)
  ret i1 %ret
}

define i1 @is_constant_local_to_flat(ptr addrspace(3) %ptr) {
; CHECK-LABEL: define i1 @is_constant_local_to_flat(
; CHECK-SAME: ptr addrspace(3) [[PTR:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call i1 @llvm.is.constant.p3(ptr addrspace(3) [[PTR]])
; CHECK-NEXT:    ret i1 [[RET]]
;
  %cast = addrspacecast ptr addrspace(3) %ptr to ptr
  %ret = call i1 @llvm.is.constant.p0(ptr %cast)
  ret i1 %ret
}

define i1 @is_constant_private_to_flat(ptr addrspace(5) %ptr) {
; CHECK-LABEL: define i1 @is_constant_private_to_flat(
; CHECK-SAME: ptr addrspace(5) [[PTR:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call i1 @llvm.is.constant.p5(ptr addrspace(5) [[PTR]])
; CHECK-NEXT:    ret i1 [[RET]]
;
  %cast = addrspacecast ptr addrspace(5) %ptr to ptr
  %ret = call i1 @llvm.is.constant.p0(ptr %cast)
  ret i1 %ret
}

define i1 @is_constant_private_to_flat_v2(<2 x ptr addrspace(5)> %ptr) {
; CHECK-LABEL: define i1 @is_constant_private_to_flat_v2(
; CHECK-SAME: <2 x ptr addrspace(5)> [[PTR:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call i1 @llvm.is.constant.v2p5(<2 x ptr addrspace(5)> [[PTR]])
; CHECK-NEXT:    ret i1 [[RET]]
;
  %cast = addrspacecast <2 x ptr addrspace(5)> %ptr to <2 x ptr>
  %ret = call i1 @llvm.is.constant.v2p0(<2 x ptr> %cast)
  ret i1 %ret
}

define i1 @is_constant_i32(i32 %val) {
; CHECK-LABEL: define i1 @is_constant_i32(
; CHECK-SAME: i32 [[VAL:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call i1 @llvm.is.constant.i32(i32 [[VAL]])
; CHECK-NEXT:    ret i1 [[RET]]
;
  %ret = call i1 @llvm.is.constant.i32(i32 %val)
  ret i1 %ret
}
