; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zvfh,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zvfh,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zvfhmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zvfhmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN


define void @fadd_v8bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fadd_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = fadd <8 x bfloat> %a, %b
  store <8 x bfloat> %c, ptr %x
  ret void
}

define void @fadd_v6bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fadd_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = fadd <6 x bfloat> %a, %b
  store <6 x bfloat> %c, ptr %x
  ret void
}

define void @fadd_v8f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fadd_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfadd.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fadd_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = fadd <8 x half> %a, %b
  store <8 x half> %c, ptr %x
  ret void
}

define void @fadd_v6f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fadd_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfadd.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fadd_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = fadd <6 x half> %a, %b
  store <6 x half> %c, ptr %x
  ret void
}

define void @fadd_v4f32(ptr %x, ptr %y) {
; CHECK-LABEL: fadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = fadd <4 x float> %a, %b
  store <4 x float> %c, ptr %x
  ret void
}

define void @fadd_v2f64(ptr %x, ptr %y) {
; CHECK-LABEL: fadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = fadd <2 x double> %a, %b
  store <2 x double> %c, ptr %x
  ret void
}

define void @fsub_v8bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fsub_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsub.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = fsub <8 x bfloat> %a, %b
  store <8 x bfloat> %c, ptr %x
  ret void
}

define void @fsub_v6bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fsub_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsub.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = fsub <6 x bfloat> %a, %b
  store <6 x bfloat> %c, ptr %x
  ret void
}

define void @fsub_v8f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fsub_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfsub.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fsub_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsub.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = fsub <8 x half> %a, %b
  store <8 x half> %c, ptr %x
  ret void
}

define void @fsub_v6f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fsub_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfsub.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fsub_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsub.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = fsub <6 x half> %a, %b
  store <6 x half> %c, ptr %x
  ret void
}

define void @fsub_v4f32(ptr %x, ptr %y) {
; CHECK-LABEL: fsub_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfsub.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = fsub <4 x float> %a, %b
  store <4 x float> %c, ptr %x
  ret void
}

define void @fsub_v2f64(ptr %x, ptr %y) {
; CHECK-LABEL: fsub_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfsub.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = fsub <2 x double> %a, %b
  store <2 x double> %c, ptr %x
  ret void
}

define void @fmul_v8bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fmul_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = fmul <8 x bfloat> %a, %b
  store <8 x bfloat> %c, ptr %x
  ret void
}

define void @fmul_v6bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fmul_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = fmul <6 x bfloat> %a, %b
  store <6 x bfloat> %c, ptr %x
  ret void
}

define void @fmul_v8f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fmul_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfmul.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmul_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = fmul <8 x half> %a, %b
  store <8 x half> %c, ptr %x
  ret void
}

define void @fmul_v6f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fmul_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfmul.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmul_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = fmul <6 x half> %a, %b
  store <6 x half> %c, ptr %x
  ret void
}

define void @fmul_v4f32(ptr %x, ptr %y) {
; CHECK-LABEL: fmul_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfmul.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = fmul <4 x float> %a, %b
  store <4 x float> %c, ptr %x
  ret void
}

define void @fmul_v2f64(ptr %x, ptr %y) {
; CHECK-LABEL: fmul_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfmul.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = fmul <2 x double> %a, %b
  store <2 x double> %c, ptr %x
  ret void
}

define void @fdiv_v8bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fdiv_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = fdiv <8 x bfloat> %a, %b
  store <8 x bfloat> %c, ptr %x
  ret void
}

define void @fdiv_v6bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fdiv_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = fdiv <6 x bfloat> %a, %b
  store <6 x bfloat> %c, ptr %x
  ret void
}

define void @fdiv_v8f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fdiv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfdiv.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fdiv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfdiv.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = fdiv <8 x half> %a, %b
  store <8 x half> %c, ptr %x
  ret void
}

define void @fdiv_v6f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fdiv_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfdiv.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fdiv_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfdiv.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = fdiv <6 x half> %a, %b
  store <6 x half> %c, ptr %x
  ret void
}

define void @fdiv_v4f32(ptr %x, ptr %y) {
; CHECK-LABEL: fdiv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = fdiv <4 x float> %a, %b
  store <4 x float> %c, ptr %x
  ret void
}

define void @fdiv_v2f64(ptr %x, ptr %y) {
; CHECK-LABEL: fdiv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = fdiv <2 x double> %a, %b
  store <2 x double> %c, ptr %x
  ret void
}

define void @fneg_v8bf16(ptr %x) {
; CHECK-LABEL: fneg_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    vxor.vx v8, v8, a1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = fneg <8 x bfloat> %a
  store <8 x bfloat> %b, ptr %x
  ret void
}

define void @fneg_v6bf16(ptr %x) {
; CHECK-LABEL: fneg_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    vxor.vx v8, v8, a1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = fneg <6 x bfloat> %a
  store <6 x bfloat> %b, ptr %x
  ret void
}

define void @fneg_v8f16(ptr %x) {
; ZVFH-LABEL: fneg_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfneg.v v8, v8
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fneg_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vxor.vx v8, v8, a1
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = fneg <8 x half> %a
  store <8 x half> %b, ptr %x
  ret void
}

define void @fneg_v6f16(ptr %x) {
; ZVFH-LABEL: fneg_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfneg.v v8, v8
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fneg_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vxor.vx v8, v8, a1
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = fneg <6 x half> %a
  store <6 x half> %b, ptr %x
  ret void
}

define void @fneg_v4f32(ptr %x) {
; CHECK-LABEL: fneg_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfneg.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = fneg <4 x float> %a
  store <4 x float> %b, ptr %x
  ret void
}

define void @fneg_v2f64(ptr %x) {
; CHECK-LABEL: fneg_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfneg.v v8, v8
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = fneg <2 x double> %a
  store <2 x double> %b, ptr %x
  ret void
}

define void @fabs_v8bf16(ptr %x) {
; CHECK-LABEL: fabs_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = call <8 x bfloat> @llvm.fabs.v8bf16(<8 x bfloat> %a)
  store <8 x bfloat> %b, ptr %x
  ret void
}

define void @fabs_v6bf16(ptr %x) {
; CHECK-LABEL: fabs_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = call <6 x bfloat> @llvm.fabs.v6bf16(<6 x bfloat> %a)
  store <6 x bfloat> %b, ptr %x
  ret void
}

define void @fabs_v8f16(ptr %x) {
; ZVFH-LABEL: fabs_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfabs.v v8, v8
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fabs_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    addi a1, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = call <8 x half> @llvm.fabs.v8f16(<8 x half> %a)
  store <8 x half> %b, ptr %x
  ret void
}

define void @fabs_v6f16(ptr %x) {
; ZVFH-LABEL: fabs_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfabs.v v8, v8
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fabs_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    addi a1, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = call <6 x half> @llvm.fabs.v6f16(<6 x half> %a)
  store <6 x half> %b, ptr %x
  ret void
}

define void @fabs_v4f32(ptr %x) {
; CHECK-LABEL: fabs_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfabs.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = call <4 x float> @llvm.fabs.v4f32(<4 x float> %a)
  store <4 x float> %b, ptr %x
  ret void
}

define void @fabs_v2f64(ptr %x) {
; CHECK-LABEL: fabs_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfabs.v v8, v8
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = call <2 x double> @llvm.fabs.v2f64(<2 x double> %a)
  store <2 x double> %b, ptr %x
  ret void
}

define void @copysign_v8bf16(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vand.vx v9, v9, a1
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = call <8 x bfloat> @llvm.copysign.v8bf16(<8 x bfloat> %a, <8 x bfloat> %b)
  store <8 x bfloat> %c, ptr %x
  ret void
}

define void @copysign_v6bf16(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    vand.vx v9, v9, a1
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = call <6 x bfloat> @llvm.copysign.v6bf16(<6 x bfloat> %a, <6 x bfloat> %b)
  store <6 x bfloat> %c, ptr %x
  ret void
}

define void @copysign_v8f16(ptr %x, ptr %y) {
; ZVFH-LABEL: copysign_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: copysign_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a1)
; ZVFHMIN-NEXT:    vle16.v v9, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    addi a1, a1, -1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v9, v8
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %b)
  store <8 x half> %c, ptr %x
  ret void
}

define void @copysign_v6f16(ptr %x, ptr %y) {
; ZVFH-LABEL: copysign_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: copysign_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a1)
; ZVFHMIN-NEXT:    vle16.v v9, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    addi a1, a1, -1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v9, v8
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = call <6 x half> @llvm.copysign.v6f16(<6 x half> %a, <6 x half> %b)
  store <6 x half> %c, ptr %x
  ret void
}

define void @copysign_v4f32(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %b)
  store <4 x float> %c, ptr %x
  ret void
}

define void @copysign_v2f64(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %b)
  store <2 x double> %c, ptr %x
  ret void
}

define void @copysign_vf_v8bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: copysign_vf_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a2, 8
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    addi a1, a2, -1
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vand.vx v9, v9, a2
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <8 x bfloat> %b, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %d = call <8 x bfloat> @llvm.copysign.v8bf16(<8 x bfloat> %a, <8 x bfloat> %c)
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @copysign_vf_v6bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: copysign_vf_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a2, 8
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    addi a1, a2, -1
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vand.vx v9, v9, a2
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = insertelement <6 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <6 x bfloat> %b, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %d = call <6 x bfloat> @llvm.copysign.v6bf16(<6 x bfloat> %a, <6 x bfloat> %c)
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @copysign_vf_v8f16(ptr %x, half %y) {
; ZVFH-LABEL: copysign_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfsgnj.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: copysign_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a0)
; ZVFHMIN-NEXT:    lui a2, 8
; ZVFHMIN-NEXT:    vmv.v.x v9, a1
; ZVFHMIN-NEXT:    addi a1, a2, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a2
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %c)
  store <8 x half> %d, ptr %x
  ret void
}

define void @copysign_vf_v6f16(ptr %x, half %y) {
; ZVFH-LABEL: copysign_vf_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfsgnj.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: copysign_vf_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a0)
; ZVFHMIN-NEXT:    lui a2, 8
; ZVFHMIN-NEXT:    vmv.v.x v9, a1
; ZVFHMIN-NEXT:    addi a1, a2, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a2
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = insertelement <6 x half> poison, half %y, i32 0
  %c = shufflevector <6 x half> %b, <6 x half> poison, <6 x i32> zeroinitializer
  %d = call <6 x half> @llvm.copysign.v6f16(<6 x half> %a, <6 x half> %c)
  store <6 x half> %d, ptr %x
  ret void
}

define void @copysign_vf_v4f32(ptr %x, float %y) {
; CHECK-LABEL: copysign_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %c)
  store <4 x float> %d, ptr %x
  ret void
}

define void @copysign_vf_v2f64(ptr %x, double %y) {
; CHECK-LABEL: copysign_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %c)
  store <2 x double> %d, ptr %x
  ret void
}

define void @copysign_neg_v8bf16(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_neg_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    addi a2, a1, -1
; CHECK-NEXT:    vxor.vx v8, v8, a1
; CHECK-NEXT:    vand.vx v9, v9, a2
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = fneg <8 x bfloat> %b
  %d = call <8 x bfloat> @llvm.copysign.v8bf16(<8 x bfloat> %a, <8 x bfloat> %c)
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @copysign_neg_v6bf16(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_neg_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    addi a2, a1, -1
; CHECK-NEXT:    vxor.vx v8, v8, a1
; CHECK-NEXT:    vand.vx v9, v9, a2
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = fneg <6 x bfloat> %b
  %d = call <6 x bfloat> @llvm.copysign.v6bf16(<6 x bfloat> %a, <6 x bfloat> %c)
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @copysign_neg_v8f16(ptr %x, ptr %y) {
; ZVFH-LABEL: copysign_neg_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: copysign_neg_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a1)
; ZVFHMIN-NEXT:    vle16.v v9, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    addi a2, a1, -1
; ZVFHMIN-NEXT:    vxor.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a2
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vor.vv v8, v9, v8
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = fneg <8 x half> %b
  %d = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %c)
  store <8 x half> %d, ptr %x
  ret void
}

define void @copysign_neg_v6f16(ptr %x, ptr %y) {
; ZVFH-LABEL: copysign_neg_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v9
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: copysign_neg_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a1)
; ZVFHMIN-NEXT:    vle16.v v9, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    addi a2, a1, -1
; ZVFHMIN-NEXT:    vxor.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a2
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vor.vv v8, v9, v8
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = fneg <6 x half> %b
  %d = call <6 x half> @llvm.copysign.v6f16(<6 x half> %a, <6 x half> %c)
  store <6 x half> %d, ptr %x
  ret void
}

define void @copysign_neg_v4f32(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_neg_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = fneg <4 x float> %b
  %d = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %c)
  store <4 x float> %d, ptr %x
  ret void
}

define void @copysign_neg_v2f64(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_neg_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = fneg <2 x double> %b
  %d = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %c)
  store <2 x double> %d, ptr %x
  ret void
}

define void @copysign_neg_trunc_v4bf16_v4f32(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_neg_trunc_v4bf16_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    addi a2, a1, -1
; CHECK-NEXT:    vand.vx v8, v8, a2
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v9
; CHECK-NEXT:    vxor.vx v9, v10, a1
; CHECK-NEXT:    vand.vx v9, v9, a1
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x bfloat>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = fneg <4 x float> %b
  %d = fptrunc <4 x float> %c to <4 x bfloat>
  %e = call <4 x bfloat> @llvm.copysign.v4bf16(<4 x bfloat> %a, <4 x bfloat> %d)
  store <4 x bfloat> %e, ptr %x
  ret void
}

define void @copysign_neg_trunc_v3bf16_v3f32(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_neg_trunc_v3bf16_v3f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 3, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    addi a2, a1, -1
; CHECK-NEXT:    vand.vx v8, v8, a2
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v9
; CHECK-NEXT:    vxor.vx v9, v10, a1
; CHECK-NEXT:    vand.vx v9, v9, a1
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <3 x bfloat>, ptr %x
  %b = load <3 x float>, ptr %y
  %c = fneg <3 x float> %b
  %d = fptrunc <3 x float> %c to <3 x bfloat>
  %e = call <3 x bfloat> @llvm.copysign.v3bf16(<3 x bfloat> %a, <3 x bfloat> %d)
  store <3 x bfloat> %e, ptr %x
  ret void
}

define void @copysign_neg_trunc_v4f16_v4f32(ptr %x, ptr %y) {
; ZVFH-LABEL: copysign_neg_trunc_v4f16_v4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFH-NEXT:    vle32.v v8, (a1)
; ZVFH-NEXT:    vle16.v v9, (a0)
; ZVFH-NEXT:    vfncvt.f.f.w v10, v8
; ZVFH-NEXT:    vfsgnjn.vv v8, v9, v10
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: copysign_neg_trunc_v4f16_v4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a0)
; ZVFHMIN-NEXT:    vle32.v v9, (a1)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    addi a2, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a2
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vxor.vx v9, v10, a1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <4 x half>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = fneg <4 x float> %b
  %d = fptrunc <4 x float> %c to <4 x half>
  %e = call <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %d)
  store <4 x half> %e, ptr %x
  ret void
}

define void @copysign_neg_trunc_v3f16_v3f32(ptr %x, ptr %y) {
; ZVFH-LABEL: copysign_neg_trunc_v3f16_v3f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 3, e16, mf2, ta, ma
; ZVFH-NEXT:    vle32.v v8, (a1)
; ZVFH-NEXT:    vle16.v v9, (a0)
; ZVFH-NEXT:    vfncvt.f.f.w v10, v8
; ZVFH-NEXT:    vfsgnjn.vv v8, v9, v10
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: copysign_neg_trunc_v3f16_v3f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 3, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a0)
; ZVFHMIN-NEXT:    vle32.v v9, (a1)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    addi a2, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a2
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vxor.vx v9, v10, a1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <3 x half>, ptr %x
  %b = load <3 x float>, ptr %y
  %c = fneg <3 x float> %b
  %d = fptrunc <3 x float> %c to <3 x half>
  %e = call <3 x half> @llvm.copysign.v3f16(<3 x half> %a, <3 x half> %d)
  store <3 x half> %e, ptr %x
  ret void
}

define void @copysign_neg_ext_v2f64_v2f32(ptr %x, ptr %y) {
; CHECK-LABEL: copysign_neg_ext_v2f64_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a1)
; CHECK-NEXT:    vle64.v v9, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v9, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x float>, ptr %y
  %c = fneg <2 x float> %b
  %d = fpext <2 x float> %c to <2 x double>
  %e = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %d)
  store <2 x double> %e, ptr %x
  ret void
}

define void @sqrt_v8bf16(ptr %x) {
; CHECK-LABEL: sqrt_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsqrt.v v8, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = call <8 x bfloat> @llvm.sqrt.v8bf16(<8 x bfloat> %a)
  store <8 x bfloat> %b, ptr %x
  ret void
}

define void @sqrt_v6bf16(ptr %x) {
; CHECK-LABEL: sqrt_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsqrt.v v8, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = call <6 x bfloat> @llvm.sqrt.v6bf16(<6 x bfloat> %a)
  store <6 x bfloat> %b, ptr %x
  ret void
}

define void @sqrt_v8f16(ptr %x) {
; ZVFH-LABEL: sqrt_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfsqrt.v v8, v8
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: sqrt_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsqrt.v v8, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = call <8 x half> @llvm.sqrt.v8f16(<8 x half> %a)
  store <8 x half> %b, ptr %x
  ret void
}

define void @sqrt_v6f16(ptr %x) {
; ZVFH-LABEL: sqrt_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfsqrt.v v8, v8
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: sqrt_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsqrt.v v8, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = call <6 x half> @llvm.sqrt.v6f16(<6 x half> %a)
  store <6 x half> %b, ptr %x
  ret void
}

define void @sqrt_v4f32(ptr %x) {
; CHECK-LABEL: sqrt_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfsqrt.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = call <4 x float> @llvm.sqrt.v4f32(<4 x float> %a)
  store <4 x float> %b, ptr %x
  ret void
}

define void @sqrt_v2f64(ptr %x) {
; CHECK-LABEL: sqrt_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfsqrt.v v8, v8
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %a)
  store <2 x double> %b, ptr %x
  ret void
}

define void @fma_v8bf16(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fma_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a2)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vle16.v v14, (a1)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = load <8 x bfloat>, ptr %z
  %d = call <8 x bfloat> @llvm.fma.v8bf16(<8 x bfloat> %a, <8 x bfloat> %b, <8 x bfloat> %c)
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fma_v6bf16(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fma_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a2)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vle16.v v14, (a1)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = load <6 x bfloat>, ptr %z
  %d = call <6 x bfloat> @llvm.fma.v6bf16(<6 x bfloat> %a, <6 x bfloat> %b, <6 x bfloat> %c)
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fma_v8f16(ptr %x, ptr %y, ptr %z) {
; ZVFH-LABEL: fma_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vle16.v v10, (a2)
; ZVFH-NEXT:    vfmacc.vv v10, v8, v9
; ZVFH-NEXT:    vse16.v v10, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fma_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a2)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vle16.v v14, (a1)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = load <8 x half>, ptr %z
  %d = call <8 x half> @llvm.fma.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c)
  store <8 x half> %d, ptr %x
  ret void
}

define void @fma_v6f16(ptr %x, ptr %y, ptr %z) {
; ZVFH-LABEL: fma_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vle16.v v10, (a2)
; ZVFH-NEXT:    vfmacc.vv v10, v8, v9
; ZVFH-NEXT:    vse16.v v10, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fma_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a2)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vle16.v v14, (a1)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = load <6 x half>, ptr %z
  %d = call <6 x half> @llvm.fma.v6f16(<6 x half> %a, <6 x half> %b, <6 x half> %c)
  store <6 x half> %d, ptr %x
  ret void
}

define void @fma_v4f32(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fma_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vle32.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse32.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = load <4 x float>, ptr %z
  %d = call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c)
  store <4 x float> %d, ptr %x
  ret void
}

define void @fma_v2f64(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fma_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vle64.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse64.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = load <2 x double>, ptr %z
  %d = call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  store <2 x double> %d, ptr %x
  ret void
}

define void @fmsub_v8bf16(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fmsub_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a2)
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    vle16.v v14, (a1)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    vxor.vx v12, v8, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = load <8 x bfloat>, ptr %z
  %neg = fneg <8 x bfloat> %c
  %d = call <8 x bfloat> @llvm.fma.v8bf16(<8 x bfloat> %a, <8 x bfloat> %b, <8 x bfloat> %neg)
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fmsub_v6bf16(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fmsub_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a2)
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    vle16.v v14, (a1)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    vxor.vx v12, v8, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = load <6 x bfloat>, ptr %z
  %neg = fneg <6 x bfloat> %c
  %d = call <6 x bfloat> @llvm.fma.v6bf16(<6 x bfloat> %a, <6 x bfloat> %b, <6 x bfloat> %neg)
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fmsub_v8f16(ptr %x, ptr %y, ptr %z) {
; ZVFH-LABEL: fmsub_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vle16.v v10, (a2)
; ZVFH-NEXT:    vfmsac.vv v10, v8, v9
; ZVFH-NEXT:    vse16.v v10, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmsub_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a2)
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    vle16.v v14, (a1)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vxor.vx v12, v8, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = load <8 x half>, ptr %z
  %neg = fneg <8 x half> %c
  %d = call <8 x half> @llvm.fma.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %neg)
  store <8 x half> %d, ptr %x
  ret void
}

define void @fmsub_v6f16(ptr %x, ptr %y, ptr %z) {
; ZVFH-LABEL: fmsub_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vle16.v v10, (a2)
; ZVFH-NEXT:    vfmsac.vv v10, v8, v9
; ZVFH-NEXT:    vse16.v v10, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmsub_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a2)
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    vle16.v v14, (a1)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vxor.vx v12, v8, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = load <6 x half>, ptr %z
  %neg = fneg <6 x half> %c
  %d = call <6 x half> @llvm.fma.v6f16(<6 x half> %a, <6 x half> %b, <6 x half> %neg)
  store <6 x half> %d, ptr %x
  ret void
}

define void @fnmsub_v4f32(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fnmsub_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vle32.v v10, (a2)
; CHECK-NEXT:    vfnmsac.vv v10, v8, v9
; CHECK-NEXT:    vse32.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = load <4 x float>, ptr %z
  %neg = fneg <4 x float> %a
  %d = call <4 x float> @llvm.fma.v4f32(<4 x float> %neg, <4 x float> %b, <4 x float> %c)
  store <4 x float> %d, ptr %x
  ret void
}

define void @fnmadd_v2f64(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fnmadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vle64.v v10, (a2)
; CHECK-NEXT:    vfnmacc.vv v10, v8, v9
; CHECK-NEXT:    vse64.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = load <2 x double>, ptr %z
  %neg = fneg <2 x double> %b
  %neg2 = fneg <2 x double> %c
  %d = call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %neg, <2 x double> %neg2)
  store <2 x double> %d, ptr %x
  ret void
}

define void @fadd_v16bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fadd_v16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v12, (a1)
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v8
; CHECK-NEXT:    vse16.v v12, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x bfloat>, ptr %x
  %b = load <16 x bfloat>, ptr %y
  %c = fadd <16 x bfloat> %a, %b
  store <16 x bfloat> %c, ptr %x
  ret void
}

define void @fadd_v16f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fadd_v16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v10, (a1)
; ZVFH-NEXT:    vfadd.vv v8, v8, v10
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fadd_v16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vle16.v v12, (a1)
; ZVFHMIN-NEXT:    vle16.v v16, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v8
; ZVFHMIN-NEXT:    vse16.v v12, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <16 x half>, ptr %x
  %b = load <16 x half>, ptr %y
  %c = fadd <16 x half> %a, %b
  store <16 x half> %c, ptr %x
  ret void
}

define void @fadd_v8f32(ptr %x, ptr %y) {
; CHECK-LABEL: fadd_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v10, (a1)
; CHECK-NEXT:    vfadd.vv v8, v8, v10
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %b = load <8 x float>, ptr %y
  %c = fadd <8 x float> %a, %b
  store <8 x float> %c, ptr %x
  ret void
}

define void @fadd_v4f64(ptr %x, ptr %y) {
; CHECK-LABEL: fadd_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v10, (a1)
; CHECK-NEXT:    vfadd.vv v8, v8, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x double>, ptr %x
  %b = load <4 x double>, ptr %y
  %c = fadd <4 x double> %a, %b
  store <4 x double> %c, ptr %x
  ret void
}

define void @fsub_v16bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fsub_v16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v12, (a1)
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfsub.vv v8, v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v8
; CHECK-NEXT:    vse16.v v12, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x bfloat>, ptr %x
  %b = load <16 x bfloat>, ptr %y
  %c = fsub <16 x bfloat> %a, %b
  store <16 x bfloat> %c, ptr %x
  ret void
}

define void @fsub_v16f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fsub_v16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v10, (a1)
; ZVFH-NEXT:    vfsub.vv v8, v8, v10
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fsub_v16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vle16.v v12, (a1)
; ZVFHMIN-NEXT:    vle16.v v16, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfsub.vv v8, v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v8
; ZVFHMIN-NEXT:    vse16.v v12, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <16 x half>, ptr %x
  %b = load <16 x half>, ptr %y
  %c = fsub <16 x half> %a, %b
  store <16 x half> %c, ptr %x
  ret void
}

define void @fsub_v8f32(ptr %x, ptr %y) {
; CHECK-LABEL: fsub_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v10, (a1)
; CHECK-NEXT:    vfsub.vv v8, v8, v10
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %b = load <8 x float>, ptr %y
  %c = fsub <8 x float> %a, %b
  store <8 x float> %c, ptr %x
  ret void
}

define void @fsub_v4f64(ptr %x, ptr %y) {
; CHECK-LABEL: fsub_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v10, (a1)
; CHECK-NEXT:    vfsub.vv v8, v8, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x double>, ptr %x
  %b = load <4 x double>, ptr %y
  %c = fsub <4 x double> %a, %b
  store <4 x double> %c, ptr %x
  ret void
}

define void @fmul_v16bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fmul_v16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v12, (a1)
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v8
; CHECK-NEXT:    vse16.v v12, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x bfloat>, ptr %x
  %b = load <16 x bfloat>, ptr %y
  %c = fmul <16 x bfloat> %a, %b
  store <16 x bfloat> %c, ptr %x
  ret void
}

define void @fmul_v16f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fmul_v16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v10, (a1)
; ZVFH-NEXT:    vfmul.vv v8, v8, v10
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmul_v16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vle16.v v12, (a1)
; ZVFHMIN-NEXT:    vle16.v v16, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v8
; ZVFHMIN-NEXT:    vse16.v v12, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <16 x half>, ptr %x
  %b = load <16 x half>, ptr %y
  %c = fmul <16 x half> %a, %b
  store <16 x half> %c, ptr %x
  ret void
}

define void @fmul_v8f32(ptr %x, ptr %y) {
; CHECK-LABEL: fmul_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v10, (a1)
; CHECK-NEXT:    vfmul.vv v8, v8, v10
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %b = load <8 x float>, ptr %y
  %c = fmul <8 x float> %a, %b
  store <8 x float> %c, ptr %x
  ret void
}

define void @fmul_v4f64(ptr %x, ptr %y) {
; CHECK-LABEL: fmul_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v10, (a1)
; CHECK-NEXT:    vfmul.vv v8, v8, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x double>, ptr %x
  %b = load <4 x double>, ptr %y
  %c = fmul <4 x double> %a, %b
  store <4 x double> %c, ptr %x
  ret void
}

define void @fdiv_v16bf16(ptr %x, ptr %y) {
; CHECK-LABEL: fdiv_v16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v12, (a1)
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v8
; CHECK-NEXT:    vse16.v v12, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x bfloat>, ptr %x
  %b = load <16 x bfloat>, ptr %y
  %c = fdiv <16 x bfloat> %a, %b
  store <16 x bfloat> %c, ptr %x
  ret void
}

define void @fdiv_v16f16(ptr %x, ptr %y) {
; ZVFH-LABEL: fdiv_v16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v10, (a1)
; ZVFH-NEXT:    vfdiv.vv v8, v8, v10
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fdiv_v16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vle16.v v12, (a1)
; ZVFHMIN-NEXT:    vle16.v v16, (a0)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfdiv.vv v8, v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v8
; ZVFHMIN-NEXT:    vse16.v v12, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <16 x half>, ptr %x
  %b = load <16 x half>, ptr %y
  %c = fdiv <16 x half> %a, %b
  store <16 x half> %c, ptr %x
  ret void
}

define void @fdiv_v8f32(ptr %x, ptr %y) {
; CHECK-LABEL: fdiv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v10, (a1)
; CHECK-NEXT:    vfdiv.vv v8, v8, v10
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %b = load <8 x float>, ptr %y
  %c = fdiv <8 x float> %a, %b
  store <8 x float> %c, ptr %x
  ret void
}

define void @fdiv_v4f64(ptr %x, ptr %y) {
; CHECK-LABEL: fdiv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v10, (a1)
; CHECK-NEXT:    vfdiv.vv v8, v8, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x double>, ptr %x
  %b = load <4 x double>, ptr %y
  %c = fdiv <4 x double> %a, %b
  store <4 x double> %c, ptr %x
  ret void
}

define void @fneg_v16bf16(ptr %x) {
; CHECK-LABEL: fneg_v16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    vxor.vx v8, v8, a1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x bfloat>, ptr %x
  %b = fneg <16 x bfloat> %a
  store <16 x bfloat> %b, ptr %x
  ret void
}

define void @fneg_v16f16(ptr %x) {
; ZVFH-LABEL: fneg_v16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfneg.v v8, v8
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fneg_v16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vxor.vx v8, v8, a1
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <16 x half>, ptr %x
  %b = fneg <16 x half> %a
  store <16 x half> %b, ptr %x
  ret void
}

define void @fneg_v8f32(ptr %x) {
; CHECK-LABEL: fneg_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfneg.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %b = fneg <8 x float> %a
  store <8 x float> %b, ptr %x
  ret void
}

define void @fneg_v4f64(ptr %x) {
; CHECK-LABEL: fneg_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfneg.v v8, v8
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x double>, ptr %x
  %b = fneg <4 x double> %a
  store <4 x double> %b, ptr %x
  ret void
}

define void @fma_v16bf16(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fma_v16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v12, (a2)
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vle16.v v20, (a1)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v16
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v20
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmadd.vv v16, v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x bfloat>, ptr %x
  %b = load <16 x bfloat>, ptr %y
  %c = load <16 x bfloat>, ptr %z
  %d = call <16 x bfloat> @llvm.fma.v16bf16(<16 x bfloat> %a, <16 x bfloat> %b, <16 x bfloat> %c)
  store <16 x bfloat> %d, ptr %x
  ret void
}

define void @fma_v16f16(ptr %x, ptr %y, ptr %z) {
; ZVFH-LABEL: fma_v16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v10, (a1)
; ZVFH-NEXT:    vle16.v v12, (a2)
; ZVFH-NEXT:    vfmacc.vv v12, v8, v10
; ZVFH-NEXT:    vse16.v v12, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fma_v16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vle16.v v12, (a2)
; ZVFHMIN-NEXT:    vle16.v v16, (a0)
; ZVFHMIN-NEXT:    vle16.v v20, (a1)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v16
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v20
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v16, v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <16 x half>, ptr %x
  %b = load <16 x half>, ptr %y
  %c = load <16 x half>, ptr %z
  %d = call <16 x half> @llvm.fma.v16f16(<16 x half> %a, <16 x half> %b, <16 x half> %c)
  store <16 x half> %d, ptr %x
  ret void
}

define void @fma_v8f32(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fma_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v10, (a1)
; CHECK-NEXT:    vle32.v v12, (a2)
; CHECK-NEXT:    vfmacc.vv v12, v8, v10
; CHECK-NEXT:    vse32.v v12, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %b = load <8 x float>, ptr %y
  %c = load <8 x float>, ptr %z
  %d = call <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %c)
  store <8 x float> %d, ptr %x
  ret void
}

define void @fma_v4f64(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fma_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v10, (a1)
; CHECK-NEXT:    vle64.v v12, (a2)
; CHECK-NEXT:    vfmacc.vv v12, v8, v10
; CHECK-NEXT:    vse64.v v12, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x double>, ptr %x
  %b = load <4 x double>, ptr %y
  %c = load <4 x double>, ptr %z
  %d = call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %c)
  store <4 x double> %d, ptr %x
  ret void
}

define void @fadd_vf_v8bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fadd_vf_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <8 x bfloat> %b, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %d = fadd <8 x bfloat> %a, %c
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fadd_vf_v6bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fadd_vf_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = insertelement <6 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <6 x bfloat> %b, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %d = fadd <6 x bfloat> %a, %c
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fadd_vf_v8f16(ptr %x, half %y) {
; ZVFH-LABEL: fadd_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfadd.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fadd_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fadd <8 x half> %a, %c
  store <8 x half> %d, ptr %x
  ret void
}

define void @fadd_vf_v6f16(ptr %x, half %y) {
; ZVFH-LABEL: fadd_vf_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfadd.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fadd_vf_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = insertelement <6 x half> poison, half %y, i32 0
  %c = shufflevector <6 x half> %b, <6 x half> poison, <6 x i32> zeroinitializer
  %d = fadd <6 x half> %a, %c
  store <6 x half> %d, ptr %x
  ret void
}

define void @fadd_vf_v4f32(ptr %x, float %y) {
; CHECK-LABEL: fadd_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fadd <4 x float> %a, %c
  store <4 x float> %d, ptr %x
  ret void
}

define void @fadd_vf_v2f64(ptr %x, double %y) {
; CHECK-LABEL: fadd_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fadd <2 x double> %a, %c
  store <2 x double> %d, ptr %x
  ret void
}

define void @fadd_fv_v8bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fadd_fv_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <8 x bfloat> %b, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %d = fadd <8 x bfloat> %c, %a
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fadd_fv_v6bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fadd_fv_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = insertelement <6 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <6 x bfloat> %b, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %d = fadd <6 x bfloat> %c, %a
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fadd_fv_v8f16(ptr %x, half %y) {
; ZVFH-LABEL: fadd_fv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfadd.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fadd_fv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fadd <8 x half> %c, %a
  store <8 x half> %d, ptr %x
  ret void
}

define void @fadd_fv_v6f16(ptr %x, half %y) {
; ZVFH-LABEL: fadd_fv_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfadd.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fadd_fv_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = insertelement <6 x half> poison, half %y, i32 0
  %c = shufflevector <6 x half> %b, <6 x half> poison, <6 x i32> zeroinitializer
  %d = fadd <6 x half> %c, %a
  store <6 x half> %d, ptr %x
  ret void
}

define void @fadd_fv_v4f32(ptr %x, float %y) {
; CHECK-LABEL: fadd_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fadd <4 x float> %c, %a
  store <4 x float> %d, ptr %x
  ret void
}

define void @fadd_fv_v2f64(ptr %x, double %y) {
; CHECK-LABEL: fadd_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fadd <2 x double> %c, %a
  store <2 x double> %d, ptr %x
  ret void
}

define void @fsub_vf_v8bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fsub_vf_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsub.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <8 x bfloat> %b, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %d = fsub <8 x bfloat> %a, %c
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fsub_vf_v6bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fsub_vf_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsub.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = insertelement <6 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <6 x bfloat> %b, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %d = fsub <6 x bfloat> %a, %c
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fsub_vf_v8f16(ptr %x, half %y) {
; ZVFH-LABEL: fsub_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfsub.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fsub_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsub.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fsub <8 x half> %a, %c
  store <8 x half> %d, ptr %x
  ret void
}

define void @fsub_vf_v6f16(ptr %x, half %y) {
; ZVFH-LABEL: fsub_vf_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfsub.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fsub_vf_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsub.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = insertelement <6 x half> poison, half %y, i32 0
  %c = shufflevector <6 x half> %b, <6 x half> poison, <6 x i32> zeroinitializer
  %d = fsub <6 x half> %a, %c
  store <6 x half> %d, ptr %x
  ret void
}

define void @fsub_vf_v4f32(ptr %x, float %y) {
; CHECK-LABEL: fsub_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfsub.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fsub <4 x float> %a, %c
  store <4 x float> %d, ptr %x
  ret void
}

define void @fsub_vf_v2f64(ptr %x, double %y) {
; CHECK-LABEL: fsub_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfsub.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fsub <2 x double> %a, %c
  store <2 x double> %d, ptr %x
  ret void
}

define void @fsub_fv_v8bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fsub_fv_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsub.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <8 x bfloat> %b, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %d = fsub <8 x bfloat> %c, %a
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fsub_fv_v6bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fsub_fv_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsub.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = insertelement <6 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <6 x bfloat> %b, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %d = fsub <6 x bfloat> %c, %a
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fsub_fv_v8f16(ptr %x, half %y) {
; ZVFH-LABEL: fsub_fv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfrsub.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fsub_fv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsub.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fsub <8 x half> %c, %a
  store <8 x half> %d, ptr %x
  ret void
}

define void @fsub_fv_v6f16(ptr %x, half %y) {
; ZVFH-LABEL: fsub_fv_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfrsub.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fsub_fv_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsub.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = insertelement <6 x half> poison, half %y, i32 0
  %c = shufflevector <6 x half> %b, <6 x half> poison, <6 x i32> zeroinitializer
  %d = fsub <6 x half> %c, %a
  store <6 x half> %d, ptr %x
  ret void
}

define void @fsub_fv_v4f32(ptr %x, float %y) {
; CHECK-LABEL: fsub_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfrsub.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fsub <4 x float> %c, %a
  store <4 x float> %d, ptr %x
  ret void
}

define void @fsub_fv_v2f64(ptr %x, double %y) {
; CHECK-LABEL: fsub_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfrsub.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fsub <2 x double> %c, %a
  store <2 x double> %d, ptr %x
  ret void
}

define void @fmul_vf_v8bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fmul_vf_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <8 x bfloat> %b, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %d = fmul <8 x bfloat> %a, %c
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fmul_vf_v6bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fmul_vf_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = insertelement <6 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <6 x bfloat> %b, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %d = fmul <6 x bfloat> %a, %c
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fmul_vf_v8f16(ptr %x, half %y) {
; ZVFH-LABEL: fmul_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfmul.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmul_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fmul <8 x half> %a, %c
  store <8 x half> %d, ptr %x
  ret void
}

define void @fmul_vf_v6f16(ptr %x, half %y) {
; ZVFH-LABEL: fmul_vf_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfmul.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmul_vf_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = insertelement <6 x half> poison, half %y, i32 0
  %c = shufflevector <6 x half> %b, <6 x half> poison, <6 x i32> zeroinitializer
  %d = fmul <6 x half> %a, %c
  store <6 x half> %d, ptr %x
  ret void
}

define void @fmul_vf_v4f32(ptr %x, float %y) {
; CHECK-LABEL: fmul_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fmul <4 x float> %a, %c
  store <4 x float> %d, ptr %x
  ret void
}

define void @fmul_vf_v2f64(ptr %x, double %y) {
; CHECK-LABEL: fmul_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fmul <2 x double> %a, %c
  store <2 x double> %d, ptr %x
  ret void
}

define void @fmul_fv_v8bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fmul_fv_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <8 x bfloat> %b, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %d = fmul <8 x bfloat> %c, %a
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fmul_fv_v6bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fmul_fv_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = insertelement <6 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <6 x bfloat> %b, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %d = fmul <6 x bfloat> %c, %a
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fmul_fv_v8f16(ptr %x, half %y) {
; ZVFH-LABEL: fmul_fv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfmul.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmul_fv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fmul <8 x half> %c, %a
  store <8 x half> %d, ptr %x
  ret void
}

define void @fmul_fv_v6f16(ptr %x, half %y) {
; ZVFH-LABEL: fmul_fv_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfmul.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmul_fv_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = insertelement <6 x half> poison, half %y, i32 0
  %c = shufflevector <6 x half> %b, <6 x half> poison, <6 x i32> zeroinitializer
  %d = fmul <6 x half> %c, %a
  store <6 x half> %d, ptr %x
  ret void
}

define void @fmul_fv_v4f32(ptr %x, float %y) {
; CHECK-LABEL: fmul_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fmul <4 x float> %c, %a
  store <4 x float> %d, ptr %x
  ret void
}

define void @fmul_fv_v2f64(ptr %x, double %y) {
; CHECK-LABEL: fmul_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fmul <2 x double> %c, %a
  store <2 x double> %d, ptr %x
  ret void
}

define void @fdiv_vf_v8bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fdiv_vf_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <8 x bfloat> %b, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %d = fdiv <8 x bfloat> %a, %c
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fdiv_vf_v6bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fdiv_vf_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = insertelement <6 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <6 x bfloat> %b, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %d = fdiv <6 x bfloat> %a, %c
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fdiv_vf_v8f16(ptr %x, half %y) {
; ZVFH-LABEL: fdiv_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfdiv.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fdiv_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfdiv.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fdiv <8 x half> %a, %c
  store <8 x half> %d, ptr %x
  ret void
}

define void @fdiv_vf_v6f16(ptr %x, half %y) {
; ZVFH-LABEL: fdiv_vf_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfdiv.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fdiv_vf_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfdiv.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = insertelement <6 x half> poison, half %y, i32 0
  %c = shufflevector <6 x half> %b, <6 x half> poison, <6 x i32> zeroinitializer
  %d = fdiv <6 x half> %a, %c
  store <6 x half> %d, ptr %x
  ret void
}

define void @fdiv_vf_v4f32(ptr %x, float %y) {
; CHECK-LABEL: fdiv_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fdiv <4 x float> %a, %c
  store <4 x float> %d, ptr %x
  ret void
}

define void @fdiv_vf_v2f64(ptr %x, double %y) {
; CHECK-LABEL: fdiv_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fdiv <2 x double> %a, %c
  store <2 x double> %d, ptr %x
  ret void
}

define void @fdiv_fv_v8bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fdiv_fv_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <8 x bfloat> %b, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %d = fdiv <8 x bfloat> %c, %a
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fdiv_fv_v6bf16(ptr %x, bfloat %y) {
; CHECK-LABEL: fdiv_fv_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v12, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = insertelement <6 x bfloat> poison, bfloat %y, i32 0
  %c = shufflevector <6 x bfloat> %b, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %d = fdiv <6 x bfloat> %c, %a
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fdiv_fv_v8f16(ptr %x, half %y) {
; ZVFH-LABEL: fdiv_fv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfrdiv.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fdiv_fv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfdiv.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fdiv <8 x half> %c, %a
  store <8 x half> %d, ptr %x
  ret void
}

define void @fdiv_fv_v6f16(ptr %x, half %y) {
; ZVFH-LABEL: fdiv_fv_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vfrdiv.vf v8, v8, fa0
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fdiv_fv_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v12, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfdiv.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = insertelement <6 x half> poison, half %y, i32 0
  %c = shufflevector <6 x half> %b, <6 x half> poison, <6 x i32> zeroinitializer
  %d = fdiv <6 x half> %c, %a
  store <6 x half> %d, ptr %x
  ret void
}

define void @fdiv_fv_v4f32(ptr %x, float %y) {
; CHECK-LABEL: fdiv_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfrdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fdiv <4 x float> %c, %a
  store <4 x float> %d, ptr %x
  ret void
}

define void @fdiv_fv_v2f64(ptr %x, double %y) {
; CHECK-LABEL: fdiv_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfrdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fdiv <2 x double> %c, %a
  store <2 x double> %d, ptr %x
  ret void
}

define void @fma_vf_v8bf16(ptr %x, ptr %y, bfloat %z) {
; CHECK-LABEL: fma_vf_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v14, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = insertelement <8 x bfloat> poison, bfloat %z, i32 0
  %d = shufflevector <8 x bfloat> %c, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %e = call <8 x bfloat> @llvm.fma.v8bf16(<8 x bfloat> %a, <8 x bfloat> %d, <8 x bfloat> %b)
  store <8 x bfloat> %e, ptr %x
  ret void
}

define void @fma_vf_v6bf16(ptr %x, ptr %y, bfloat %z) {
; CHECK-LABEL: fma_vf_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v14, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = insertelement <6 x bfloat> poison, bfloat %z, i32 0
  %d = shufflevector <6 x bfloat> %c, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %e = call <6 x bfloat> @llvm.fma.v6bf16(<6 x bfloat> %a, <6 x bfloat> %d, <6 x bfloat> %b)
  store <6 x bfloat> %e, ptr %x
  ret void
}

define void @fma_vf_v8f16(ptr %x, ptr %y, half %z) {
; ZVFH-LABEL: fma_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfmacc.vf v9, fa0, v8
; ZVFH-NEXT:    vse16.v v9, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fma_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v14, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = insertelement <8 x half> poison, half %z, i32 0
  %d = shufflevector <8 x half> %c, <8 x half> poison, <8 x i32> zeroinitializer
  %e = call <8 x half> @llvm.fma.v8f16(<8 x half> %a, <8 x half> %d, <8 x half> %b)
  store <8 x half> %e, ptr %x
  ret void
}

define void @fma_vf_v6f16(ptr %x, ptr %y, half %z) {
; ZVFH-LABEL: fma_vf_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfmacc.vf v9, fa0, v8
; ZVFH-NEXT:    vse16.v v9, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fma_vf_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v14, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = insertelement <6 x half> poison, half %z, i32 0
  %d = shufflevector <6 x half> %c, <6 x half> poison, <6 x i32> zeroinitializer
  %e = call <6 x half> @llvm.fma.v6f16(<6 x half> %a, <6 x half> %d, <6 x half> %b)
  store <6 x half> %e, ptr %x
  ret void
}

define void @fma_vf_v4f32(ptr %x, ptr %y, float %z) {
; CHECK-LABEL: fma_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse32.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = insertelement <4 x float> poison, float %z, i32 0
  %d = shufflevector <4 x float> %c, <4 x float> poison, <4 x i32> zeroinitializer
  %e = call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %d, <4 x float> %b)
  store <4 x float> %e, ptr %x
  ret void
}

define void @fma_vf_v2f64(ptr %x, ptr %y, double %z) {
; CHECK-LABEL: fma_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse64.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = insertelement <2 x double> poison, double %z, i32 0
  %d = shufflevector <2 x double> %c, <2 x double> poison, <2 x i32> zeroinitializer
  %e = call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %d, <2 x double> %b)
  store <2 x double> %e, ptr %x
  ret void
}

define void @fma_fv_v8bf16(ptr %x, ptr %y, bfloat %z) {
; CHECK-LABEL: fma_fv_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v14, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = insertelement <8 x bfloat> poison, bfloat %z, i32 0
  %d = shufflevector <8 x bfloat> %c, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %e = call <8 x bfloat> @llvm.fma.v8bf16(<8 x bfloat> %d, <8 x bfloat> %a, <8 x bfloat> %b)
  store <8 x bfloat> %e, ptr %x
  ret void
}

define void @fma_fv_v6bf16(ptr %x, ptr %y, bfloat %z) {
; CHECK-LABEL: fma_fv_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    fmv.x.w a1, fa0
; CHECK-NEXT:    vmv.v.x v14, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = insertelement <6 x bfloat> poison, bfloat %z, i32 0
  %d = shufflevector <6 x bfloat> %c, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %e = call <6 x bfloat> @llvm.fma.v6bf16(<6 x bfloat> %d, <6 x bfloat> %a, <6 x bfloat> %b)
  store <6 x bfloat> %e, ptr %x
  ret void
}

define void @fma_fv_v8f16(ptr %x, ptr %y, half %z) {
; ZVFH-LABEL: fma_fv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfmacc.vf v9, fa0, v8
; ZVFH-NEXT:    vse16.v v9, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fma_fv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v14, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = insertelement <8 x half> poison, half %z, i32 0
  %d = shufflevector <8 x half> %c, <8 x half> poison, <8 x i32> zeroinitializer
  %e = call <8 x half> @llvm.fma.v8f16(<8 x half> %d, <8 x half> %a, <8 x half> %b)
  store <8 x half> %e, ptr %x
  ret void
}

define void @fma_fv_v6f16(ptr %x, ptr %y, half %z) {
; ZVFH-LABEL: fma_fv_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfmacc.vf v9, fa0, v8
; ZVFH-NEXT:    vse16.v v9, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fma_fv_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    fmv.x.w a1, fa0
; ZVFHMIN-NEXT:    vmv.v.x v14, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = insertelement <6 x half> poison, half %z, i32 0
  %d = shufflevector <6 x half> %c, <6 x half> poison, <6 x i32> zeroinitializer
  %e = call <6 x half> @llvm.fma.v6f16(<6 x half> %d, <6 x half> %a, <6 x half> %b)
  store <6 x half> %e, ptr %x
  ret void
}

define void @fma_fv_v4f32(ptr %x, ptr %y, float %z) {
; CHECK-LABEL: fma_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse32.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = insertelement <4 x float> poison, float %z, i32 0
  %d = shufflevector <4 x float> %c, <4 x float> poison, <4 x i32> zeroinitializer
  %e = call <4 x float> @llvm.fma.v4f32(<4 x float> %d, <4 x float> %a, <4 x float> %b)
  store <4 x float> %e, ptr %x
  ret void
}

define void @fma_fv_v2f64(ptr %x, ptr %y, double %z) {
; CHECK-LABEL: fma_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse64.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = insertelement <2 x double> poison, double %z, i32 0
  %d = shufflevector <2 x double> %c, <2 x double> poison, <2 x i32> zeroinitializer
  %e = call <2 x double> @llvm.fma.v2f64(<2 x double> %d, <2 x double> %a, <2 x double> %b)
  store <2 x double> %e, ptr %x
  ret void
}

define void @fmsub_vf_v8bf16(ptr %x, ptr %y, bfloat %z) {
; CHECK-LABEL: fmsub_vf_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmv.x.w a2, fa0
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    vmv.v.x v14, a2
; CHECK-NEXT:    vxor.vx v12, v8, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = insertelement <8 x bfloat> poison, bfloat %z, i32 0
  %d = shufflevector <8 x bfloat> %c, <8 x bfloat> poison, <8 x i32> zeroinitializer
  %neg = fneg <8 x bfloat> %b
  %e = call <8 x bfloat> @llvm.fma.v8bf16(<8 x bfloat> %a, <8 x bfloat> %d, <8 x bfloat> %neg)
  store <8 x bfloat> %e, ptr %x
  ret void
}

define void @fmsub_vf_v6bf16(ptr %x, ptr %y, bfloat %z) {
; CHECK-LABEL: fmsub_vf_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmv.x.w a2, fa0
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    vmv.v.x v14, a2
; CHECK-NEXT:    vxor.vx v12, v8, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v14
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmadd.vv v12, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = insertelement <6 x bfloat> poison, bfloat %z, i32 0
  %d = shufflevector <6 x bfloat> %c, <6 x bfloat> poison, <6 x i32> zeroinitializer
  %neg = fneg <6 x bfloat> %b
  %e = call <6 x bfloat> @llvm.fma.v6bf16(<6 x bfloat> %a, <6 x bfloat> %d, <6 x bfloat> %neg)
  store <6 x bfloat> %e, ptr %x
  ret void
}

define void @fmsub_vf_v8f16(ptr %x, ptr %y, half %z) {
; ZVFH-LABEL: fmsub_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfmsac.vf v9, fa0, v8
; ZVFH-NEXT:    vse16.v v9, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmsub_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.w a2, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a1)
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vmv.v.x v14, a2
; ZVFHMIN-NEXT:    vxor.vx v12, v8, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = insertelement <8 x half> poison, half %z, i32 0
  %d = shufflevector <8 x half> %c, <8 x half> poison, <8 x i32> zeroinitializer
  %neg = fneg <8 x half> %b
  %e = call <8 x half> @llvm.fma.v8f16(<8 x half> %a, <8 x half> %d, <8 x half> %neg)
  store <8 x half> %e, ptr %x
  ret void
}

define void @fmsub_vf_v6f16(ptr %x, ptr %y, half %z) {
; ZVFH-LABEL: fmsub_vf_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vfmsac.vf v9, fa0, v8
; ZVFH-NEXT:    vse16.v v9, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmsub_vf_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.w a2, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v8, (a1)
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vmv.v.x v14, a2
; ZVFHMIN-NEXT:    vxor.vx v12, v8, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmadd.vv v12, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    vse16.v v8, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = insertelement <6 x half> poison, half %z, i32 0
  %d = shufflevector <6 x half> %c, <6 x half> poison, <6 x i32> zeroinitializer
  %neg = fneg <6 x half> %b
  %e = call <6 x half> @llvm.fma.v6f16(<6 x half> %a, <6 x half> %d, <6 x half> %neg)
  store <6 x half> %e, ptr %x
  ret void
}

define void @fnmsub_vf_v4f32(ptr %x, ptr %y, float %z) {
; CHECK-LABEL: fnmsub_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfnmsac.vf v9, fa0, v8
; CHECK-NEXT:    vse32.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = insertelement <4 x float> poison, float %z, i32 0
  %d = shufflevector <4 x float> %c, <4 x float> poison, <4 x i32> zeroinitializer
  %neg = fneg <4 x float> %a
  %e = call <4 x float> @llvm.fma.v4f32(<4 x float> %neg, <4 x float> %d, <4 x float> %b)
  store <4 x float> %e, ptr %x
  ret void
}

define void @fnmadd_vf_v2f64(ptr %x, ptr %y, double %z) {
; CHECK-LABEL: fnmadd_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfnmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse64.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = insertelement <2 x double> poison, double %z, i32 0
  %d = shufflevector <2 x double> %c, <2 x double> poison, <2 x i32> zeroinitializer
  %neg = fneg <2 x double> %a
  %neg2 = fneg <2 x double> %b
  %e = call <2 x double> @llvm.fma.v2f64(<2 x double> %neg, <2 x double> %d, <2 x double> %neg2)
  store <2 x double> %e, ptr %x
  ret void
}

define void @fnmsub_fv_v4f32(ptr %x, ptr %y, float %z) {
; CHECK-LABEL: fnmsub_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfnmsac.vf v9, fa0, v8
; CHECK-NEXT:    vse32.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = insertelement <4 x float> poison, float %z, i32 0
  %d = shufflevector <4 x float> %c, <4 x float> poison, <4 x i32> zeroinitializer
  %neg = fneg <4 x float> %d
  %e = call <4 x float> @llvm.fma.v4f32(<4 x float> %neg, <4 x float> %a, <4 x float> %b)
  store <4 x float> %e, ptr %x
  ret void
}

define void @fnmadd_fv_v2f64(ptr %x, ptr %y, double %z) {
; CHECK-LABEL: fnmadd_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfnmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse64.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = insertelement <2 x double> poison, double %z, i32 0
  %d = shufflevector <2 x double> %c, <2 x double> poison, <2 x i32> zeroinitializer
  %neg = fneg <2 x double> %d
  %neg2 = fneg <2 x double> %b
  %e = call <2 x double> @llvm.fma.v2f64(<2 x double> %neg, <2 x double> %a, <2 x double> %neg2)
  store <2 x double> %e, ptr %x
  ret void
}

define void @trunc_v8bf16(ptr %x) {
; CHECK-LABEL: trunc_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    vfcvt.rtz.x.f.v v10, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = call <8 x bfloat> @llvm.trunc.v8bf16(<8 x bfloat> %a)
  store <8 x bfloat> %b, ptr %x
  ret void
}

define void @trunc_v6bf16(ptr %x) {
; CHECK-LABEL: trunc_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    vfcvt.rtz.x.f.v v10, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = call <6 x bfloat> @llvm.trunc.v6bf16(<6 x bfloat> %a)
  store <6 x bfloat> %b, ptr %x
  ret void
}

define void @trunc_v8f16(ptr %x) {
; ZVFH-LABEL: trunc_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI171_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI171_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    vfcvt.rtz.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: trunc_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    vfcvt.rtz.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = call <8 x half> @llvm.trunc.v8f16(<8 x half> %a)
  store <8 x half> %b, ptr %x
  ret void
}

define void @trunc_v6f16(ptr %x) {
; ZVFH-LABEL: trunc_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI172_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI172_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    vfcvt.rtz.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: trunc_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    vfcvt.rtz.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = call <6 x half> @llvm.trunc.v6f16(<6 x half> %a)
  store <6 x half> %b, ptr %x
  ret void
}

define void @trunc_v4f32(ptr %x) {
; CHECK-LABEL: trunc_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = call <4 x float> @llvm.trunc.v4f32(<4 x float> %a)
  store <4 x float> %b, ptr %x
  ret void
}

define void @trunc_v2f64(ptr %x) {
; CHECK-LABEL: trunc_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI174_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI174_0)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = call <2 x double> @llvm.trunc.v2f64(<2 x double> %a)
  store <2 x double> %b, ptr %x
  ret void
}

define void @ceil_v8bf16(ptr %x) {
; CHECK-LABEL: ceil_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    fsrmi a1, 3
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = call <8 x bfloat> @llvm.ceil.v8bf16(<8 x bfloat> %a)
  store <8 x bfloat> %b, ptr %x
  ret void
}

define void @ceil_v6bf16(ptr %x) {
; CHECK-LABEL: ceil_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    fsrmi a1, 3
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = call <6 x bfloat> @llvm.ceil.v6bf16(<6 x bfloat> %a)
  store <6 x bfloat> %b, ptr %x
  ret void
}

define void @ceil_v8f16(ptr %x) {
; ZVFH-LABEL: ceil_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI177_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI177_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    fsrmi a1, 3
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a1
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: ceil_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    fsrmi a1, 3
; ZVFHMIN-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    fsrm a1
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = call <8 x half> @llvm.ceil.v8f16(<8 x half> %a)
  store <8 x half> %b, ptr %x
  ret void
}

define void @ceil_v6f16(ptr %x) {
; ZVFH-LABEL: ceil_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI178_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI178_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    fsrmi a1, 3
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a1
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: ceil_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    fsrmi a1, 3
; ZVFHMIN-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    fsrm a1
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = call <6 x half> @llvm.ceil.v6f16(<6 x half> %a)
  store <6 x half> %b, ptr %x
  ret void
}

define void @ceil_v4f32(ptr %x) {
; CHECK-LABEL: ceil_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    fsrmi a1, 3
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = call <4 x float> @llvm.ceil.v4f32(<4 x float> %a)
  store <4 x float> %b, ptr %x
  ret void
}

define void @ceil_v2f64(ptr %x) {
; CHECK-LABEL: ceil_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI180_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI180_0)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    fsrmi a1, 3
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = call <2 x double> @llvm.ceil.v2f64(<2 x double> %a)
  store <2 x double> %b, ptr %x
  ret void
}

define void @floor_v8bf16(ptr %x) {
; CHECK-LABEL: floor_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    fsrmi a1, 2
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = call <8 x bfloat> @llvm.floor.v8bf16(<8 x bfloat> %a)
  store <8 x bfloat> %b, ptr %x
  ret void
}

define void @floor_v6bf16(ptr %x) {
; CHECK-LABEL: floor_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    fsrmi a1, 2
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = call <6 x bfloat> @llvm.floor.v6bf16(<6 x bfloat> %a)
  store <6 x bfloat> %b, ptr %x
  ret void
}

define void @floor_v8f16(ptr %x) {
; ZVFH-LABEL: floor_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI183_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI183_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    fsrmi a1, 2
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a1
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: floor_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    fsrmi a1, 2
; ZVFHMIN-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    fsrm a1
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = call <8 x half> @llvm.floor.v8f16(<8 x half> %a)
  store <8 x half> %b, ptr %x
  ret void
}

define void @floor_v6f16(ptr %x) {
; ZVFH-LABEL: floor_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI184_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI184_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    fsrmi a1, 2
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a1
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: floor_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    fsrmi a1, 2
; ZVFHMIN-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    fsrm a1
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = call <6 x half> @llvm.floor.v6f16(<6 x half> %a)
  store <6 x half> %b, ptr %x
  ret void
}

define void @floor_v4f32(ptr %x) {
; CHECK-LABEL: floor_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    fsrmi a1, 2
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = call <4 x float> @llvm.floor.v4f32(<4 x float> %a)
  store <4 x float> %b, ptr %x
  ret void
}

define void @floor_v2f64(ptr %x) {
; CHECK-LABEL: floor_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI186_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI186_0)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    fsrmi a1, 2
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = call <2 x double> @llvm.floor.v2f64(<2 x double> %a)
  store <2 x double> %b, ptr %x
  ret void
}

define void @round_v8bf16(ptr %x) {
; CHECK-LABEL: round_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    fsrmi a1, 4
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = call <8 x bfloat> @llvm.round.v8bf16(<8 x bfloat> %a)
  store <8 x bfloat> %b, ptr %x
  ret void
}

define void @round_v6bf16(ptr %x) {
; CHECK-LABEL: round_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    fsrmi a1, 4
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = call <6 x bfloat> @llvm.round.v6bf16(<6 x bfloat> %a)
  store <6 x bfloat> %b, ptr %x
  ret void
}

define void @round_v8f16(ptr %x) {
; ZVFH-LABEL: round_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI189_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI189_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    fsrmi a1, 4
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a1
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: round_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    fsrmi a1, 4
; ZVFHMIN-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    fsrm a1
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = call <8 x half> @llvm.round.v8f16(<8 x half> %a)
  store <8 x half> %b, ptr %x
  ret void
}

define void @round_v6f16(ptr %x) {
; ZVFH-LABEL: round_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI190_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI190_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    fsrmi a1, 4
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a1
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: round_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    fsrmi a1, 4
; ZVFHMIN-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    fsrm a1
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = call <6 x half> @llvm.round.v6f16(<6 x half> %a)
  store <6 x half> %b, ptr %x
  ret void
}

define void @round_v4f32(ptr %x) {
; CHECK-LABEL: round_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    fsrmi a1, 4
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = call <4 x float> @llvm.round.v4f32(<4 x float> %a)
  store <4 x float> %b, ptr %x
  ret void
}

define void @round_v2f64(ptr %x) {
; CHECK-LABEL: round_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI192_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI192_0)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    fsrmi a1, 4
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a1
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = call <2 x double> @llvm.round.v2f64(<2 x double> %a)
  store <2 x double> %b, ptr %x
  ret void
}

define void @rint_v8bf16(ptr %x) {
; CHECK-LABEL: rint_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = call <8 x bfloat> @llvm.rint.v8bf16(<8 x bfloat> %a)
  store <8 x bfloat> %b, ptr %x
  ret void
}

define void @rint_v8f16(ptr %x) {
; ZVFH-LABEL: rint_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI194_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI194_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: rint_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = call <8 x half> @llvm.rint.v8f16(<8 x half> %a)
  store <8 x half> %b, ptr %x
  ret void
}

define void @rint_v4f32(ptr %x) {
; CHECK-LABEL: rint_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = call <4 x float> @llvm.rint.v4f32(<4 x float> %a)
  store <4 x float> %b, ptr %x
  ret void
}

define void @rint_v2f64(ptr %x) {
; CHECK-LABEL: rint_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI196_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI196_0)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = call <2 x double> @llvm.rint.v2f64(<2 x double> %a)
  store <2 x double> %b, ptr %x
  ret void
}

define void @nearbyint_v8bf16(ptr %x) {
; CHECK-LABEL: nearbyint_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    frflags a1
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    fsflags a1
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = call <8 x bfloat> @llvm.nearbyint.v8bf16(<8 x bfloat> %a)
  store <8 x bfloat> %b, ptr %x
  ret void
}

define void @nearbyint_v8f16(ptr %x) {
; ZVFH-LABEL: nearbyint_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    lui a1, %hi(.LCPI198_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI198_0)(a1)
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    frflags a1
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    fsflags a1
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vse16.v v8, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: nearbyint_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a0)
; ZVFHMIN-NEXT:    lui a1, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a1
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v10, v8
; ZVFHMIN-NEXT:    vmflt.vf v0, v10, fa5
; ZVFHMIN-NEXT:    frflags a1
; ZVFHMIN-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFHMIN-NEXT:    fsflags a1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = call <8 x half> @llvm.nearbyint.v8f16(<8 x half> %a)
  store <8 x half> %b, ptr %x
  ret void
}

define void @nearbyint_v4f32(ptr %x) {
; CHECK-LABEL: nearbyint_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a1, 307200
; CHECK-NEXT:    fmv.w.x fa5, a1
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    frflags a1
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    fsflags a1
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = call <4 x float> @llvm.nearbyint.v4f32(<4 x float> %a)
  store <4 x float> %b, ptr %x
  ret void
}

define void @nearbyint_v2f64(ptr %x) {
; CHECK-LABEL: nearbyint_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI200_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI200_0)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    frflags a1
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    fsflags a1
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = call <2 x double> @llvm.nearbyint.v2f64(<2 x double> %a)
  store <2 x double> %b, ptr %x
  ret void
}

define void @fmuladd_v8bf16(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fmuladd_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vle16.v v13, (a2)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = load <8 x bfloat>, ptr %z
  %d = call <8 x bfloat> @llvm.fmuladd.v8bf16(<8 x bfloat> %a, <8 x bfloat> %b, <8 x bfloat> %c)
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fmuladd_v6bf16(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fmuladd_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vle16.v v13, (a2)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = load <6 x bfloat>, ptr %z
  %d = call <6 x bfloat> @llvm.fmuladd.v6bf16(<6 x bfloat> %a, <6 x bfloat> %b, <6 x bfloat> %c)
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fmuladd_v8f16(ptr %x, ptr %y, ptr %z) {
; ZVFH-LABEL: fmuladd_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vle16.v v10, (a2)
; ZVFH-NEXT:    vfmacc.vv v10, v8, v9
; ZVFH-NEXT:    vse16.v v10, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmuladd_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vle16.v v13, (a2)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v13
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = load <8 x half>, ptr %z
  %d = call <8 x half> @llvm.fmuladd.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c)
  store <8 x half> %d, ptr %x
  ret void
}

define void @fmuladd_v6f16(ptr %x, ptr %y, ptr %z) {
; ZVFH-LABEL: fmuladd_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vle16.v v10, (a2)
; ZVFH-NEXT:    vfmacc.vv v10, v8, v9
; ZVFH-NEXT:    vse16.v v10, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmuladd_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vle16.v v13, (a2)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v13
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = load <6 x half>, ptr %z
  %d = call <6 x half> @llvm.fmuladd.v6f16(<6 x half> %a, <6 x half> %b, <6 x half> %c)
  store <6 x half> %d, ptr %x
  ret void
}

define void @fmuladd_v4f32(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fmuladd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vle32.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse32.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = load <4 x float>, ptr %z
  %d = call <4 x float> @llvm.fmuladd.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c)
  store <4 x float> %d, ptr %x
  ret void
}

define void @fmuladd_v2f64(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fmuladd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vle64.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse64.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = load <2 x double>, ptr %z
  %d = call <2 x double> @llvm.fmuladd.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  store <2 x double> %d, ptr %x
  ret void
}

define void @fmsub_fmuladd_v8bf16(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fmsub_fmuladd_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vle16.v v13, (a2)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsub.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x bfloat>, ptr %x
  %b = load <8 x bfloat>, ptr %y
  %c = load <8 x bfloat>, ptr %z
  %neg = fneg <8 x bfloat> %c
  %d = call <8 x bfloat> @llvm.fmuladd.v8bf16(<8 x bfloat> %a, <8 x bfloat> %b, <8 x bfloat> %neg)
  store <8 x bfloat> %d, ptr %x
  ret void
}

define void @fmsub_fmuladd_v6bf16(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fmsub_fmuladd_v6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vle16.v v13, (a2)
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmul.vv v8, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsub.vv v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x bfloat>, ptr %x
  %b = load <6 x bfloat>, ptr %y
  %c = load <6 x bfloat>, ptr %z
  %neg = fneg <6 x bfloat> %c
  %d = call <6 x bfloat> @llvm.fmuladd.v6bf16(<6 x bfloat> %a, <6 x bfloat> %b, <6 x bfloat> %neg)
  store <6 x bfloat> %d, ptr %x
  ret void
}

define void @fmsub_fmuladd_v8f16(ptr %x, ptr %y, ptr %z) {
; ZVFH-LABEL: fmsub_fmuladd_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vle16.v v10, (a2)
; ZVFH-NEXT:    vfmsac.vv v10, v8, v9
; ZVFH-NEXT:    vse16.v v10, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmsub_fmuladd_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vle16.v v13, (a2)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v13
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsub.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %b = load <8 x half>, ptr %y
  %c = load <8 x half>, ptr %z
  %neg = fneg <8 x half> %c
  %d = call <8 x half> @llvm.fmuladd.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %neg)
  store <8 x half> %d, ptr %x
  ret void
}

define void @fmsub_fmuladd_v6f16(ptr %x, ptr %y, ptr %z) {
; ZVFH-LABEL: fmsub_fmuladd_v6f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFH-NEXT:    vle16.v v8, (a0)
; ZVFH-NEXT:    vle16.v v9, (a1)
; ZVFH-NEXT:    vle16.v v10, (a2)
; ZVFH-NEXT:    vfmsac.vv v10, v8, v9
; ZVFH-NEXT:    vse16.v v10, (a0)
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fmsub_fmuladd_v6f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vle16.v v10, (a1)
; ZVFHMIN-NEXT:    vle16.v v12, (a0)
; ZVFHMIN-NEXT:    vle16.v v13, (a2)
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmul.vv v8, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v13
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfsub.vv v8, v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vse16.v v10, (a0)
; ZVFHMIN-NEXT:    ret
  %a = load <6 x half>, ptr %x
  %b = load <6 x half>, ptr %y
  %c = load <6 x half>, ptr %z
  %neg = fneg <6 x half> %c
  %d = call <6 x half> @llvm.fmuladd.v6f16(<6 x half> %a, <6 x half> %b, <6 x half> %neg)
  store <6 x half> %d, ptr %x
  ret void
}

define void @fnmsub_fmuladd_v4f32(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fnmsub_fmuladd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vle32.v v10, (a2)
; CHECK-NEXT:    vfnmsac.vv v10, v8, v9
; CHECK-NEXT:    vse32.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %x
  %b = load <4 x float>, ptr %y
  %c = load <4 x float>, ptr %z
  %neg = fneg <4 x float> %a
  %d = call <4 x float> @llvm.fmuladd.v4f32(<4 x float> %neg, <4 x float> %b, <4 x float> %c)
  store <4 x float> %d, ptr %x
  ret void
}

define void @fnmadd_fmuladd_v2f64(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: fnmadd_fmuladd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vle64.v v10, (a2)
; CHECK-NEXT:    vfnmacc.vv v10, v8, v9
; CHECK-NEXT:    vse64.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %b = load <2 x double>, ptr %y
  %c = load <2 x double>, ptr %z
  %neg = fneg <2 x double> %b
  %neg2 = fneg <2 x double> %c
  %d = call <2 x double> @llvm.fmuladd.v2f64(<2 x double> %a, <2 x double> %neg, <2 x double> %neg2)
  store <2 x double> %d, ptr %x
  ret void
}
