/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.NamedElementComparator;
import org.eclipse.fordiac.ide.model.data.AnyElementaryType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STContinue;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExit;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STReturn;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.AccessMode;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.EditorDocumentChange;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.STCoreRefactoringUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.resource.XtextLiveScopeResourceSetProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;

public class ExtractCallableRefactoring
extends Refactoring {
    @Inject
    private XtextLiveScopeResourceSetProvider resourceSetProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;
    private String name = Messages.ExtractCallableRefactoring_Name;
    private XtextEditor editor;
    private ITextSelection selection;
    private String lineSeparator;
    private XtextResource resourceCopy;
    private List<EObject> selectedSemanticElements;
    private ITextRegion selectedSemanticElementsRegion;
    private Optional<String> selectedSemanticElementsText = Optional.empty();
    private Optional<ICallable> callable = Optional.empty();
    private Optional<STSource> source = Optional.empty();
    private String callableType = "FUNCTION";
    private String callableName = "CALLABLE";
    private AccessMode referencedReturnVariable = AccessMode.NONE;
    private Map<STVarDeclaration, AccessMode> referencedLocalVariables = Collections.emptyMap();
    private Optional<LibraryElement> returnType = Optional.empty();
    private List<STVarDeclaration> inputParameters = Collections.emptyList();
    private List<STVarDeclaration> outputParameters = Collections.emptyList();
    private List<STVarDeclaration> inoutParameters = Collections.emptyList();

    public void initialize(XtextEditor editor, ITextSelection selection) {
        this.editor = editor;
        this.selection = selection;
        this.lineSeparator = this.whitespaceInformationProvider.getLineSeparatorInformation(editor.getDocument().getResourceURI()).getLineSeparator();
        this.resourceCopy = (XtextResource)editor.getDocument().priorityReadOnly(this::copyResource);
        this.selectedSemanticElements = this.findSelectedSemanticObjects();
        this.selectedSemanticElementsRegion = this.calculateSelectedSemanticElementsRegion();
        this.selectedSemanticElementsText = this.calculateSelectedSemanticElementsText();
        this.callable = this.calculateCallable();
        this.source = this.calculateSource();
        this.callableName = this.calculateCallableName();
        this.referencedReturnVariable = this.calculateReferencedReturnVariable();
        this.referencedLocalVariables = this.calculateReferencedLocalVariables();
        this.returnType = this.calculateReturnType();
        this.inputParameters = this.calculateParameters(AccessMode.READ);
        this.outputParameters = this.calculateParameters(AccessMode.WRITE);
        this.inoutParameters = this.calculateParameters(AccessMode.READ_WRITE);
    }

    protected XtextResource copyResource(XtextResource resource) {
        IProject project = ExtractCallableRefactoring.getProject(resource.getURI());
        ResourceSet resourceSet = this.resourceSetProvider.get(project);
        return (XtextResource)resourceSet.getResource(resource.getURI(), true);
    }

    protected List<EObject> findSelectedSemanticObjects() {
        ITextSelection trimmedSelection = STCoreRefactoringUtil.trimSelection(this.selection);
        EObject semanticObject = STCoreRefactoringUtil.findSelectedSemanticObject(this.resourceCopy, trimmedSelection);
        if (semanticObject instanceof STExpression) {
            return List.of(semanticObject);
        }
        if (semanticObject != null) {
            return STCoreRefactoringUtil.findSelectedChildSemanticObjectsOfType(semanticObject, trimmedSelection, STStatement.class);
        }
        return Collections.emptyList();
    }

    protected ITextRegion calculateSelectedSemanticElementsRegion() {
        ICompositeNode rootNode = this.resourceCopy.getParseResult().getRootNode();
        ITextSelection trimmedSelection = STCoreRefactoringUtil.trimSelection(this.selection);
        TextRegion trimmedSelectedRegion = new TextRegion(trimmedSelection.getOffset(), trimmedSelection.getLength());
        ITextRegion alignedSelectedRegion = STCoreRefactoringUtil.alignRegion((ITextRegion)trimmedSelectedRegion, rootNode);
        return this.selectedSemanticElements.stream().map(NodeModelUtils::findActualNodeFor).map(INode::getTextRegion).reduce(ITextRegion::merge).map(region -> region.merge(alignedSelectedRegion)).map(region -> STCoreRefactoringUtil.trimRegion(region, rootNode)).orElse(ITextRegion.EMPTY_REGION);
    }

    protected Optional<String> calculateSelectedSemanticElementsText() {
        try {
            return Optional.of(this.editor.getDocument().get(this.selectedSemanticElementsRegion.getOffset(), this.selectedSemanticElementsRegion.getLength()));
        }
        catch (BadLocationException e) {
            return Optional.empty();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.selectedSemanticElements.isEmpty()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_InvalidSelection));
        } else if (this.selectedSemanticElementsRegion.getLength() == 0) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_RegionNotFound));
        } else if (this.selectedSemanticElementsText.isEmpty()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_TextNotFound));
        } else if (this.callable.isEmpty()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_CallableNotFound));
        } else if (this.source.isEmpty()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_SourceNotFound));
        }
        result.merge(this.checkReturnType());
        result.merge(this.checkReturnVariableAccess());
        result.merge(this.checkControlFlowStatements());
        return result;
    }

    protected RefactoringStatus checkReturnType() {
        RefactoringStatus result = new RefactoringStatus();
        if (this.getSelectedSingleExpression().isPresent() && this.returnType.isEmpty()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_ReturnTypeNotPresent));
        } else if (!this.returnType.stream().allMatch(AnyElementaryType.class::isInstance)) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_InvalidReturnType));
        }
        return result;
    }

    protected RefactoringStatus checkReturnVariableAccess() {
        RefactoringStatus result = new RefactoringStatus();
        switch (this.referencedReturnVariable) {
            case READ: 
            case READ_WRITE: {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_InvalidReturnVariableAccess));
                break;
            }
            case WRITE: {
                result.merge(RefactoringStatus.createWarningStatus((String)Messages.ExtractCallableRefactoring_ReturnVariableAccessMayChangeSemantics));
                break;
            }
        }
        return result;
    }

    protected RefactoringStatus checkControlFlowStatements() {
        RefactoringStatus result = new RefactoringStatus();
        if (!this.isCallableControlFlowContained() || !this.isLoopControlFlowContained()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_ControlFlowError));
        }
        return result;
    }

    protected boolean isCallableControlFlowContained() {
        TreeIterator iterator = EcoreUtil.getAllProperContents(this.selectedSemanticElements, (boolean)true);
        while (iterator.hasNext()) {
            EObject elem = (EObject)iterator.next();
            if (!(elem instanceof STReturn)) continue;
            return false;
        }
        return true;
    }

    protected boolean isLoopControlFlowContained() {
        TreeIterator iterator = EcoreUtil.getAllProperContents(this.selectedSemanticElements, (boolean)true);
        while (iterator.hasNext()) {
            EObject elem = (EObject)iterator.next();
            if (elem instanceof STForStatement || elem instanceof STRepeatStatement || elem instanceof STWhileStatement) {
                iterator.prune();
                continue;
            }
            if (!(elem instanceof STContinue) && !(elem instanceof STExit)) continue;
            return false;
        }
        return true;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkCallableName());
        return result;
    }

    protected RefactoringStatus checkCallableName() {
        RefactoringStatus result = new RefactoringStatus();
        if (this.callableName.isBlank()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_NameNotProvided));
        } else if (IdentifierVerifier.verifyIdentifier((String)this.callableName).isPresent()) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_InvalidName));
        } else if (this.source.stream().flatMap(s -> EcoreUtil2.getAllContentsOfType((EObject)s, ICallable.class).stream()).anyMatch(c -> Objects.equals(c.getName(), this.callableName))) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractCallableRefactoring_NameNotUnique));
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        EditorDocumentChange change = new EditorDocumentChange(this.getName(), (IEditorPart)this.editor, this.editor.getDocumentProvider(), false);
        change.setEdit(this.createTextEdit());
        change.setTextType(this.editor.getDocument().getResourceURI().fileExtension());
        return change;
    }

    protected TextEdit createTextEdit() {
        MultiTextEdit textEdit = new MultiTextEdit();
        textEdit.addChild(this.createCallTextEdit());
        textEdit.addChild(this.createCallableTextEdit());
        return textEdit;
    }

    protected TextEdit createCallTextEdit() {
        StringBuilder callExpression = new StringBuilder();
        if (this.getSelectedSingleExpression().isEmpty() && this.returnType.isPresent()) {
            callExpression.append(this.callable.map(INamedElement::getName).orElse(""));
            callExpression.append(" := ");
        }
        callExpression.append(this.getCallableName());
        callExpression.append("(");
        callExpression.append(Stream.concat(Stream.concat(this.inputParameters.stream(), this.inoutParameters.stream()).map(parameter -> parameter.getName() + " := " + parameter.getName()), this.outputParameters.stream().map(parameter -> parameter.getName() + " => " + parameter.getName())).collect(Collectors.joining(", ")));
        callExpression.append(")");
        if (this.getSelectedSingleExpression().isEmpty()) {
            callExpression.append(";");
        }
        return new ReplaceEdit(this.selectedSemanticElementsRegion.getOffset(), this.selectedSemanticElementsRegion.getLength(), callExpression.toString());
    }

    protected TextEdit createCallableTextEdit() {
        StringBuilder callableText = new StringBuilder();
        callableText.append(this.lineSeparator);
        this.generateCallableHeader(callableText);
        this.generateCallableBody(callableText);
        this.generateCallableFooter(callableText);
        return new ReplaceEdit(this.calculateInsertPosition(), 0, callableText.toString());
    }

    protected int calculateInsertPosition() {
        return this.callable.map(arg_0 -> ((ILocationInFileProvider)this.locationInFileProvider).getFullTextRegion(arg_0)).map(region -> region.getOffset() + region.getLength()).orElse(this.editor.getDocument().getLength());
    }

    protected void generateCallableHeader(StringBuilder builder) {
        builder.append(this.lineSeparator);
        builder.append(this.getCallableType());
        builder.append(" ");
        builder.append(this.getCallableName());
        if (this.returnType.isPresent()) {
            builder.append(": ");
            builder.append(this.returnType.get().getName());
        }
        builder.append(this.lineSeparator);
        this.generateCallableParameters("INPUT", this.inputParameters, builder);
        this.generateCallableParameters("IN_OUT", this.inoutParameters, builder);
        this.generateCallableParameters("OUTPUT", this.outputParameters, builder);
    }

    protected void generateCallableParameters(String type, List<STVarDeclaration> parameters, StringBuilder builder) {
        if (!parameters.isEmpty()) {
            builder.append("VAR_");
            builder.append(type);
            builder.append(this.lineSeparator);
            for (STVarDeclaration param : parameters) {
                builder.append("    ");
                builder.append(param.getName());
                builder.append(": ");
                builder.append(STCoreUtil.getFeatureType((INamedElement)param).getName());
                builder.append(";");
                builder.append(this.lineSeparator);
            }
            builder.append("END_VAR");
            builder.append(this.lineSeparator);
        }
    }

    protected void generateCallableBody(StringBuilder builder) {
        Optional<STExpression> singleExpression = this.getSelectedSingleExpression();
        if (singleExpression.isPresent()) {
            builder.append(this.getCallableName());
            builder.append(" := ");
            builder.append(this.getRefactoredSelectedSemanticElementsText().orElse(""));
            builder.append(";");
            builder.append(this.lineSeparator);
        } else {
            builder.append(this.getRefactoredSelectedSemanticElementsText().orElse(""));
            builder.append(this.lineSeparator);
        }
    }

    protected Optional<String> getRefactoredSelectedSemanticElementsText() {
        return this.selectedSemanticElementsText.map(this::performSelectedSemanticElementsReplacements);
    }

    protected String performSelectedSemanticElementsReplacements(String text) {
        StringBuilder result = new StringBuilder(text);
        this.getSelectedSemanticElementsReplacements().stream().sorted((a, b) -> Integer.compare(b.getOffset(), a.getOffset())).forEachOrdered(repl -> repl.applyTo(result));
        return result.toString();
    }

    protected List<ReplaceRegion> getSelectedSemanticElementsReplacements() {
        ArrayList<ReplaceRegion> result = new ArrayList<ReplaceRegion>();
        this.selectedSemanticElements.stream().flatMap(elem -> EcoreUtil2.getAllContentsOfType((EObject)elem, STFeatureExpression.class).stream()).filter(this::isReturnVariableReference).map(NodeModelUtils::findActualNodeFor).map(INode::getTextRegion).map(region -> new ReplaceRegion(region.getOffset() - this.selectedSemanticElementsRegion.getOffset(), region.getLength(), this.callableName)).forEachOrdered(result::add);
        return result;
    }

    protected void generateCallableFooter(StringBuilder builder) {
        builder.append("END_");
        builder.append(this.getCallableType());
        builder.append(this.lineSeparator);
    }

    protected Optional<ICallable> calculateCallable() {
        if (!this.selectedSemanticElements.isEmpty()) {
            return Optional.ofNullable((ICallable)EcoreUtil2.getContainerOfType((EObject)this.selectedSemanticElements.get(0), ICallable.class));
        }
        return Optional.empty();
    }

    protected Optional<STSource> calculateSource() {
        return this.callable.flatMap(c -> Optional.ofNullable((STSource)EcoreUtil2.getContainerOfType((EObject)c, STSource.class)));
    }

    protected String calculateCallableName() {
        Set usedNames = this.source.stream().flatMap(s -> EcoreUtil2.getAllContentsOfType((EObject)s, ICallable.class).stream()).map(INamedElement::getName).collect(Collectors.toSet());
        String name = this.callable.map(INamedElement::getName).orElse(this.callableType);
        return IntStream.range(1, Integer.MAX_VALUE).mapToObj(i -> name + "_" + i).filter(Predicate.not(usedNames::contains)).findFirst().orElse("");
    }

    protected AccessMode calculateReferencedReturnVariable() {
        return this.selectedSemanticElements.stream().flatMap(elem -> EcoreUtil2.getAllContentsOfType((EObject)elem, STFeatureExpression.class).stream()).filter(this::isReturnVariableReference).map(STCoreUtil::getAccessMode).reduce(AccessMode::merge).orElse(AccessMode.NONE);
    }

    protected boolean isReturnVariableReference(STFeatureExpression expression) {
        return expression.getFeature() instanceof ICallable && !expression.isCall() && EcoreUtil2.getContainerOfType((EObject)expression.getFeature(), ICallable.class) == this.callable.orElse(null);
    }

    protected Map<STVarDeclaration, AccessMode> calculateReferencedLocalVariables() {
        return this.selectedSemanticElements.stream().flatMap(elem -> EcoreUtil2.getAllContentsOfType((EObject)elem, STFeatureExpression.class).stream()).filter(this::isLocalVariableReference).collect(Collectors.toMap(expr -> (STVarDeclaration)expr.getFeature(), STCoreUtil::getAccessMode, AccessMode::merge));
    }

    protected boolean isLocalVariableReference(STFeatureExpression expression) {
        return expression.getFeature() instanceof STVarDeclaration && EcoreUtil2.getContainerOfType((EObject)expression.getFeature(), ICallable.class) == this.callable.orElse(null);
    }

    protected Optional<LibraryElement> calculateReturnType() {
        if (this.referencedReturnVariable != AccessMode.NONE) {
            return this.callable.map(ICallable::getReturnType);
        }
        return this.getSelectedSingleExpression().map(STExpression::getResultType);
    }

    protected List<STVarDeclaration> calculateParameters(AccessMode mode) {
        return this.referencedLocalVariables.entrySet().stream().filter(entry -> entry.getValue() == mode).map(Map.Entry::getKey).sorted((Comparator<STVarDeclaration>)NamedElementComparator.INSTANCE).toList();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public XtextEditor getEditor() {
        return this.editor;
    }

    public ITextSelection getSelection() {
        return this.selection;
    }

    protected XtextResource getResourceCopy() {
        return this.resourceCopy;
    }

    protected List<EObject> getSelectedSemanticElements() {
        return this.selectedSemanticElements;
    }

    protected ITextRegion getSelectedSemanticElementsRegion() {
        return this.selectedSemanticElementsRegion;
    }

    protected Optional<String> getSelectedSemanticElementsText() {
        return this.selectedSemanticElementsText;
    }

    protected Optional<STExpression> getSelectedSingleExpression() {
        if (this.selectedSemanticElements.size() == 1) {
            return this.selectedSemanticElements.stream().filter(STExpression.class::isInstance).map(STExpression.class::cast).filter(expr -> STCoreUtil.getAccessMode((STExpression)expr) != AccessMode.NONE).findAny();
        }
        return Optional.empty();
    }

    protected Stream<STStatement> getSelectedStatements() {
        return this.selectedSemanticElements.stream().filter(STStatement.class::isInstance).map(STStatement.class::cast);
    }

    protected Optional<ICallable> getCallable() {
        return this.callable;
    }

    protected Optional<STSource> getSource() {
        return this.source;
    }

    public String getCallableType() {
        return this.callableType;
    }

    public void setCallableType(String callableType) {
        this.callableType = callableType;
    }

    public String getCallableName() {
        return this.callableName;
    }

    public void setCallableName(String callableName) {
        this.callableName = callableName;
    }

    protected AccessMode getReferencedReturnVariable() {
        return this.referencedReturnVariable;
    }

    protected Map<STVarDeclaration, AccessMode> getReferencedLocalVariables() {
        return this.referencedLocalVariables;
    }

    public Optional<LibraryElement> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Optional<LibraryElement> returnType) {
        this.returnType = returnType;
    }

    public List<STVarDeclaration> getInputParameters() {
        return this.inputParameters;
    }

    public List<STVarDeclaration> getOutputParameters() {
        return this.outputParameters;
    }

    public List<STVarDeclaration> getInoutParameters() {
        return this.inoutParameters;
    }

    protected static IProject getProject(URI uri) {
        IFile file = ExtractCallableRefactoring.getFile(uri);
        if (file != null && file.exists()) {
            return file.getProject();
        }
        return null;
    }

    protected static IFile getFile(URI uri) {
        if (uri.isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }
}

