/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.fb;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.fordiac.ide.debug.LaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.fb.FBDebugClockMode;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.value.DateAndTimeValueConverter;
import org.eclipse.fordiac.ide.model.value.TimeValueConverter;

public interface FBLaunchConfigurationAttributes
extends LaunchConfigurationAttributes {
    public static final String ID = "org.eclipse.fordiac.ide.debug.fbLaunch";
    public static final String EVENT = "org.eclipse.fordiac.ide.debug.event";
    public static final String REPEAT_EVENT = "org.eclipse.fordiac.ide.debug.repeatEvent";
    public static final String KEEP_RUNNING_WHEN_IDLE = "org.eclipse.fordiac.ide.debug.keepRunningWhenIdle";
    public static final String CLOCK_MODE = "org.eclipse.fordiac.ide.debug.clockMode";
    public static final String CLOCK_INTERVAL = "org.eclipse.fordiac.ide.debug.clockInterval";
    public static final String CLOCK_REALTIME_OFFSET = "org.eclipse.fordiac.ide.debug.clockRealtimeOffset";
    public static final String CLOCK_MONOTONIC_OFFSET = "org.eclipse.fordiac.ide.debug.clockMonotonicOffset";

    public static Event getEvent(ILaunchConfiguration configuration, FBType type, Event defaultEvent) throws CoreException {
        String eventAttribute = configuration.getAttribute(EVENT, "");
        if (eventAttribute != null && !eventAttribute.isEmpty()) {
            Event event = type.getInterfaceList().getEvent(eventAttribute);
            if (event != null && event.isIsInput()) {
                return event;
            }
            return Stream.concat(type.getInterfaceList().getSockets().stream(), type.getInterfaceList().getPlugs().stream()).map(AdapterDeclaration::getAdapterFB).map(BlockFBNetworkElement::getInterface).map(iface -> iface.getEvent(eventAttribute)).filter(Objects::nonNull).filter(Predicate.not(IInterfaceElement::isIsInput)).findAny().orElse(defaultEvent);
        }
        return defaultEvent;
    }

    public static boolean isRepeatEvent(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(REPEAT_EVENT, false);
    }

    public static boolean isKeepRunningWhenIdle(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(KEEP_RUNNING_WHEN_IDLE, true);
    }

    public static FBDebugClockMode getClockMode(ILaunchConfiguration configuration) throws CoreException {
        String modeAttribute = configuration.getAttribute(CLOCK_MODE, null);
        if (modeAttribute != null) {
            try {
                return FBDebugClockMode.valueOf(modeAttribute);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(Status.error((String)"Invalid value for clock mode"));
            }
        }
        return FBDebugClockMode.SYSTEM;
    }

    public static Duration getClockInterval(ILaunchConfiguration configuration) throws CoreException {
        String value = configuration.getAttribute(CLOCK_INTERVAL, null);
        if (value != null) {
            try {
                return TimeValueConverter.INSTANCE.toValue(value);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(Status.error((String)"Invalid value for clock interval", (Throwable)e));
            }
        }
        return Duration.ZERO;
    }

    public static Instant getClockRealtimeOffset(ILaunchConfiguration configuration) throws CoreException {
        String value = configuration.getAttribute(CLOCK_REALTIME_OFFSET, null);
        if (value != null) {
            try {
                return DateAndTimeValueConverter.INSTANCE.toValue(value).toInstant(ZoneOffset.UTC);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(Status.error((String)"Invalid value for clock monotonic offset", (Throwable)e));
            }
        }
        return Instant.EPOCH;
    }

    public static Instant getClockMonotonicOffset(ILaunchConfiguration configuration) throws CoreException {
        String value = configuration.getAttribute(CLOCK_MONOTONIC_OFFSET, null);
        if (value != null) {
            try {
                Duration duration = TimeValueConverter.INSTANCE.toValue(value);
                return Instant.ofEpochSecond(duration.getSeconds(), duration.getNano());
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(Status.error((String)"Invalid value for clock monotonic offset", (Throwable)e));
            }
        }
        return Instant.EPOCH;
    }

    public static String getClockIntervalText(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(CLOCK_INTERVAL, "1s");
    }

    public static String getClockRealtimeOffsetText(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(CLOCK_REALTIME_OFFSET, "1970-01-01-00:00:00.000");
    }

    public static String getClockMonotonicOffsetText(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(CLOCK_MONOTONIC_OFFSET, "0s");
    }
}

