/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.gef.commands.Command;

public class ChangeConnectionCommentCommand
extends Command
implements ScopedCommand {
    private final Connection connection;
    private final String newComment;
    private String oldComment;

    public ChangeConnectionCommentCommand(Connection connection, String comment) {
        this.connection = Objects.requireNonNull(connection);
        this.newComment = comment != null ? comment : "";
    }

    public String getComment() {
        return this.newComment;
    }

    public void execute() {
        this.oldComment = this.connection.getComment();
        this.connection.setComment(this.newComment);
    }

    public void undo() {
        this.connection.setComment(this.oldComment);
    }

    public void redo() {
        this.connection.setComment(this.newComment);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.connection);
    }
}

