/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.InternalDataType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableEvaluator;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpressionSource;
import org.eclipse.xtext.EcoreUtil2;

public class AttributeEvaluator
extends StructuredTextEvaluator
implements VariableEvaluator {
    private final Attribute attribute;
    private STInitializerExpressionSource parseResult;

    public AttributeEvaluator(Attribute attribute, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(attribute.getName(), context, variables, parent);
        this.attribute = attribute;
    }

    public void prepare() {
        if (this.parseResult == null && this.attribute.getType() instanceof AnyType && this.attribute.getValue() != null && !this.attribute.getValue().isBlank()) {
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            ArrayList<String> infos = new ArrayList<String>();
            this.parseResult = this.parseInitialValue(errors, warnings, infos);
            errors.forEach(error -> this.error("Parse error: " + error));
            warnings.forEach(warning -> this.error("Parse warning: " + warning));
            infos.forEach(info -> this.error("Parse info: " + info));
            if (this.parseResult == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
        }
    }

    public void cleanup() {
        this.parseResult = null;
    }

    protected STInitializerExpressionSource parseInitialValue(List<String> errors, List<String> warnings, List<String> infos) {
        return StructuredTextParseUtil.parse((String)this.attribute.getValue(), (URI)(this.attribute.eResource() != null ? this.attribute.eResource().getURI() : null), (LibraryElement)this.attribute.getType(), (LibraryElement)((LibraryElement)EcoreUtil2.getContainerOfType((EObject)this.attribute, LibraryElement.class)), null, errors, warnings, infos);
    }

    public Value evaluate() throws EvaluatorException, InterruptedException {
        return this.evaluateVariable().getValue();
    }

    public Variable<?> evaluateVariable() throws EvaluatorException, InterruptedException {
        this.prepare();
        Variable result = VariableOperations.newVariable((String)this.attribute.getName(), (LibraryElement)this.evaluateResultType());
        if (this.parseResult != null && this.parseResult.getInitializerExpression() != null) {
            this.evaluateInitializerExpression(result, ((STInitializerExpressionSource)this.trap(this.parseResult)).getInitializerExpression());
        } else if (this.attribute.getType() instanceof InternalDataType && this.attribute.getValue() != null) {
            result.setValue(ValueOperations.wrapValue((Object)this.attribute.getValue(), (LibraryElement)result.getType()));
        }
        return result;
    }

    public boolean validateVariable(List<String> errors, List<String> warnings, List<String> infos) throws EvaluatorException, InterruptedException {
        if (this.attribute.getType() instanceof AnyType && this.attribute.getValue() != null && !this.attribute.getValue().isBlank()) {
            return this.parseInitialValue(errors, warnings, infos) != null;
        }
        return true;
    }

    public LibraryElement evaluateResultType() throws EvaluatorException, InterruptedException {
        WstringType wstringType;
        DataType dataType = this.attribute.getType();
        if (dataType instanceof AnyType) {
            AnyType resultType = (AnyType)dataType;
            wstringType = resultType;
        } else {
            wstringType = IecTypes.ElementaryTypes.WSTRING;
        }
        return wstringType;
    }

    public boolean validateResultType(List<String> errors, List<String> warnings, List<String> infos) throws EvaluatorException, InterruptedException {
        return true;
    }

    public Set<String> getDependencies() {
        return Stream.concat(this.getTypeDependencies().stream(), this.getInitialValueDependencies().stream()).collect(Collectors.toSet());
    }

    protected Set<String> getTypeDependencies() {
        if (this.attribute.getAttributeDeclaration() != null) {
            return Set.of(PackageNameHelper.getFullTypeName((LibraryElement)this.attribute.getAttributeDeclaration()));
        }
        if (this.attribute.getType() instanceof AnyType) {
            return Set.of(PackageNameHelper.getFullTypeName((LibraryElement)this.attribute.getType()));
        }
        return Collections.emptySet();
    }

    protected Set<String> getInitialValueDependencies() {
        this.prepare();
        if (this.parseResult != null) {
            return StructuredTextParseUtil.collectUsedTypes((EObject)this.parseResult);
        }
        return Collections.emptySet();
    }

    public Object getSourceElement() {
        return this.attribute;
    }
}

