/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.plugin;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;

public class EvaluatorFactoryRegistryReader {
    public static final String FACTORY_ID = "factory";
    public static final String ATT_CLASS = "class";
    public static final String ATT_VARIANT = "variant";
    public static final String ATT_TYPE = "type";
    public static final String CHILD_SOURCE = "source";

    public void readRegistry() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.fordiac.ide.model.eval", FACTORY_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.readFactory(element);
            ++n2;
        }
    }

    private void readFactory(IConfigurationElement element) {
        EvaluatorFactory factory = null;
        try {
            factory = (EvaluatorFactory)element.createExecutableExtension(ATT_CLASS);
        }
        catch (Exception e) {
            this.log(element, "The factory instance could not be created", e);
        }
        if (factory != null) {
            IConfigurationElement[] sources;
            String variant = element.getAttribute(ATT_VARIANT);
            IConfigurationElement[] iConfigurationElementArray = sources = element.getChildren(CHILD_SOURCE);
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement source = iConfigurationElementArray[n2];
                this.readSource(element, factory, variant, source);
                ++n2;
            }
        }
    }

    private void readSource(IConfigurationElement element, EvaluatorFactory factory, String variant, IConfigurationElement source) {
        EvaluatorFactory previousFactory;
        String type = source.getAttribute(ATT_TYPE);
        Class sourceClass = null;
        try {
            sourceClass = CommonPlugin.loadClass((String)element.getDeclaringExtension().getContributor().getName(), (String)type);
        }
        catch (ClassNotFoundException e) {
            this.log(element, "The factory source type attribute does not specify a valid class", e);
        }
        if (sourceClass != null && (previousFactory = EvaluatorFactory.Registry.INSTANCE.registerFactory(variant, sourceClass, factory)) != null) {
            this.log(element, String.format("A factory %s was already registered for the source type %s", previousFactory.getClass().getName(), sourceClass.getName()));
        }
    }

    private void log(IConfigurationElement element, String message) {
        Platform.getLog(this.getClass()).error(String.format("%s in extension %s from plugin %s", message, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getDeclaringExtension().getContributor().getName()));
    }

    private void log(IConfigurationElement element, String message, Throwable t) {
        Platform.getLog(this.getClass()).error(String.format("%s in extension %s from plugin %s", message, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getDeclaringExtension().getContributor().getName()), t);
    }
}

