/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.eclipse.fordiac.ide.model.data.DateAndTimeType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyDateValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class DateAndTimeValue
implements AnyDateValue {
    public static final DateAndTimeValue DEFAULT = new DateAndTimeValue(0L);
    private final long value;

    private DateAndTimeValue(long value) {
        this.value = value;
    }

    public static DateAndTimeValue toDateAndTimeValue(long value) {
        return new DateAndTimeValue(value);
    }

    public static DateAndTimeValue toDateAndTimeValue(Number value) {
        return new DateAndTimeValue(value.longValue());
    }

    public static DateAndTimeValue toDateAndTimeValue(LocalDateTime value) {
        return new DateAndTimeValue(LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC).until(value, ChronoUnit.NANOS));
    }

    public static DateAndTimeValue toDateAndTimeValue(String value) {
        return DateAndTimeValue.toDateAndTimeValue((LocalDateTime)TypedValueConverter.INSTANCE_DATE_AND_TIME.toValue(value));
    }

    public static DateAndTimeValue toDateAndTimeValue(AnyDateValue value) {
        return DateAndTimeValue.toDateAndTimeValue(value.toNanos());
    }

    public DateAndTimeType getType() {
        return IecTypes.ElementaryTypes.DATE_AND_TIME;
    }

    @Override
    public long toNanos() {
        return this.value;
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.ofEpochSecond(this.value / 1000000000L, (int)(this.value % 1000000000L), ZoneOffset.UTC);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateAndTimeValue other = (DateAndTimeValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return TypedValueConverter.INSTANCE_DATE_AND_TIME.toString((Object)this.toLocalDateTime());
    }
}

