/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.eclipse.fordiac.ide.model.data.LdateType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyDateValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class LDateValue
implements AnyDateValue {
    public static final LDateValue DEFAULT = new LDateValue(0L);
    private final long value;

    private LDateValue(long value) {
        this.value = value;
    }

    public static LDateValue toLDateValue(long value) {
        return new LDateValue(value);
    }

    public static LDateValue toLDateValue(Number value) {
        return new LDateValue(value.longValue());
    }

    public static LDateValue toLDateValue(LocalDate value) {
        return new LDateValue(value.toEpochSecond(LocalTime.MIDNIGHT, ZoneOffset.UTC) * 1000000000L);
    }

    public static LDateValue toLDateValue(String value) {
        return LDateValue.toLDateValue((LocalDate)TypedValueConverter.INSTANCE_LDATE.toValue(value));
    }

    public static LDateValue toLDateValue(AnyDateValue value) {
        return LDateValue.toLDateValue(value.toNanos());
    }

    public LdateType getType() {
        return IecTypes.ElementaryTypes.LDATE;
    }

    @Override
    public long toNanos() {
        return this.value;
    }

    public LocalDate toLocalDate() {
        return LocalDateTime.ofEpochSecond(this.value / 1000000000L, (int)(this.value % 1000000000L), ZoneOffset.UTC).toLocalDate();
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LDateValue other = (LDateValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return TypedValueConverter.INSTANCE_LDATE.toString((Object)this.toLocalDate());
    }
}

