/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import org.eclipse.fordiac.ide.model.data.LtimeType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyDurationValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class LTimeValue
implements AnyDurationValue {
    public static final LTimeValue DEFAULT = new LTimeValue(0L);
    private final long value;

    private LTimeValue(long value) {
        this.value = value;
    }

    public static LTimeValue toLTimeValue(long value) {
        return new LTimeValue(value);
    }

    public static LTimeValue toLTimeValue(Number value) {
        return new LTimeValue(value.longValue());
    }

    public static LTimeValue toLTimeValue(Duration value) {
        return new LTimeValue(value.toNanos());
    }

    public static LTimeValue toLTimeValue(String string) {
        return LTimeValue.toLTimeValue((Duration)TypedValueConverter.INSTANCE_LTIME.toValue(string));
    }

    public static LTimeValue toLTimeValue(AnyMagnitudeValue value) {
        return LTimeValue.toLTimeValue(value.longValue());
    }

    public LtimeType getType() {
        return IecTypes.ElementaryTypes.LTIME;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public Duration toDuration() {
        return Duration.ofNanos(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LTimeValue other = (LTimeValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return TypedValueConverter.INSTANCE_LTIME.toString((Object)this.toDuration());
    }
}

