/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.UlintType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyUnsignedValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class ULIntValue
implements AnyUnsignedValue {
    public static final ULIntValue DEFAULT = new ULIntValue(0L);
    private final long value;

    private ULIntValue(long value) {
        this.value = value;
    }

    public static ULIntValue toULIntValue(long value) {
        return new ULIntValue(value);
    }

    public static ULIntValue toULIntValue(Number value) {
        return new ULIntValue(value.longValue());
    }

    public static ULIntValue toULIntValue(String value) {
        return ULIntValue.toULIntValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static ULIntValue toULIntValue(AnyMagnitudeValue value) {
        return ULIntValue.toULIntValue(value.longValue());
    }

    public UlintType getType() {
        return IecTypes.ElementaryTypes.ULINT;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return new BigInteger(Long.toUnsignedString(this.value));
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.bigIntegerValue());
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ULIntValue other = (ULIntValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Long.toUnsignedString(this.value);
    }
}

