/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.widgets;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.GlobalConstantsEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class ImportSelectionProposalProvider
implements IContentProposalProvider {
    private final Supplier<TypeLibrary> supplier;

    public ImportSelectionProposalProvider(Supplier<TypeLibrary> supplier) {
        this.supplier = supplier;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        TypeLibrary typeLibrary = this.supplier.get();
        if (typeLibrary != null) {
            return (IContentProposal[])Stream.of(ImportSelectionProposalProvider.getImportableTypeNames(typeLibrary), ImportSelectionProposalProvider.getGlobalConstantImportableNames(typeLibrary), ImportSelectionProposalProvider.getWildcardImports(typeLibrary)).flatMap(Function.identity()).distinct().filter(proposal -> ImportSelectionProposalProvider.matches(proposal, contents, position)).map(this::createProposal).sorted(Comparator.comparing(IContentProposal::getLabel)).toArray(IContentProposal[]::new);
        }
        return new IContentProposal[0];
    }

    protected static Stream<String> getImportableTypeNames(TypeLibrary typeLibrary) {
        return Stream.of(typeLibrary.getDataTypeLibrary().getDerivedDataTypes(), typeLibrary.getAdapterTypes(), typeLibrary.getFbTypes(), typeLibrary.getAttributeTypes()).flatMap(Collection::stream).map(TypeEntry::getFullTypeName).filter(fullName -> fullName.contains("::")).distinct();
    }

    protected static Stream<String> getGlobalConstantImportableNames(TypeLibrary typeLibrary) {
        return typeLibrary.getGlobalConstants().stream().map(GlobalConstantsEntry::getType).filter(Objects::nonNull).flatMap(ImportSelectionProposalProvider::getGlobalConstantImportableNames);
    }

    protected static Stream<String> getGlobalConstantImportableNames(GlobalConstants globalConstants) {
        String packageName = PackageNameHelper.getPackageName((LibraryElement)globalConstants);
        if (packageName.isEmpty()) {
            return Stream.empty();
        }
        return globalConstants.getConstants().stream().map(constant -> packageName + "::" + constant.getName());
    }

    protected static Stream<String> getWildcardImports(TypeLibrary typeLibrary) {
        return typeLibrary.getPackages().stream().map(packageName -> packageName + "::*");
    }

    protected static boolean matches(String name, String prefix, int position) {
        return name.regionMatches(true, 0, prefix, 0, position);
    }

    protected ContentProposal createProposal(String importedNamespace) {
        return new ContentProposal(importedNamespace);
    }
}

