/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.stcore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum STMultiBitAccessSpecifier implements Enumerator
{
    X(0, "X", "%X"),
    B(1, "B", "%B"),
    W(2, "W", "%W"),
    D(3, "D", "%D"),
    L(4, "L", "%L");

    public static final int X_VALUE = 0;
    public static final int B_VALUE = 1;
    public static final int W_VALUE = 2;
    public static final int D_VALUE = 3;
    public static final int L_VALUE = 4;
    private static final STMultiBitAccessSpecifier[] VALUES_ARRAY;
    public static final List<STMultiBitAccessSpecifier> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new STMultiBitAccessSpecifier[]{X, B, W, D, L};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static STMultiBitAccessSpecifier get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            STMultiBitAccessSpecifier result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static STMultiBitAccessSpecifier getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            STMultiBitAccessSpecifier result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static STMultiBitAccessSpecifier get(int value) {
        switch (value) {
            case 0: {
                return X;
            }
            case 1: {
                return B;
            }
            case 2: {
                return W;
            }
            case 3: {
                return D;
            }
            case 4: {
                return L;
            }
        }
        return null;
    }

    private STMultiBitAccessSpecifier(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

