/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.model.mtl.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.utils.AcceleoASTNodeAdapter;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMtlBinaryResourceImpl
extends BinaryResourceImpl {
    private static final String POSITIONS_ANNOTATION_NAME = "positions";
    private static final String VARIABLE_PREFIX = "temp";
    private List<String> variableNames;
    private boolean trimPosition;

    public EMtlBinaryResourceImpl(URI uri) {
        super(uri);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        EAnnotation positions;
        HashMap actualOptions = new HashMap();
        if (options != null) {
            actualOptions.putAll(options);
        }
        super.doLoad(inputStream, actualOptions);
        if (!this.trimPosition && (positions = this.getPositions(false)) != null) {
            this.restorePositions(positions);
            this.getContents().remove((Object)positions);
        }
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        this.eSetDeliver(false);
        EAnnotation positions = null;
        if (!this.trimPosition) {
            positions = this.getPositions(true);
            this.fixVariablesAndPositions(positions);
        }
        try {
            super.doSave(outputStream, options);
        }
        finally {
            if (!this.trimPosition && positions != null) {
                this.getContents().remove((Object)positions);
            }
        }
        this.eSetDeliver(true);
    }

    private void fixVariablesAndPositions(EAnnotation positions) {
        this.variableNames = new ArrayList<String>();
        for (EObject content : this.getContents()) {
            if (!(content instanceof Module)) continue;
            Module eModule = (Module)content;
            TreeIterator eAllContents = eModule.eAllContents();
            while (eAllContents.hasNext()) {
                EObject eObject = (EObject)eAllContents.next();
                this.fixVariableAmbiguities(eObject);
                this.savePositions(eObject, positions);
            }
        }
        this.variableNames.clear();
        this.variableNames = null;
    }

    private void fixVariableAmbiguities(EObject element) {
        if (element instanceof Variable && ((Variable)element).getName() != null && ((Variable)element).getName().startsWith(VARIABLE_PREFIX)) {
            String varName = ((Variable)element).getName();
            if (varName != null && !varName.matches("temp\\d+")) {
                return;
            }
            if (this.variableNames.contains(varName)) {
                String lastName = this.variableNames.get(this.variableNames.size() - 1);
                int lastIndex = Integer.valueOf(lastName.substring(VARIABLE_PREFIX.length()));
                while (this.variableNames.contains(VARIABLE_PREFIX + ++lastIndex)) {
                }
                ((Variable)element).setName(VARIABLE_PREFIX + lastIndex);
                this.variableNames.add(VARIABLE_PREFIX + lastIndex);
            } else {
                this.variableNames.add(varName);
            }
        }
    }

    private void savePositions(EObject element, EAnnotation positions) {
        if (element instanceof ASTNode) {
            int start = ((ASTNode)element).getStartPosition();
            int end = ((ASTNode)element).getEndPosition();
            Adapter adapter = EcoreUtil.getAdapter((List)element.eAdapters(), AcceleoASTNodeAdapter.class);
            int line = 0;
            if (adapter instanceof AcceleoASTNodeAdapter) {
                line = ((AcceleoASTNodeAdapter)adapter).getLine();
            }
            this.savePosition(positions, (ASTNode)element, start, end, line);
        }
    }

    private void savePosition(EAnnotation positions, ASTNode node, int start, int end, int line) {
        EAnnotation position = EcoreFactory.eINSTANCE.createEAnnotation();
        position.setSource("positions." + positions.getEAnnotations().size());
        position.getReferences().add((Object)node);
        position.getDetails().put((Object)"start", (Object)String.valueOf(start));
        position.getDetails().put((Object)"end", (Object)String.valueOf(end));
        position.getDetails().put((Object)"line", (Object)String.valueOf(line));
        positions.getEAnnotations().add((Object)position);
    }

    private void restorePositions(EAnnotation positions) {
        for (EAnnotation position : positions.getEAnnotations()) {
            ASTNode node = (ASTNode)position.getReferences().get(0);
            if (node.getStartPosition() != -1 || node.getEndPosition() != -1) continue;
            try {
                int start = Integer.parseInt((String)position.getDetails().get((Object)"start"));
                int end = Integer.parseInt((String)position.getDetails().get((Object)"end"));
                String lineValue = (String)position.getDetails().get((Object)"line");
                int line = 0;
                if (lineValue != null) {
                    line = Integer.parseInt(lineValue);
                }
                node.setStartPosition(start);
                node.setEndPosition(end);
                node.eAdapters().add((Object)new AcceleoASTNodeAdapter(line));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private EAnnotation getPositions(boolean create) {
        EAnnotation positions = null;
        Iterator children = this.getContents().iterator();
        while (positions == null && children.hasNext()) {
            EObject child = (EObject)children.next();
            if (!(child instanceof EAnnotation) || !POSITIONS_ANNOTATION_NAME.equals(((EAnnotation)child).getSource())) continue;
            positions = (EAnnotation)child;
        }
        if (positions == null && create) {
            positions = EcoreFactory.eINSTANCE.createEAnnotation();
            positions.setSource(POSITIONS_ANNOTATION_NAME);
            this.getContents().add((Object)positions);
        }
        return positions;
    }

    public void setTrimPosition(boolean trimPosition) {
        this.trimPosition = trimPosition;
    }
}

