/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.validation.type.IType;

public class JavaMethodReceiverService
extends JavaMethodService {
    public JavaMethodReceiverService(Method method, boolean forWorkspace) {
        super(method, null, forWorkspace);
    }

    @Override
    public String getShortSignature() {
        Object[] parameters = this.getParameterTypes();
        return this.serviceShortSignature(parameters);
    }

    private Class<?>[] getParameterTypes() {
        Class[] parameters = new Class[((Method)this.getOrigin()).getParameterTypes().length + 1];
        int i = 0;
        parameters[i++] = ((Method)this.getOrigin()).getDeclaringClass();
        Class<?>[] classArray = ((Method)this.getOrigin()).getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            parameters[i++] = cls;
            ++n2;
        }
        return parameters;
    }

    @Override
    public String getLongSignature() {
        return super.getLongSignature() + " (receiver as first parameter)";
    }

    @Override
    public List<Set<IType>> getParameterTypes(IReadOnlyQueryEnvironment queryEnvironment) {
        ArrayList<Set<IType>> result = new ArrayList<Set<IType>>();
        Class<?>[] classArray = this.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            result.add(Collections.singleton(this.getClassType(queryEnvironment, cls)));
            ++n2;
        }
        return result;
    }

    @Override
    public int getNumberOfParameters() {
        return super.getNumberOfParameters() + 1;
    }

    @Override
    protected Object internalInvoke(Object[] arguments) throws Exception {
        Object receiver = arguments[0];
        Object[] newArguments = new Object[arguments.length - 1];
        int i = 0;
        while (i < newArguments.length) {
            newArguments[i] = arguments[i + 1];
            ++i;
        }
        return ((Method)this.getOrigin()).invoke(receiver, newArguments);
    }
}

