/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.command;

import org.eclipse.amp.escape.command.ExecuteHandler;
import org.eclipse.amp.escape.ide.EclipseEscapeRunner;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

public class ExecuteJavaHandler
extends ExecuteHandler {
    public ExecuteJavaHandler(boolean headless) {
        super(headless);
    }

    public ExecuteJavaHandler() {
        super(false);
    }

    @Override
    protected void executeOpen(EclipseEscapeRunner eclipseRunner, Object executed, IProgressMonitor monitor) {
        if (this.isSupertype(executed, "org.ascape.model.Scape")) {
            IType javaClass = this.getType(executed);
            IJavaProject javaProject = javaClass.getJavaProject();
            eclipseRunner.open((IResource)javaProject.getProject(), javaClass.getFullyQualifiedName(), javaClass.getElementName());
        }
    }

    @Override
    protected boolean handleSelect(Object sel) {
        return sel instanceof ICompilationUnit || sel instanceof IType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTypeSupertype(IType type, String className) {
        try {
            if (type == null) return false;
            ITypeHierarchy h = type.newTypeHierarchy(null);
            IType[] iTypeArray = h.getAllSupertypes(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType superType = iTypeArray[n2];
                if (superType.getFullyQualifiedName().equals(className)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public boolean isSupertype(Object sel, String className) {
        return this.isTypeSupertype(this.getType(sel), className);
    }

    public IType getType(Object object) {
        if (object instanceof ICompilationUnit) {
            return ((ICompilationUnit)object).findPrimaryType();
        }
        if (object instanceof IType) {
            return (IType)object;
        }
        return null;
    }
}

