/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw3d.ShapeFigure3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometryext.PointList3D;
import org.eclipse.draw3d.shapes.PolylineFigureShape;
import org.eclipse.draw3d.shapes.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polyline3D
extends ShapeFigure3D {
    float lineWidth = 1.0f;
    PointList3D points = new PointList3D();

    public void addPoint(IVector3f i_point) {
        this.points.add(i_point);
        this.repaint();
    }

    @Override
    protected Shape createShape() {
        return new PolylineFigureShape(this);
    }

    public IVector3f getEnd() {
        if (this.points.size() < 2) {
            throw new IndexOutOfBoundsException("pointlist is empty or contains only one point");
        }
        IVector3f pt = this.points.get(this.points.size() - 1);
        log.info("getEnd(): " + pt);
        return pt;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public ParaxialBoundingBox getParaxialBoundingBox(ParaxialBoundingBox o_result) {
        return null;
    }

    public PointList getPoints() {
        return this.points;
    }

    public PointList3D getPoints3D() {
        return this.points;
    }

    public IVector3f getStart() {
        return this.points.get(0);
    }

    public void insertPoint(IVector3f i_point, int i_index) {
        log.info("insertPoint(IVector3f, int): " + i_point + ", " + i_index);
        this.points.set(i_index, i_point);
        this.repaint();
    }

    public boolean isOpaque() {
        return false;
    }

    public void primTranslate(int x, int y) {
    }

    public void removeAllPoints() {
        this.erase();
        this.points.clear();
    }

    public void removePoint(int index) {
        this.erase();
        this.points.remove(index);
    }

    public void setEnd(IVector3f end) {
        if (this.points.size() == 0) {
            throw new IndexOutOfBoundsException("line contains no points, set start point before");
        }
        if (this.points.size() < 2) {
            this.addPoint(end);
        } else {
            this.setPoint(end, this.points.size() - 1);
        }
    }

    public void setEndpoints(IVector3f start, IVector3f end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void setLineWidth(float w) {
        if (this.lineWidth == w) {
            return;
        }
        if (w < this.lineWidth) {
            this.erase();
        }
        this.lineWidth = w;
    }

    public void setPoint(IVector3f pt, int index) {
        this.erase();
        this.points.set(index, pt);
        this.repaint();
    }

    public void setPoints(PointList i_list) {
        this.erase();
        if (i_list != this.points) {
            this.points.clear();
            this.points.addAll(i_list);
        }
        this.firePropertyChange("points", null, this.points);
        this.repaint();
        this.invalidate();
    }

    public void setPoints3D(List<IVector3f> i_list) {
        this.erase();
        if (i_list != this.points) {
            this.points.clear();
            this.points.addAll((Collection<? extends IVector3f>)i_list);
        }
        this.firePropertyChange("points", null, this.points);
        this.repaint();
        this.invalidate();
    }

    public void setStart(IVector3f start) {
        if (this.points.size() == 0) {
            this.addPoint(start);
        } else {
            this.setPoint(start, 0);
        }
    }
}

