/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import org.ascape.model.Agent;
import org.ascape.model.LocatedAgent;
import org.ascape.util.vis.DrawFeature;
import org.ascape.view.vis.CellView;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Scrolling1DView
extends CellView {
    private static final long serialVersionUID = 3644306272230219573L;
    protected int maxAgentWidth;

    public Scrolling1DView() {
        this("Scrolling 1D View");
    }

    public Scrolling1DView(String name) {
        super(name);
    }

    public synchronized void createImage() {
        Dimension size = this.getPreferredSizeWithin(this.imageFigure.getSize());
        if (size.width <= 0 || size.height <= 0) {
            size = new Dimension(1, 1);
        }
        Image oldImage = this.image;
        GC oldGC = this.imageGC;
        Graphics oldGraphics = this.imageGraphics;
        this.image = new Image((Device)Display.getCurrent(), new Rectangle(0, 0, size.width, size.height));
        this.imageGC = new GC((Drawable)this.image);
        this.imageGraphics = new SWTGraphics(this.imageGC);
        if (oldImage != null) {
            this.imageGC.drawImage(oldImage, 0, this.agentSize);
        }
        if (oldImage != null && !oldImage.isDisposed()) {
            oldGraphics.dispose();
            oldImage.dispose();
            oldGC.dispose();
        }
    }

    @Override
    public Dimension calculateViewSizeForAgentSize(Dimension availableSize, int cellSize) {
        return new Dimension(this.agentSize * this.getScape().getSize(), availableSize.height);
    }

    @Override
    public int calculateAgentSizeForViewSize(Dimension d) {
        int width = d.width / this.getScape().getSize();
        return Math.max(1, width);
    }

    @Override
    public Agent getAgentAtPixel(int x, int y) {
        int p = x / this.agentSize;
        if (p < 0) {
            return (Agent)this.getScape().get(0);
        }
        if (p >= this.getScape().getSize()) {
            return (Agent)this.getScape().get(this.getScape().getSize() - 1);
        }
        return (Agent)this.getScape().get(p);
    }

    @Override
    public void drawSelectedAgent(Graphics g, LocatedAgent a) {
    }

    public void updateScapeGraphics(Graphics g) {
        Object[] drawFeatures;
        if (this.getSize().height > 0 && (drawFeatures = this.getDrawSelection().getSelection()).length > 0) {
            for (Object object : this.getScape()) {
                Agent agent = (Agent)object;
                Object[] objectArray = drawFeatures;
                int n = drawFeatures.length;
                int n2 = 0;
                while (n2 < n) {
                    Object drawFeature = objectArray[n2];
                    ((DrawFeature)drawFeature).draw(g, agent, this.agentSize, this.agentSize);
                    ++n2;
                }
                g.translate(this.agentSize, 0);
            }
        }
    }
}

