/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import org.ascape.model.Agent;
import org.ascape.model.Scape;
import org.ascape.util.vis.ColorFeature;
import org.ascape.view.vis.CellView;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class StretchyView
extends CellView {
    private static final long serialVersionUID = 5067468202964334076L;
    int maxAgents = 50;
    int maxDisplayAgents;

    public StretchyView(String name) {
        super(name);
    }

    public StretchyView(String name, int maxAgents, int maxDisplayAgents) {
        super(name);
        this.maxAgents = maxAgents;
        this.maxDisplayAgents = maxDisplayAgents;
        this.setCellSize(4);
    }

    @Override
    public Dimension calculateViewSizeForAgentSize(Dimension availableSize, int cellSize) {
        int tempCellSize = this.calculateAgentSizeForViewSize(availableSize);
        return new Dimension(Math.max(1, this.maxDisplayAgents * tempCellSize), availableSize.height);
    }

    @Override
    public int calculateAgentSizeForViewSize(Dimension d) {
        int width = d.width / Math.max(this.maxDisplayAgents, 1);
        return Math.max(1, width);
    }

    public void setBarValueAttribute1(String barAttribute1) {
    }

    public void setBarValueAttribute2(String barAttribute2) {
    }

    public void drawAgentAt(Graphics graphics, Agent agent, int position) {
        int s = ((Scape)agent).getSize() * this.agentSize;
        int s0 = 0;
        int h = this.getImage().getBounds().height;
        Color agentColor = this.agentColorFeature.getColor(agent);
        if (s0 > s) {
            Color brighter = StretchyView.adjustBrightness(agentColor, 1.2f);
            graphics.setBackgroundColor(brighter);
            graphics.fillRectangle(position * this.agentSize, h - s0, this.agentSize - 1, s0 - 1);
            graphics.setBackgroundColor(ColorFeature.BLACK);
            graphics.drawRectangle(position * this.agentSize - 1, h - s - 1, this.agentSize, s);
            graphics.setBackgroundColor(agentColor);
            graphics.fillRectangle(position * this.agentSize, h - s, this.agentSize - 1, s - 1);
        } else {
            Color darker = StretchyView.adjustBrightness(agentColor, 1.2f);
            graphics.setForegroundColor(ColorFeature.BLACK);
            graphics.drawRectangle(position * this.agentSize - 1, h - s - 1, this.agentSize, s);
            graphics.setBackgroundColor(darker);
            graphics.fillRectangle(position * this.agentSize, h - s, this.agentSize - 1, s - s0);
            graphics.setBackgroundColor(agentColor);
            graphics.fillRectangle(position * this.agentSize, h - s0, this.agentSize - 1, s0 - 1);
        }
    }

    public static Color adjustBrightness(Color color, float factor) {
        float[] agentHSB = color.getRGB().getHSB();
        float newBright = Math.min(1.0f, agentHSB[1] * factor);
        Color brighter = new Color((Device)Display.getCurrent(), new RGB(agentHSB[0], newBright, agentHSB[2]));
        return brighter;
    }
}

