/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import org.ascape.model.Scape;
import org.ascape.util.HasName;
import org.ascape.util.RandomFunctions;

public class AscapeObject
implements RandomFunctions,
HasName,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ARBITRARY_SEED = -1;
    public static Object PLATFORM_DEFAULT_COLOR;
    protected Scape scape;
    protected String name;
    private static Random random;
    private static long randomSeed;
    private static long lastRandomSeed;
    private static transient PrintStream comparisonStream;

    static {
        random = new Random(System.currentTimeMillis());
        randomSeed = -1L;
    }

    public AscapeObject() {
    }

    public AscapeObject(String name) {
        this.name = name;
    }

    public void setScape(Scape scape) {
        this.scape = scape;
    }

    public Scape getScape() {
        return this.scape;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setRandom(Random newRandom) {
        random = newRandom;
    }

    @Override
    public Random getRandom() {
        return random;
    }

    public long getRandomSeed() {
        return lastRandomSeed;
    }

    public void setRandomSeed(long seed) {
        randomSeed = seed;
        this.reseed();
    }

    public void reseed() {
        lastRandomSeed = randomSeed != -1L ? randomSeed : System.currentTimeMillis();
        random.setSeed(lastRandomSeed);
    }

    @Override
    public int randomInRange(int low, int high) {
        return random.nextInt(high - low + 1) + low;
    }

    @Override
    public double randomInRange(double low, double high) {
        return random.nextDouble() * (high - low) + low;
    }

    @Override
    public int randomToLimit(int limit) {
        return random.nextInt(limit);
    }

    @Override
    public boolean randomIs() {
        return random.nextBoolean();
    }

    protected static String diffDeepVisit(SearchNode n) {
        if (comparisonStream != null) {
            comparisonStream.print("Visiting " + n.toString() + "\n");
        }
        if (!n.o1.equals(n.o2)) {
            if (comparisonStream != null) {
                comparisonStream.print("*** Difference in " + n.toString() + " ***");
            }
            return n.toString();
        }
        return null;
    }

    protected static String diffDeepValidate(SearchNode n) {
        if (comparisonStream != null) {
            comparisonStream.print("Validating " + n.toString() + "\n");
        }
        if (n.o1 != null && n.o2 != null) {
            if (n.o1.getClass() != n.o2.getClass()) {
                if (comparisonStream != null) {
                    comparisonStream.print("*** Different Class in " + n.toString() + " ***");
                }
                return String.valueOf(n.pathString) + ": " + n.o1.getClass().getName() + ", " + n.o2.getClass().getName();
            }
        } else {
            if (n.o1 != null) {
                if (comparisonStream != null) {
                    comparisonStream.print("*** Different null status in " + n.toString() + " ***");
                }
                return String.valueOf(n.pathString) + ": " + n.o1.getClass().getName() + ", null";
            }
            if (n.o2 != null) {
                if (comparisonStream != null) {
                    comparisonStream.print("*** Different null status in " + n.toString() + " ***");
                }
                return String.valueOf(n.pathString) + ": null, " + n.o2.getClass().getName();
            }
        }
        return null;
    }

    public static ArrayList diffDeepDFS(Object o1, Object o2) {
        return AscapeObject.diffDeepDFS(new HashSet(), new SearchNode("", null, o1, o2));
    }

    private static ArrayList diffDeepDFS(HashSet visitedObjects, SearchNode currentNode) {
        ArrayList<String> allDiffs = new ArrayList<String>();
        String validateResult = AscapeObject.diffDeepValidate(currentNode);
        if (validateResult == null) {
            if (currentNode.o1 != null && currentNode.o2 != null) {
                if (currentNode.field != null && (currentNode.field.getType().isPrimitive() || currentNode.field.getType().equals(String.class))) {
                    String nodeVisit = AscapeObject.diffDeepVisit(currentNode);
                    if (nodeVisit != null) {
                        allDiffs.add(nodeVisit);
                    }
                } else if (currentNode.o1.getClass().isArray()) {
                    int aLength = Array.getLength(currentNode.o1);
                    if (aLength == Array.getLength(currentNode.o2)) {
                        int j = 0;
                        while (j < aLength) {
                            SearchNode newNode = new SearchNode(String.valueOf(currentNode.pathString) + "[" + j + "]", currentNode.field, Array.get(currentNode.o1, j), Array.get(currentNode.o2, j));
                            allDiffs.addAll(AscapeObject.diffDeepDFS(visitedObjects, newNode));
                            ++j;
                        }
                    } else {
                        allDiffs.add(String.valueOf(currentNode.pathString) + ": Length " + aLength + ", Length " + Array.getLength(currentNode.o2));
                    }
                } else {
                    SearchNode currentPair = new SearchNode("", null, currentNode.o1, currentNode.o2);
                    if (!visitedObjects.contains(currentPair)) {
                        if (!(currentPair.o1 instanceof String || currentPair.o1 instanceof Number || currentPair.o1.getClass().isArray())) {
                            visitedObjects.add(currentPair);
                        }
                        String className = "";
                        Class<?> c = currentNode.o1.getClass();
                        while (c != null) {
                            AccessibleObject[] allFields = c.getDeclaredFields();
                            AccessibleObject.setAccessible(allFields, true);
                            if (currentNode.pathString != "") {
                                currentNode.pathString = String.valueOf(currentNode.pathString) + ".";
                            }
                            int i = 0;
                            while (i < allFields.length) {
                                try {
                                    if (!Modifier.isFinal(((Field)allFields[i]).getModifiers())) {
                                        SearchNode newNode = new SearchNode(String.valueOf(currentNode.pathString) + className + ((Field)allFields[i]).getName(), (Field)allFields[i], ((Field)allFields[i]).get(currentNode.o1), ((Field)allFields[i]).get(currentNode.o2));
                                        allDiffs.addAll(AscapeObject.diffDeepDFS(visitedObjects, newNode));
                                    }
                                }
                                catch (IllegalAccessException e) {
                                    System.out.println(e);
                                }
                                ++i;
                            }
                            String string = className = (c = c.getSuperclass()) != null ? String.valueOf(c.getName()) + "." : "";
                        }
                    }
                }
            }
        } else {
            allDiffs.add(validateResult);
        }
        return allDiffs;
    }

    public static ArrayList diffDeep(Object o1, Object o2) {
        SearchNode topNode = new SearchNode("", null, o1, o2);
        String validateResult = AscapeObject.diffDeepValidate(topNode);
        if (validateResult == null) {
            LinkedList<SearchNode> newList = new LinkedList<SearchNode>();
            newList.addLast(topNode);
            return AscapeObject.diffDeepBFS(new HashSet(), newList);
        }
        ArrayList<String> allDiffs = new ArrayList<String>();
        allDiffs.add(validateResult);
        return allDiffs;
    }

    public static ArrayList diffDeepBFS(HashSet visitedObjects, LinkedList queue) {
        ArrayList<String> allDiffs = new ArrayList<String>();
        while (!queue.isEmpty()) {
            SearchNode currentNode = (SearchNode)queue.removeFirst();
            if (visitedObjects.contains(currentNode)) continue;
            if (currentNode.field == null || !currentNode.field.getType().isPrimitive() && !currentNode.field.getType().equals(String.class)) {
                if (!(currentNode.o1 instanceof String || currentNode.o1 instanceof Number || currentNode.o1.getClass().isArray())) {
                    visitedObjects.add(currentNode);
                }
            } else {
                String nodeVisit = AscapeObject.diffDeepVisit(currentNode);
                if (nodeVisit != null) {
                    allDiffs.add(nodeVisit);
                }
            }
            if (currentNode.o1.getClass().isArray()) {
                int aLength = Array.getLength(currentNode.o1);
                if (aLength == Array.getLength(currentNode.o2)) {
                    int j = 0;
                    while (j < aLength) {
                        SearchNode candidateNode = new SearchNode(String.valueOf(currentNode.pathString) + "[" + j + "]", currentNode.field, Array.get(currentNode.o1, j), Array.get(currentNode.o2, j));
                        String validateResult = AscapeObject.diffDeepValidate(candidateNode);
                        if (validateResult == null) {
                            if (candidateNode.o1 != null && candidateNode.o2 != null && !visitedObjects.contains(candidateNode)) {
                                queue.addLast(candidateNode);
                            }
                        } else {
                            allDiffs.add(validateResult);
                        }
                        ++j;
                    }
                } else {
                    allDiffs.add(String.valueOf(currentNode.pathString) + ": Length " + aLength + ", Length " + Array.getLength(currentNode.o2));
                }
            }
            if (currentNode.field != null && (currentNode.field.getType().isPrimitive() || currentNode.field.getType().equals(String.class))) continue;
            String className = "";
            Class<?> c = currentNode.o1.getClass();
            while (c != null) {
                AccessibleObject[] allFields = c.getDeclaredFields();
                AccessibleObject.setAccessible(allFields, true);
                if (currentNode.pathString != "") {
                    currentNode.pathString = String.valueOf(currentNode.pathString) + ".";
                }
                int i = 0;
                while (i < allFields.length) {
                    if (!Modifier.isFinal(((Field)allFields[i]).getModifiers()) && !Modifier.isTransient(((Field)allFields[i]).getModifiers())) {
                        try {
                            SearchNode candidateNode = new SearchNode(String.valueOf(currentNode.pathString) + className + ((Field)allFields[i]).getName(), (Field)allFields[i], ((Field)allFields[i]).get(currentNode.o1), ((Field)allFields[i]).get(currentNode.o2));
                            String validateResult = AscapeObject.diffDeepValidate(candidateNode);
                            if (validateResult == null) {
                                if (candidateNode.o1 != null && candidateNode.o2 != null && !visitedObjects.contains(candidateNode)) {
                                    queue.addLast(candidateNode);
                                }
                            } else {
                                allDiffs.add(validateResult);
                            }
                        }
                        catch (IllegalAccessException e) {
                            System.out.println(e);
                        }
                    }
                    ++i;
                }
                String string = className = (c = c.getSuperclass()) != null ? String.valueOf(c.getName()) + "." : "";
            }
        }
        return allDiffs;
    }

    public ArrayList diffDeep(Object o) {
        return AscapeObject.diffDeep(this, o);
    }

    public static boolean equalsDeep(Object o1, Object o2) {
        return AscapeObject.equalsDeep(new HashSet(), new SearchNode("", null, o1, o2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equalsDeep(HashSet visitedObjects, SearchNode currentNode) {
        String validateResult = AscapeObject.diffDeepValidate(currentNode);
        if (validateResult != null) return false;
        if (currentNode.o1 == null || currentNode.o2 == null) return currentNode.o1 == null && currentNode.o2 == null;
        if (currentNode.field != null && (currentNode.field.getType().isPrimitive() || currentNode.field.getType().equals(String.class))) {
            String nodeVisit = AscapeObject.diffDeepVisit(currentNode);
            if (nodeVisit == null) return true;
            return false;
        }
        if (currentNode.o1.getClass().isArray()) {
            int aLength = Array.getLength(currentNode.o1);
            if (aLength != Array.getLength(currentNode.o2)) return false;
            int j = 0;
            while (j < aLength) {
                boolean equal = AscapeObject.equalsDeep(visitedObjects, new SearchNode(String.valueOf(currentNode.pathString) + "[" + j + "]", currentNode.field, Array.get(currentNode.o1, j), Array.get(currentNode.o2, j)));
                if (!equal) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        if (visitedObjects.contains(currentNode)) return true;
        visitedObjects.add(currentNode);
        String className = "";
        Class<?> c = currentNode.o1.getClass();
        while (c != null) {
            AccessibleObject[] allFields = c.getDeclaredFields();
            AccessibleObject.setAccessible(allFields, true);
            if (currentNode.pathString != "") {
                currentNode.pathString = String.valueOf(currentNode.pathString) + ".";
            }
            int i = 0;
            while (i < allFields.length) {
                try {
                    boolean equal;
                    if (!(Modifier.isFinal(((Field)allFields[i]).getModifiers()) || Modifier.isTransient(((Field)allFields[i]).getModifiers()) || (equal = AscapeObject.equalsDeep(visitedObjects, new SearchNode(String.valueOf(currentNode.pathString) + className + ((Field)allFields[i]).getName(), (Field)allFields[i], ((Field)allFields[i]).get(currentNode.o1), ((Field)allFields[i]).get(currentNode.o2)))))) {
                        return false;
                    }
                }
                catch (IllegalAccessException e) {
                    System.out.println(e);
                }
                ++i;
            }
            String string = className = (c = c.getSuperclass()) != null ? String.valueOf(c.getName()) + "." : "";
        }
        return true;
    }

    public boolean equalsDeep(Object o) {
        return AscapeObject.equalsDeep(this, o);
    }

    public static PrintStream getComparisonStream() {
        return comparisonStream;
    }

    public static void setComparisonStream(PrintStream comparisonStream) {
        AscapeObject.comparisonStream = comparisonStream;
    }

    public Object clone() {
        try {
            AscapeObject clone = (AscapeObject)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return "An ascape object";
    }

    static class SearchNode {
        String pathString;
        Field field;
        private Object o1;
        private Object o2;

        SearchNode(String pathString, Field field, Object o1, Object o2) {
            this.pathString = pathString;
            this.field = field;
            this.o1 = o1;
            this.o2 = o2;
        }

        public String toString() {
            return String.valueOf(this.pathString) + ": " + this.o1 + ", " + this.o2;
        }

        public boolean equals(Object o) {
            return this.o1 == ((SearchNode)o).o1 && this.o2 == ((SearchNode)o).o2;
        }

        public int hashCode() {
            long hashCandidate = this.o1.hashCode() + this.o2.hashCode();
            if (hashCandidate > Integer.MAX_VALUE) {
                hashCandidate -= -2L;
            }
            return (int)hashCandidate;
        }
    }
}

