/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera.tracking;

import org.eclipse.draw3d.camera.CameraPosition;
import org.eclipse.draw3d.camera.ICameraPosition;
import org.eclipse.draw3d.camera.tracking.AbstractStartEndMove;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class LinearMovement
extends AbstractStartEndMove {
    IVector3f direction;

    public ICameraPosition init(ICameraPosition i_startPosition, ICameraPosition i_endPosition) {
        super.init(i_startPosition, i_endPosition);
        this.direction = Math3D.sub((IVector3f)i_endPosition.getPosition(), (IVector3f)i_startPosition.getPosition(), null);
        return i_endPosition;
    }

    public void updateCameraPosition(CameraPosition io_cameraPosition, float i_prevTick, float i_currentTick) {
        if (i_currentTick == 1.0f) {
            io_cameraPosition.setCameraPosition(this.getEndPosition());
        } else if (i_currentTick == 0.0f) {
            io_cameraPosition.setCameraPosition(this.getStartPosition());
        } else {
            Vector3fImpl v = new Vector3fImpl();
            Math3D.scale((float)i_currentTick, (IVector3f)this.direction, (Vector3f)v);
            Math3D.add((IVector3f)this.getStartPosition().getPosition(), (IVector3f)v, (Vector3f)v);
            io_cameraPosition.setPosition((IVector3f)v);
        }
    }
}

