/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.vis;

import org.ascape.model.Scape;
import org.ascape.util.VectorSelection;
import org.ascape.util.vis.PlatformDrawFeature;

public class PlatformDrawFeatureSelection
extends VectorSelection {
    private static final long serialVersionUID = 1L;
    private Scape scape;

    public PlatformDrawFeatureSelection(Scape scape) {
        super(scape.getDrawFeatures());
        scape.getDrawFeaturesObservable().addObserver(this);
        this.scape = scape;
    }

    public void moveToTop(PlatformDrawFeature drawFeature) {
        int selectedRow = this.vector.indexOf(drawFeature);
        if (selectedRow > 0) {
            int i = selectedRow - 1;
            while (i >= 0) {
                Object swapFeature = this.vector.elementAt(i);
                this.vector.removeElementAt(i);
                this.vector.insertElementAt(swapFeature, i + 1);
                --i;
            }
            this.scape.getDrawFeaturesObservable().notifyObservers();
            this.update();
        }
    }

    public void moveToBottom(PlatformDrawFeature drawFeature) {
        int selectedRow = this.vector.indexOf(drawFeature);
        if (selectedRow < this.vector.size()) {
            int i = selectedRow + 1;
            while (i < this.vector.size()) {
                Object swapFeature = this.vector.elementAt(i);
                this.vector.removeElementAt(i);
                this.vector.insertElementAt(swapFeature, i - 1);
                ++i;
            }
            this.scape.getDrawFeaturesObservable().notifyObservers();
            this.update();
        }
    }

    public void moveUp(PlatformDrawFeature drawFeature) {
        int selectedRow = this.vector.indexOf(drawFeature);
        if (selectedRow > 0) {
            Object swapFeature = this.vector.elementAt(selectedRow - 1);
            this.vector.removeElementAt(selectedRow - 1);
            this.vector.insertElementAt(swapFeature, selectedRow);
            this.scape.getDrawFeaturesObservable().notifyObservers();
            this.update();
        }
    }

    public void moveDown(PlatformDrawFeature drawFeature) {
        int selectedRow = this.vector.indexOf(drawFeature);
        if (selectedRow < this.vector.size()) {
            Object swapFeature = this.vector.elementAt(selectedRow + 1);
            this.vector.removeElementAt(selectedRow + 1);
            this.vector.insertElementAt(swapFeature, selectedRow);
            this.scape.getDrawFeaturesObservable().notifyObservers();
            this.update();
        }
    }

    public PlatformDrawFeature findByName(String name) {
        PlatformDrawFeature found = null;
        for (PlatformDrawFeature feature : this.vector) {
            if (!feature.getName().equals(name)) continue;
            found = feature;
            break;
        }
        return found;
    }
}

