/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.sd.gen.builder;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.amp.amf.sd.gen.SDActivator;
import org.eclipse.amp.amf.sd.gen.builder.JobFinishedIndicator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class AbstractJavaSDTest
extends TestCase {
    private static final String TEST_PROJECTS_DIR = "testProject/";
    private IProject project;

    protected AbstractJavaSDTest(String projectName) throws Exception {
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(SDActivator.getAbsoluteDir(TEST_PROJECTS_DIR + projectName)) + ".project"));
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (!this.project.exists()) {
            this.project.create(description, null);
            this.project.open(null);
        }
    }

    protected int countGeneratedTags(String fileName) throws IOException {
        String text = this.getFileText(fileName);
        int retValue = 0;
        String searchString = "* @generated";
        int foundIndex = text.indexOf(searchString);
        while (foundIndex > -1) {
            ++retValue;
            text = text.substring(foundIndex + searchString.length());
            foundIndex = text.indexOf(searchString);
        }
        return retValue;
    }

    protected void checkNoCompilationErrors(String resourceName) throws CoreException {
        IMarker[] markers;
        IFile resource = this.project.getFile(resourceName);
        AbstractJavaSDTest.assertTrue((boolean)resource.exists());
        IMarker[] iMarkerArray = markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker tmp = iMarkerArray[n2];
            AbstractJavaSDTest.assertFalse((boolean)tmp.getAttribute("severity").equals(2));
            ++n2;
        }
    }

    protected String getFileText(String relativePath) throws IOException {
        String path = this.getProjectFilePath(relativePath);
        byte[] buffer = new byte[(int)new File(path).length()];
        BufferedInputStream f = null;
        try {
            f = new BufferedInputStream(new FileInputStream(path));
            f.read(buffer);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(buffer);
    }

    protected void doGenerate(String ... expectedFiles) throws Exception {
        this.project.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        JobFinishedIndicator clean = new JobFinishedIndicator();
        this.project.build(15, (IProgressMonitor)clean);
        while (!clean.jobIsFinished()) {
            Thread.sleep(10L);
        }
        JobFinishedIndicator fullBuild = new JobFinishedIndicator();
        this.project.build(6, (IProgressMonitor)fullBuild);
        while (!fullBuild.jobIsFinished()) {
            Thread.sleep(10L);
        }
        String[] stringArray = expectedFiles;
        int n = expectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String generatedFile = stringArray[n2];
            AbstractJavaSDTest.assertNotNull((Object)this.getProjectFilePath(generatedFile));
            ++n2;
        }
    }

    protected boolean emptyProjectDir(String relativePath) {
        String dir = this.getProjectFilePath(relativePath);
        if (dir != null) {
            return this.delete(new File(dir), false);
        }
        return true;
    }

    private String getProjectFilePath(String relativePath) {
        return SDActivator.getAbsoluteDir(TEST_PROJECTS_DIR + this.project.getName() + "/" + relativePath);
    }

    private boolean delete(File file, boolean deleteRoot) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (!this.delete(child, true)) {
                    return false;
                }
                ++n2;
            }
        }
        if (!deleteRoot) {
            return true;
        }
        return file.delete();
    }
}

