/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.acore.edit.commands.test;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTransformer;
import org.eclipse.amp.amf.acore.edit.commands.test.CreateAgents;
import org.eclipse.amp.amf.acore.edit.commands.test.CreateSubcontext;
import org.eclipse.amp.amf.acore.edit.commands.test.ModelConstructionCommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.NewAgentCondition;
import org.eclipse.amp.amf.acore.edit.commands.test.NewAgentGenCondition;
import org.eclipse.amp.amf.acore.edit.commands.test.NewSubcontextCondition;
import org.eclipse.amp.amf.acore.edit.commands.test.NewSubcontextGenCondition;
import org.eclipse.amp.amf.acore.edit.commands.test.PrePostCondition;
import org.eclipse.amp.amf.acore.edit.commands.test.RenameAgentCommand;
import org.eclipse.amp.amf.acore.edit.commands.test.RenameSubContextCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SImplementationMode;
import org.metaabm.act.AAct;
import org.metaabm.act.AGroup;

public class ModelImplementationCommandTest
extends CommandTest {
    public ModelImplementationCommandTest(String name) {
        super(name);
    }

    public void testMode() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelImplementationCommandTest.buildLoadAgents(cmds);
        cmds.add(new CommandTransformer(){

            @Override
            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.model.getImplementation(), (Object)MetaABMPackage.Literals.SIMPLEMENTATION__MODE, (Object)SImplementationMode.GENERATE_LITERAL, (int)-1);
            }

            @Override
            public void addPrePost(List<PrePostCondition> list) {
                super.addPrePost(list);
                list.add(new NewAgentCondition());
                list.add(new NewAgentGenCondition(){

                    @Override
                    public void preCondition() {
                        AGroup root = (AGroup)this.model.getRootActivity();
                        CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)0);
                        CommandTest.assertNotNull((Object)root);
                    }
                });
                list.add(new NewSubcontextCondition());
                list.add(new NewSubcontextGenCondition(){

                    @Override
                    public void preCondition() {
                        AGroup root = (AGroup)this.model.getRootActivity();
                        CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)0);
                        CommandTest.assertNotNull((Object)root);
                    }
                });
            }
        });
        cmds.add(new CommandTransformer(){

            @Override
            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.model.getImplementation(), (Object)MetaABMPackage.Literals.SIMPLEMENTATION__MODE, (Object)SImplementationMode.LOAD_LITERAL, (int)-1);
            }

            @Override
            public void addPrePost(List<PrePostCondition> list) {
                list.add(new NewAgentCondition());
                list.add(new NewSubcontextCondition());
            }

            @Override
            public void preCondition() {
                super.preCondition();
                CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)2);
            }

            @Override
            public void postCondition() {
                super.postCondition();
                CommandTest.assertNotNull((Object)this.model.getRootActivity());
                CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)2);
            }
        });
        this.executeTests(cmds);
    }

    public void testModeRename() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelImplementationCommandTest.buildLoadAgents(cmds);
        cmds.add(new RenameAgentCommand());
        cmds.add(new RenameSubContextCommand());
        cmds.add(new CommandTransformer(){

            @Override
            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.model.getImplementation(), (Object)MetaABMPackage.Literals.SIMPLEMENTATION__MODE, (Object)SImplementationMode.GENERATE_LITERAL, (int)-1);
            }

            @Override
            public void preCondition() {
                ModelImplementationCommandTest.assertEquals((String)((SAgent)this.model.getAgents().get(0)).getLabel(), (String)"Test Agent");
                ModelImplementationCommandTest.assertEquals((String)((SAgent)this.model.getAgents().get(1)).getLabel(), (String)"Test SubContext");
                AGroup root = (AGroup)this.model.getRootActivity();
                ModelImplementationCommandTest.assertNotNull((Object)root);
            }

            @Override
            public void postCondition() {
                ModelImplementationCommandTest.assertEquals((String)((SAgent)this.model.getAgents().get(0)).getLabel(), (String)"Test Agent");
                ModelImplementationCommandTest.assertEquals((String)((SAgent)this.model.getAgents().get(1)).getLabel(), (String)"Test SubContext");
                AGroup root = (AGroup)this.model.getRootActivity();
                ModelImplementationCommandTest.assertEquals((String)((AAct)root.getMembers().get(1)).getLabel(), (String)"Create Test Agents");
                ModelImplementationCommandTest.assertEquals((String)((AAct)root.getMembers().get(2)).getLabel(), (String)"Create Test SubContexts");
                ModelImplementationCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(0)).getLabel(), (String)"Test Agent Count");
                ModelImplementationCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(0)).getDescription(), (String)"The number of test agents to create.");
                ModelImplementationCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(1)).getLabel(), (String)"Test SubContext Count");
            }
        });
        this.executeTests(cmds);
    }

    public static void buildLoadAgents(List<CommandTransformer> cmds) {
        cmds.add(new CommandTransformer(){

            @Override
            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.model.getImplementation(), (Object)MetaABMPackage.Literals.SIMPLEMENTATION__MODE, (Object)SImplementationMode.LOAD_LITERAL, (int)-1);
            }

            @Override
            public void preCondition() {
                CommandTest.assertNotNull((Object)this.model.getRootActivity());
            }

            @Override
            public void postCondition() {
                CommandTest.assertNotNull((Object)this.model.getRootActivity());
            }
        });
        cmds.add(new CreateAgents(){

            @Override
            public void postCondition() {
                CommandTest.assertEquals((String)((SAgent)this.model.getAgents().get(0)).getLabel(), (String)"Root Context Agent");
                CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)0);
                CommandTest.assertNotNull((Object)this.model.getRootActivity());
            }
        });
        cmds.add(new CreateSubcontext(){

            @Override
            public void postCondition() {
                CommandTest.assertEquals((String)((SAgent)this.model.getAgents().get(1)).getLabel(), (String)"Root Context Context");
                CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)0);
                CommandTest.assertNotNull((Object)this.model.getRootActivity());
            }
        });
    }
}

