/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.viewer;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.draw3d.graphics3d.Graphics3DDescriptor;
import org.eclipse.draw3d.graphics3d.Graphics3DRegistry;
import org.eclipse.draw3d.graphics3d.Graphics3DType;
import org.eclipse.draw3d.ui.export.Export3DAction;
import org.eclipse.draw3d.ui.viewer.Draw3DViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.part.EditorActionBarContributor;

public class Draw3DViewerActionBarContributor
extends EditorActionBarContributor {
    private Collection<RetargetAction> m_retargetActions = new HashSet<RetargetAction>();

    public void setActiveEditor(IEditorPart i_targetEditor) {
        if (i_targetEditor instanceof Draw3DViewer) {
            Draw3DViewer viewer = (Draw3DViewer)i_targetEditor;
            Collection<Export3DAction> actions = viewer.getExportActions();
            for (Export3DAction action : actions) {
                this.getActionBars().setGlobalActionHandler(action.getId(), (IAction)action);
            }
        } else {
            this.getActionBars().clearGlobalActionHandlers();
        }
        for (RetargetAction action : this.m_retargetActions) {
            action.setEnabled(i_targetEditor instanceof Draw3DViewer);
        }
        this.getActionBars().updateActionBars();
    }

    public void init(IActionBars i_bars, IWorkbenchPage i_page) {
        for (Graphics3DDescriptor descr : Graphics3DRegistry.getRenderersForType((Graphics3DType)Graphics3DType.EXPORT)) {
            String actionId = Export3DAction.actionID(descr.getRendererID());
            LabelRetargetAction action = new LabelRetargetAction(actionId, descr.getDescription());
            this.m_retargetActions.add((RetargetAction)action);
            i_page.addPartListener((IPartListener)action);
        }
        super.init(i_bars, i_page);
    }

    public void dispose() {
        for (RetargetAction action : this.m_retargetActions) {
            this.getPage().removePartListener((IPartListener)action);
        }
        super.dispose();
    }

    public void contributeToToolBar(IToolBarManager i_toolBarManager) {
        for (RetargetAction action : this.m_retargetActions) {
            i_toolBarManager.add((IAction)action);
        }
    }
}

