/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.Connection3D;
import org.eclipse.draw3d.ConnectionAnchor3D;
import org.eclipse.draw3d.ConnectionRouter3D;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.util.Draw3DCache;

public abstract class AbstractRouter3D
extends AbstractRouter
implements ConnectionRouter3D {
    protected IVector3f getEndPoint3D(Connection3D connection, Vector3f io_result) {
        IVector3f iVector3f;
        ConnectionAnchor sourceAnchor = connection.getSourceAnchor();
        ConnectionAnchor targetAnchor = connection.getTargetAnchor();
        Vector3f ref = Draw3DCache.getVector3f();
        try {
            this.getReferencePoint3D(sourceAnchor, ref);
            iVector3f = this.getLocation3D(targetAnchor, (IVector3f)ref, io_result);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{ref});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{ref});
        return iVector3f;
    }

    protected IVector3f getLocation3D(ConnectionAnchor i_anchor, IVector3f i_reference, Vector3f io_result) {
        block4: {
            Vector3f vector3f;
            if (i_anchor instanceof ConnectionAnchor3D) {
                ConnectionAnchor3D anchor3D = (ConnectionAnchor3D)i_anchor;
                return anchor3D.getLocation3D(i_reference, io_result);
            }
            Point sLocation = Draw3DCache.getPoint();
            try {
                IFigure3D owner = Figure3DHelper.getAncestor3D(i_anchor.getOwner());
                if (owner == null) break block4;
                ISurface surface = owner.getSurface();
                surface.getSurfaceLocation2D(i_reference, sLocation);
                Point p = i_anchor.getLocation(sLocation);
                vector3f = surface.getWorldLocation(p, io_result);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnPoint(sLocation);
                throw throwable;
            }
            Draw3DCache.returnPoint(sLocation);
            return vector3f;
        }
        throw new IllegalStateException("Cannot calculate the location of a 2D router with no owner");
    }

    protected IVector3f getReferencePoint3D(ConnectionAnchor anchor, Vector3f io_result) {
        if (anchor instanceof ConnectionAnchor3D) {
            ConnectionAnchor3D anchor3D = (ConnectionAnchor3D)anchor;
            return anchor3D.getReferencePoint3D(io_result);
        }
        IFigure3D owner = Figure3DHelper.getAncestor3D(anchor.getOwner());
        ISurface surface = owner.getSurface();
        Point p = anchor.getReferencePoint();
        return surface.getWorldLocation(p, io_result);
    }

    protected IVector3f getStartPoint3D(Connection3D connection, Vector3f io_result) {
        IVector3f iVector3f;
        ConnectionAnchor sourceAnchor = connection.getSourceAnchor();
        ConnectionAnchor targetAnchor = connection.getTargetAnchor();
        Vector3f ref = Draw3DCache.getVector3f();
        try {
            this.getReferencePoint3D(targetAnchor, ref);
            iVector3f = this.getLocation3D(sourceAnchor, (IVector3f)ref, io_result);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{ref});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{ref});
        return iVector3f;
    }
}

