/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import org.ascape.model.space.Array2DBase;
import org.ascape.model.space.CollectionSpace;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate2DDiscrete;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Geometry;
import org.ascape.model.space.Location;
import org.ascape.util.Conditional;

public abstract class Array2D
extends Array2DBase {
    private static final long serialVersionUID = 1L;
    public static int MAX_RANK = 135;

    public Array2D() {
        int i = 0;
        while (i < relativeCoordinatesTemplate.length) {
            Array2D.relativeCoordinatesRankDistance[i] = Math.sqrt(Math.pow(relativeCoordinatesTemplate[i][0][0], 2.0) + Math.pow(relativeCoordinatesTemplate[i][0][1], 2.0));
            ++i;
        }
        this.collection = this;
    }

    public Array2D(Geometry geometry, CoordinateDiscrete extent) {
        this();
        this.setGeometry(geometry);
        this.setExtent(extent);
    }

    @Override
    public void initialize() {
        super.initialize();
        int i = 0;
        while (i < relativeCoordinatesTemplate.length) {
            int j = 0;
            while (j < relativeCoordinatesTemplate[i].length) {
                System.arraycopy(relativeCoordinatesTemplate[i][j], 0, this.relativeCoordinates[i][j], 0, relativeCoordinatesTemplate[i][j].length);
                ++j;
            }
            ++i;
        }
    }

    protected static int getNumOfCoordinatesWithinRank(int rank) {
        return sumOfCoordinatesWithinRank[rank];
    }

    public final double calculateDistanceMoore(Coordinate origin, Coordinate target) {
        return Math.max(this.getXSpan(origin, target), this.getYSpan(origin, target));
    }

    protected final int getXSpan(Coordinate origin, Coordinate target) {
        if (this.geometry.isPeriodic()) {
            return Array2D.calculateDistance(((Coordinate2DDiscrete)origin).getXValue(), ((Coordinate2DDiscrete)target).getXValue(), ((Coordinate2DDiscrete)this.getExtent()).getXValue());
        }
        return Math.abs(((Coordinate2DDiscrete)origin).getXValue() - ((Coordinate2DDiscrete)target).getXValue());
    }

    protected final int getYSpan(Coordinate origin, Coordinate target) {
        if (this.geometry.isPeriodic()) {
            return Array2D.calculateDistance(((Coordinate2DDiscrete)origin).getYValue(), ((Coordinate2DDiscrete)target).getYValue(), ((Coordinate2DDiscrete)this.getExtent()).getYValue());
        }
        return Math.abs(((Coordinate2DDiscrete)origin).getYValue() - ((Coordinate2DDiscrete)target).getYValue());
    }

    public Location findFirstMatchInRank(Coordinate origin, Conditional condition, int rank) {
        int xO = ((Coordinate2DDiscrete)origin).getXValue();
        int yO = ((Coordinate2DDiscrete)origin).getYValue();
        if (this.geometry.isPeriodic()) {
            int place = 0;
            while (place < relativeCoordinatesRankLengths[rank]) {
                int x = xO + this.relativeCoordinates[rank][place][0];
                while (x < 0) {
                    x += this.cells.length;
                }
                while (x >= this.cells.length) {
                    x -= this.cells.length;
                }
                int y = yO + this.relativeCoordinates[rank][place][1];
                while (y < 0) {
                    y += this.cells[0].length;
                }
                while (y >= this.cells[0].length) {
                    y -= this.cells[0].length;
                }
                if (condition.meetsCondition(this.cells[x][y])) {
                    return this.cells[x][y];
                }
                ++place;
            }
        } else {
            int place = 0;
            while (place < relativeCoordinatesRankLengths[rank]) {
                int y;
                int x = xO + this.relativeCoordinates[rank][place][0];
                if (x >= 0 && x < this.cells.length && (y = yO + this.relativeCoordinates[rank][place][1]) >= 0 && y < this.cells[0].length && condition.meetsCondition(this.cells[x][y])) {
                    return this.cells[x][y];
                }
                ++place;
            }
        }
        return null;
    }

    @Override
    public Location findNearest(Coordinate origin, Conditional condition, boolean includeOrigin, double distance) {
        int nearestRank = this.findNearestMatchRank(origin, condition, includeOrigin, distance);
        if (nearestRank >= 0) {
            return this.findRandomMatchInRank(origin, condition, nearestRank);
        }
        if (distance > (double)MAX_RANK) {
            return this.findMinimum(this.withinIterator(origin, condition, includeOrigin, distance), new CollectionSpace.ClosestDataPoint(this, origin));
        }
        return null;
    }

    @Override
    public int findNearestMatchRank(Coordinate origin, Conditional condition, boolean includeOrigin, double maximumDistance) {
        int i = includeOrigin ? 0 : 1;
        while (i < this.relativeCoordinates.length && relativeCoordinatesRankDistance[i] < maximumDistance) {
            if (this.findFirstMatchInRank(origin, condition, i) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Location findRandomMatchInRank(Coordinate origin, Conditional condition, int rank) {
        this.randomizeRank(rank);
        return this.findFirstMatchInRank(origin, condition, rank);
    }

    @Override
    public boolean hasWithin(Coordinate origin, Conditional condition, boolean includeOrigin, double maximumDistance) {
        return this.findNearestMatchRank(origin, condition, includeOrigin, maximumDistance) >= 0;
    }

    @Override
    public int countWithin(Coordinate origin, Conditional condition, boolean includeOrigin, double maximumDistance) {
        int xO = ((Coordinate2DDiscrete)origin).getXValue();
        int yO = ((Coordinate2DDiscrete)origin).getYValue();
        int count = 0;
        if (this.geometry.isPeriodic()) {
            int rank = includeOrigin ? 0 : 1;
            while (rank < this.relativeCoordinates.length) {
                if (relativeCoordinatesRankDistance[rank] <= maximumDistance) {
                    int place = 0;
                    while (place < relativeCoordinatesRankLengths[rank]) {
                        int x = xO + this.relativeCoordinates[rank][place][0];
                        if (x < 0) {
                            x += this.cells.length;
                        } else if (x >= this.cells.length) {
                            x -= this.cells.length;
                        }
                        int y = yO + this.relativeCoordinates[rank][place][1];
                        if (y < 0) {
                            y += this.cells[0].length;
                        } else if (y >= this.cells[0].length) {
                            y -= this.cells[0].length;
                        }
                        if (condition.meetsCondition(this.cells[x][y])) {
                            ++count;
                        }
                        ++place;
                    }
                } else {
                    return count;
                }
                ++rank;
            }
        } else {
            int rank = includeOrigin ? 0 : 1;
            while (rank < this.relativeCoordinates.length) {
                if (relativeCoordinatesRankDistance[rank] <= maximumDistance) {
                    int place = 0;
                    while (place < relativeCoordinatesRankLengths[place]) {
                        int y;
                        int x = xO + this.relativeCoordinates[rank][place][0];
                        if (x >= 0 && x < this.cells.length && (y = yO + this.relativeCoordinates[rank][place][1]) >= 0 && y < this.cells[0].length && condition.meetsCondition(this.cells[x][y])) {
                            ++count;
                        }
                        ++place;
                    }
                } else {
                    return count;
                }
                ++rank;
            }
        }
        return count;
    }
}

