/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.platform;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.eclipse.gemini.blueprint.test.internal.util.IOUtils;
import org.eclipse.gemini.blueprint.test.platform.AbstractOsgiPlatform;
import org.eclipse.gemini.blueprint.test.platform.DefaultFrameworkTemplate;
import org.eclipse.gemini.blueprint.test.platform.FrameworkTemplate;
import org.eclipse.gemini.blueprint.test.platform.Platform;
import org.knopflerfish.framework.FrameworkFactoryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class KnopflerfishPlatform
extends AbstractOsgiPlatform {
    private static final String KF_2X_BOOT_CLASS = "org.knopflerfish.framework.Framework";
    private static final String KF_3X_BOOT_CLASS = "org.knopflerfish.framework.FrameworkContext";
    private static final boolean KF_2X = ClassUtils.isPresent((String)"org.knopflerfish.framework.Framework", (ClassLoader)KnopflerfishPlatform.class.getClassLoader());
    private BundleContext context;
    private Platform framework;
    private File kfStorageDir;

    public KnopflerfishPlatform() {
        this.toString = "Knopflerfish OSGi Platform";
    }

    Properties getPlatformProperties() {
        if (this.kfStorageDir == null) {
            this.kfStorageDir = this.createTempDir("kf");
            this.kfStorageDir.deleteOnExit();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("KF temporary storage dir is " + this.kfStorageDir.getAbsolutePath()));
            }
        }
        Properties props = new Properties();
        props.setProperty("org.osgi.framework.dir", this.kfStorageDir.getAbsolutePath());
        props.setProperty("org.knopflerfish.framework.bundlestorage", "file");
        props.setProperty("org.knopflerfish.framework.bundlestorage.file.reference", "true");
        props.setProperty("org.knopflerfish.framework.bundlestorage.file.unpack", "false");
        props.setProperty("org.knopflerfish.startlevel.use", "true");
        props.setProperty("org.knopflerfish.osgi.setcontextclassloader", "true");
        props.setProperty("org.knopflerfish.framework.exitonshutdown", "false");
        props.setProperty("org.knopflerfish.framework.patch", "false");
        props.setProperty("org.knopflerfish.framework.system.export.all", "true");
        props.setProperty("org.knopflerfish.framework.strictbootclassloading", "true");
        return props;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void start() throws Exception {
        if (this.framework == null) {
            System.getProperties().putAll((Map<?, ?>)this.getConfigurationProperties());
            this.framework = KF_2X ? new KF2Platform(this) : new KF3Platform(this.getPlatformProperties(), this.log);
            this.context = this.framework.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.framework != null) {
            this.context = null;
            try {
                this.framework.stop();
            }
            finally {
                this.framework = null;
                IOUtils.delete(this.kfStorageDir);
            }
        }
    }

    private static class KF3Platform
    implements Platform {
        private Bundle framework;
        private final Map properties;
        private final Log log;
        private FrameworkTemplate fwkTemplate;

        KF3Platform(Map properties, Log log) {
            this.properties = properties;
            this.log = log;
        }

        public BundleContext start() {
            this.framework = new FrameworkFactoryImpl().newFramework(this.properties);
            this.fwkTemplate = new DefaultFrameworkTemplate(this.framework, this.log);
            this.fwkTemplate.init();
            this.fwkTemplate.start();
            return this.framework.getBundleContext();
        }

        public void stop() {
            if (this.fwkTemplate != null) {
                this.fwkTemplate.stopAndWait(1000L);
                this.fwkTemplate = null;
            }
        }
    }

    private static class KF2Platform
    implements Platform {
        private static final Class<?> BOOT_CLASS = ClassUtils.resolveClassName((String)"org.knopflerfish.framework.Framework", (ClassLoader)KF2Platform.class.getClassLoader());
        private static final Constructor<?> CONSTRUCTOR;
        private static final Method LAUNCH;
        private static final Method GET_BUNDLE_CONTEXT;
        private static final Method SHUTDOWN;
        private final Object monitor;
        private Object framework;

        KF2Platform(Object monitor) {
            this.monitor = monitor;
        }

        public BundleContext start() {
            this.framework = BeanUtils.instantiateClass(CONSTRUCTOR, (Object[])new Object[]{this.monitor});
            ReflectionUtils.invokeMethod((Method)LAUNCH, (Object)this.framework, (Object[])new Object[]{0});
            return (BundleContext)ReflectionUtils.invokeMethod((Method)GET_BUNDLE_CONTEXT, (Object)this.framework);
        }

        public void stop() {
            if (this.framework != null) {
                ReflectionUtils.invokeMethod((Method)SHUTDOWN, (Object)this.framework);
                this.framework = null;
            }
        }

        static {
            try {
                CONSTRUCTOR = BOOT_CLASS.getDeclaredConstructor(Object.class);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException("Invalid framework class", nsme);
            }
            LAUNCH = BeanUtils.findDeclaredMethod(BOOT_CLASS, (String)"launch", (Class[])new Class[]{Long.TYPE});
            GET_BUNDLE_CONTEXT = ReflectionUtils.findMethod(BOOT_CLASS, (String)"getSystemBundleContext");
            SHUTDOWN = ReflectionUtils.findMethod(BOOT_CLASS, (String)"shutdown");
        }
    }
}

