/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import java.text.DecimalFormat;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.view.execution.ExecutionViewMessages;
import org.eclipse.buildship.ui.view.execution.OperationDescriptorRenderer;
import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.SkippedResult;
import org.gradle.tooling.events.SuccessResult;

public final class OperationItemRenderer {
    private final DecimalFormat durationFormat = new DecimalFormat("#0.000");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(OperationItem operationItem) {
        OperationItem operationItem2 = operationItem;
        synchronized (operationItem2) {
            operationItem.setName(this.calculateName(operationItem));
            operationItem.setDuration(this.calculateDuration(operationItem));
            operationItem.setImage(this.calculateImage(operationItem));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDuration(OperationItem operationItem) {
        OperationItem operationItem2 = operationItem;
        synchronized (operationItem2) {
            operationItem.setDuration(this.calculateDuration(operationItem));
        }
    }

    private String calculateName(OperationItem operationItem) {
        return OperationDescriptorRenderer.renderCompact(operationItem);
    }

    private String calculateDuration(OperationItem operationItem) {
        if (operationItem.getFinishEvent() != null) {
            OperationResult result = operationItem.getFinishEvent().getResult();
            String duration = this.formatDuration(result.getStartTime(), result.getEndTime());
            return NLS.bind((String)ExecutionViewMessages.Tree_Item_Operation_Finished_In_0_Sec_Text, (Object)duration);
        }
        if (operationItem.getStartEvent() != null) {
            String duration = this.formatDuration(operationItem.getStartEvent().getEventTime(), System.currentTimeMillis());
            return NLS.bind((String)ExecutionViewMessages.Tree_Item_Operation_Running_For_0_Sec_Text, (Object)duration);
        }
        return "";
    }

    private ImageDescriptor calculateImage(OperationItem operationItem) {
        if (operationItem.getFinishEvent() != null) {
            OperationResult result = operationItem.getFinishEvent().getResult();
            if (result instanceof FailureResult) {
                return PluginImages.OPERATION_FAILURE.withState(PluginImage.ImageState.ENABLED).getImageDescriptor();
            }
            if (result instanceof SkippedResult) {
                return PluginImages.OPERATION_SKIPPED.withState(PluginImage.ImageState.ENABLED).getImageDescriptor();
            }
            if (result instanceof SuccessResult) {
                return PluginImages.OPERATION_SUCCESS.withState(PluginImage.ImageState.ENABLED).getImageDescriptor();
            }
            return null;
        }
        return PluginImages.OPERATION_IN_PROGRESS.withState(PluginImage.ImageState.ENABLED).getImageDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDuration(long startTime, long endTime) {
        DecimalFormat decimalFormat = this.durationFormat;
        synchronized (decimalFormat) {
            return this.durationFormat.format((double)(endTime - startTime) / 1000.0);
        }
    }
}

