/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.ui.css;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtensionProvider;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.polarsys.capella.vp.ms.ui.css.engine.DiagramCSSEngine;
import org.w3c.dom.stylesheets.StyleSheet;

public class CSSRefreshExtension
implements IRefreshExtensionProvider,
IRefreshExtension {
    private static RGBValues conflictColor = RGBValues.create((int)255, (int)165, (int)0);
    private static RGBValues excludeColor = RGBValues.create((int)220, (int)220, (int)220);
    private static RGBValues excludeForegroundColor = RGBValues.create((int)200, (int)200, (int)200);
    private static RGBValues excludeBackroundColor = RGBValues.create((int)200, (int)200, (int)200);
    private static RGBValues excludeLabelColor = RGBValues.create((int)120, (int)120, (int)120);

    public boolean provides(DDiagram diagram) {
        return true;
    }

    public IRefreshExtension getRefreshExtension(DDiagram viewPoint) {
        return this;
    }

    public void beforeRefresh(DDiagram dDiagram) {
    }

    public void postRefresh(DDiagram dDiagram) {
        Session session = SessionManager.INSTANCE.getSession((EObject)dDiagram);
        URI workspaceBaseURI = null;
        if (session != null) {
            workspaceBaseURI = session.getSessionResource().getURI().trimSegments(1);
        }
        DiagramCSSEngine engine = new DiagramCSSEngine();
        engine.setErrorHandler(new CSSErrorHandler(){

            public void error(Exception e) {
                e.printStackTrace();
            }
        });
        HashSet<URI> seen = new HashSet<URI>();
        for (Layer layer : dDiagram.getActivatedLayers()) {
            URI resource = layer.eResource().getURI();
            if (!seen.add(resource)) continue;
            URI baseCssURI = resource.trimFileExtension();
            String filename = String.valueOf(baseCssURI.lastSegment()) + ".css";
            URI cssURI = baseCssURI.appendFileExtension("css");
            URI diagramCssURI = baseCssURI.trimSegments(1).appendSegment(dDiagram.getDescription().getName()).appendSegment(filename);
            try {
                Object object;
                URL diagramCssURL;
                InputStream is22;
                Throwable throwable;
                URL cssURL = FileLocator.find((URL)new URL(cssURI.toString()));
                if (cssURL != null) {
                    Throwable throwable2 = null;
                    throwable = null;
                    try {
                        is22 = cssURL.openStream();
                        try {
                            StyleSheet styleSheet = engine.parseStyleSheet(is22);
                        }
                        finally {
                            if (is22 != null) {
                                is22.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if ((diagramCssURL = FileLocator.find((URL)new URL(diagramCssURI.toString()))) != null) {
                    throwable = null;
                    is22 = null;
                    try (InputStream is = diagramCssURL.openStream();){
                        object = engine.parseStyleSheet(is);
                    }
                    catch (Throwable is22) {
                        if (throwable == null) {
                            throwable = is22;
                        } else if (throwable != is22) {
                            throwable.addSuppressed(is22);
                        }
                        throw throwable;
                    }
                }
                if (workspaceBaseURI == null) continue;
                URI customCSSURI = workspaceBaseURI.appendSegment(cssURI.segment(cssURI.segmentCount() - 1));
                String customCSSPlatformString = customCSSURI.toPlatformString(true);
                IFile customCSSFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(customCSSPlatformString));
                if (!customCSSFile.exists()) continue;
                try {
                    object = null;
                    Object var19_27 = null;
                    try (InputStream is = customCSSFile.getContents();){
                        engine.parseStyleSheet(is);
                    }
                    catch (Throwable throwable4) {
                        if (object == null) {
                            object = throwable4;
                        } else if (object != throwable4) {
                            ((Throwable)object).addSuppressed(throwable4);
                        }
                        throw object;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            catch (MalformedURLException cssURL) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        engine.applyStyles(dDiagram, true);
    }
}

