/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.ui.css.helpers;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.css2.CSS2RGBColorImpl;
import org.eclipse.e4.ui.css.swt.helpers.ThemeElementDefinitionHelper;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class CSSSiriusColorHelper {
    public static final String COLOR_DEFINITION_MARKER = "#";
    private static final Pattern HEX_COLOR_VALUE_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");
    private static Field[] cachedFields;

    public static RGBValues getSiriusColor(RGBColor rgbColor) {
        return CSSSiriusColorHelper.getRGBA(rgbColor);
    }

    public static RGBValues getSiriusColor(CSSValue value) {
        if (value.getCssValueType() != 1) {
            return null;
        }
        RGBValues rgba = CSSSiriusColorHelper.getRGBA((CSSPrimitiveValue)value);
        return rgba;
    }

    public static boolean hasColorDefinitionAsValue(CSSValue value) {
        CSSPrimitiveValue primitiveValue;
        if (value.getCssValueType() == 1 && (primitiveValue = (CSSPrimitiveValue)value).getPrimitiveType() == 19) {
            return CSSSiriusColorHelper.hasColorDefinitionAsValue(primitiveValue.getStringValue());
        }
        return false;
    }

    public static boolean hasColorDefinitionAsValue(String name) {
        if (name.startsWith(COLOR_DEFINITION_MARKER)) {
            return !HEX_COLOR_VALUE_PATTERN.matcher(name).matches();
        }
        return false;
    }

    private static RGBA process(Display display, String value) {
        Field[] fields = CSSSiriusColorHelper.getFields();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals(value)) {
                    return display.getSystemColor(field.getInt(null)).getRGBA();
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return display.getSystemColor(2).getRGBA();
    }

    private static Field[] getFields() {
        if (cachedFields == null) {
            Class<SWT> clazz = SWT.class;
            Field[] allFields = clazz.getDeclaredFields();
            ArrayList<Field> applicableFields = new ArrayList<Field>(allFields.length);
            Field[] fieldArray = allFields;
            int n = allFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getType() == Integer.TYPE && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getName().startsWith("COLOR")) {
                    applicableFields.add(field);
                }
                ++n2;
            }
            cachedFields = applicableFields.toArray(new Field[applicableFields.size()]);
        }
        return cachedFields;
    }

    public static RGBValues getRGBA(String name) {
        RGBColor color = CSS2ColorHelper.getRGBColor((String)name);
        if (color != null) {
            return CSSSiriusColorHelper.getRGBA(color);
        }
        return null;
    }

    public static RGBValues getRGBA(RGBColor color) {
        return RGBValues.create((int)((int)color.getRed().getFloatValue((short)1)), (int)((int)color.getGreen().getFloatValue((short)1)), (int)((int)color.getBlue().getFloatValue((short)1)));
    }

    public static RGBValues getRGBA(CSSValue value) {
        if (value.getCssValueType() != 1) {
            return null;
        }
        return CSSSiriusColorHelper.getRGBA((CSSPrimitiveValue)value);
    }

    public static RGBValues getRGBA(CSSPrimitiveValue value) {
        RGBValues rgba = null;
        switch (value.getPrimitiveType()) {
            case 19: 
            case 21: {
                String string = value.getStringValue();
                rgba = CSSSiriusColorHelper.getRGBA(string);
                break;
            }
            case 25: {
                RGBColor rgbColor = value.getRGBColorValue();
                rgba = CSSSiriusColorHelper.getRGBA(rgbColor);
            }
        }
        return rgba;
    }

    public static Integer getPercent(CSSPrimitiveValue value) {
        int percent = 0;
        switch (value.getPrimitiveType()) {
            case 2: {
                percent = (int)value.getFloatValue((short)2);
            }
        }
        return percent;
    }

    public static RGBColor getRGBColor(RGBValues color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return new CSS2RGBColorImpl(red, green, blue);
    }

    private static RGBValues findColorByDefinition(String name) {
        RGB rgb;
        IColorAndFontProvider provider = CSSActivator.getDefault().getColorAndFontProvider();
        if (provider != null && (rgb = provider.getColor(ThemeElementDefinitionHelper.normalizeId((String)name.substring(1)))) != null) {
            return RGBValues.create((int)rgb.red, (int)rgb.green, (int)rgb.blue);
        }
        return null;
    }

    public static boolean equals(Color c1, Color c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equals((Object)c2);
    }
}

