/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.activity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ObjectNodeOrderingKind implements Enumerator
{
    FIFO(0, "FIFO", "FIFO"),
    LIFO(1, "LIFO", "LIFO"),
    ORDERED(2, "ordered", "ordered"),
    UNORDERED(3, "unordered", "unordered");

    public static final int FIFO_VALUE = 0;
    public static final int LIFO_VALUE = 1;
    public static final int ORDERED_VALUE = 2;
    public static final int UNORDERED_VALUE = 3;
    private static final ObjectNodeOrderingKind[] VALUES_ARRAY;
    public static final List<ObjectNodeOrderingKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ObjectNodeOrderingKind[]{FIFO, LIFO, ORDERED, UNORDERED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ObjectNodeOrderingKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectNodeOrderingKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectNodeOrderingKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectNodeOrderingKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectNodeOrderingKind get(int value) {
        switch (value) {
            case 0: {
                return FIFO;
            }
            case 1: {
                return LIFO;
            }
            case 2: {
                return ORDERED;
            }
            case 3: {
                return UNORDERED;
            }
        }
        return null;
    }

    private ObjectNodeOrderingKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

