/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CancellationException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.impl.QueryEvaluationEngine;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.element.MBookmark;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MElementContainer;
import org.obeonetwork.m2doc.element.MHyperLink;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MPagination;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.MText;
import org.obeonetwork.m2doc.generator.BookmarkManager;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.generator.M2DocEvaluationEnvironment;
import org.obeonetwork.m2doc.generator.RawCopier;
import org.obeonetwork.m2doc.generator.UserContentManager;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.TokenType;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.Bookmark;
import org.obeonetwork.m2doc.template.Cell;
import org.obeonetwork.m2doc.template.Comment;
import org.obeonetwork.m2doc.template.Conditional;
import org.obeonetwork.m2doc.template.ContentControl;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.IGenerateable;
import org.obeonetwork.m2doc.template.Let;
import org.obeonetwork.m2doc.template.Link;
import org.obeonetwork.m2doc.template.Query;
import org.obeonetwork.m2doc.template.Repetition;
import org.obeonetwork.m2doc.template.Row;
import org.obeonetwork.m2doc.template.Statement;
import org.obeonetwork.m2doc.template.StaticFragment;
import org.obeonetwork.m2doc.template.Table;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.UserContent;
import org.obeonetwork.m2doc.template.UserDoc;
import org.obeonetwork.m2doc.template.util.TemplateSwitch;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;

public class M2DocEvaluator
extends TemplateSwitch<XWPFParagraph> {
    public static final int MONITOR_WORK = 30;
    private static final String INVALID_BOOKMARK_STATEMENT = "Invalid bookmark statement: ";
    private static final String INVALID_CONDITIONAL_STATEMENT = "Invalid if statement: ";
    private static final String INVALID_BLOCK_STATEMENT = "Invalid block: ";
    private static final String INVALID_LET_STATEMENT = "Invalid let statement: ";
    private static final String INVALID_LINK_STATEMENT = "Invalid link statement: ";
    private static final String INVALID_QUERY_STATEMENT = "Invalid query statement: ";
    private static final String INVALID_REPETITION_STATEMENT = "Invalid for statement: ";
    private static final String INVALID_USERDOC_STATEMENT = "Invalid userDoc statement: ";
    private static final String AN_I_O_PROBLEM_OCCURED_WHILE_READING = "An I/O Problem occured while reading %s: %s.";
    private static final String PICTURE_INVALID_FORMAT = "Picture in %s has an invalid format: %s.";
    private final BookmarkManager bookmarkManager;
    private final Stack<Map<String, Object>> variablesStack = new Stack();
    private IBody generatedDocument;
    private final RawCopier copier;
    private XWPFParagraph currentTemplateParagraph;
    private XWPFParagraph currentGeneratedParagraph;
    private XWPFTable currentGeneratedTable;
    private XWPFTableRow currentGeneratedRow;
    private boolean forceNewParagraph;
    private UserContentManager userContentManager;
    private Set<String> encountereduserDocIds = new HashSet<String>();
    private final IQueryEvaluationEngine evaluator;
    private GenerationResult result;
    private Monitor monitor;

    public M2DocEvaluator(M2DocEvaluationEnvironment m2docEnv, Monitor monitor) {
        this.bookmarkManager = m2docEnv.getBookmarkManager();
        this.userContentManager = m2docEnv.getUserContentManager();
        this.copier = m2docEnv.getCopier();
        this.evaluator = new QueryEvaluationEngine((IQueryEnvironment)m2docEnv.getQueryEnvironment());
        this.monitor = monitor;
    }

    public GenerationResult generate(IGenerateable generateable, Map<String, Object> variables, IBody destinationDocument) {
        this.generatedDocument = destinationDocument;
        this.variablesStack.push(variables);
        try {
            this.result = new GenerationResult(destinationDocument);
            this.result.getDuplicatedUserContentIDs().addAll(this.userContentManager.getDuplicatedUserContentIDs());
            this.doSwitch(generateable);
        }
        finally {
            this.variablesStack.pop();
        }
        return this.result;
    }

    @Override
    public XWPFParagraph caseDocumentTemplate(DocumentTemplate documentTemplate) {
        this.cleanBody(this.generatedDocument);
        int unitOfWork = 30 / (1 + documentTemplate.getFooters().size() + documentTemplate.getHeaders().size());
        this.doSwitch(documentTemplate.getBody());
        this.worked(this.monitor, unitOfWork);
        XWPFDocument document = (XWPFDocument)this.generatedDocument;
        Iterator footers = document.getFooterList().iterator();
        for (Block footer : documentTemplate.getFooters()) {
            XWPFFooter f = (XWPFFooter)footers.next();
            this.cleanBody((IBody)f);
            this.generatedDocument = f;
            this.doSwitch(footer);
            this.worked(this.monitor, unitOfWork);
        }
        Iterator headers = document.getHeaderList().iterator();
        for (Block header : documentTemplate.getHeaders()) {
            XWPFHeader h = (XWPFHeader)headers.next();
            this.cleanBody((IBody)h);
            this.generatedDocument = h;
            this.doSwitch(header);
            this.worked(this.monitor, unitOfWork);
        }
        return this.currentGeneratedParagraph;
    }

    private void worked(Monitor progressMonitor, int work) {
        if (progressMonitor.isCanceled()) {
            throw new CancellationException("Canceled by user");
        }
        progressMonitor.worked(work);
    }

    @Override
    public XWPFParagraph caseTemplate(Template template) {
        this.cleanBody(this.generatedDocument);
        return this.doSwitch(template.getBody());
    }

    public void cleanBody(IBody body) {
        if (body instanceof XWPFDocument) {
            XWPFDocument document = (XWPFDocument)body;
            int size = body.getBodyElements().size();
            int i = 0;
            while (i < size) {
                document.removeBodyElement(0);
                ++i;
            }
            document.getDocument().getBody().getSdtList().clear();
        } else if (body instanceof XWPFHeaderFooter) {
            CTHdrFtr ctHdrFtr = (CTHdrFtr)((XWPFHeaderFooter)body)._getHdrFtr().copy();
            ctHdrFtr.getPList().clear();
            ctHdrFtr.getTblList().clear();
            ctHdrFtr.getSdtList().clear();
            ((XWPFHeaderFooter)body).setHeaderFooter(ctHdrFtr);
        } else {
            throw new UnsupportedOperationException("unkown IBody type :" + body.getClass());
        }
    }

    @Override
    public XWPFParagraph caseStaticFragment(StaticFragment staticFragment) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        for (XWPFRun run : staticFragment.getRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, run).getParent();
        }
        return currentParagraph;
    }

    private XWPFRun insertRun(XWPFParagraph paragraph, XWPFRun srcRun) {
        XWPFParagraph newParagraph;
        if (srcRun.getParent() != this.currentTemplateParagraph || this.forceNewParagraph || paragraph == null) {
            newParagraph = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)srcRun.getParent());
            this.forceNewParagraph = false;
        } else {
            newParagraph = paragraph;
        }
        XWPFRun newRun = null;
        if (srcRun instanceof XWPFHyperlinkRun) {
            CTHyperlink newHyperlink = newParagraph.getCTP().addNewHyperlink();
            newHyperlink.set((XmlObject)((XWPFHyperlinkRun)srcRun).getCTHyperlink());
            newRun = new XWPFHyperlinkRun(newHyperlink, srcRun.getCTR(), srcRun.getParent());
            newParagraph.addRun(newRun);
        } else {
            newRun = newParagraph.createRun();
            newRun.getCTR().set((XmlObject)srcRun.getCTR());
        }
        return newRun;
    }

    private XWPFRun insertFieldRunReplacement(XWPFParagraph paragraph, XWPFRun srcRun, String replacement) {
        XWPFParagraph newParagraph;
        if (srcRun.getParent() != this.currentTemplateParagraph || this.forceNewParagraph) {
            newParagraph = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)srcRun.getParent());
            this.forceNewParagraph = false;
        } else {
            newParagraph = paragraph;
        }
        return this.insertString(newParagraph, srcRun, replacement);
    }

    private XWPFRun insertString(XWPFParagraph paragraph, XWPFRun srcRun, String text) {
        int fragmentStart = 0;
        int i = 0;
        while (i < text.length()) {
            char current = text.charAt(i);
            switch (current) {
                case '\n': {
                    XWPFRun inserted = this.insertFragment(paragraph, srcRun, text.substring(fragmentStart, i));
                    inserted.addBreak();
                    fragmentStart = i + 1;
                    break;
                }
                case '\t': {
                    XWPFRun inserted = this.insertFragment(paragraph, srcRun, text.substring(fragmentStart, i));
                    inserted.addTab();
                    fragmentStart = i + 1;
                    break;
                }
                case '\r': {
                    if (i + 1 >= text.length() || text.charAt(i + 1) != '\n') break;
                    XWPFRun inserted = this.insertFragment(paragraph, srcRun, text.substring(fragmentStart, i));
                    inserted.addBreak();
                    fragmentStart = ++i + 1;
                    break;
                }
            }
            ++i;
        }
        return this.insertFragment(paragraph, srcRun, text.substring(fragmentStart, text.length()));
    }

    private XWPFRun insertFragment(XWPFParagraph paragraph, XWPFRun srcRun, String fragment) {
        XWPFRun generatedRun = paragraph.createRun();
        generatedRun.getCTR().set(srcRun.getCTR().copy());
        generatedRun.getCTR().getInstrTextList().clear();
        generatedRun.setText(fragment);
        return generatedRun;
    }

    private XWPFParagraph createNewParagraph(IBody body, XWPFParagraph srcParagraph) {
        XWPFParagraph res = this.createParagraph(body);
        CTP ctp = (CTP)srcParagraph.getCTP().copy();
        ctp.getRList().clear();
        ctp.getFldSimpleList().clear();
        ctp.getHyperlinkList().clear();
        res.getCTP().set((XmlObject)ctp);
        int runNb = res.getRuns().size();
        int i = 0;
        while (i < runNb) {
            res.removeRun(i);
            ++i;
        }
        this.currentTemplateParagraph = srcParagraph;
        this.currentGeneratedParagraph = res;
        return res;
    }

    private XWPFParagraph createParagraph(IBody body) {
        XWPFParagraph res;
        if (body instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)body;
            res = cell.addParagraph();
        } else if (body instanceof XWPFDocument) {
            res = ((XWPFDocument)body).createParagraph();
        } else if (body instanceof XWPFHeaderFooter) {
            res = ((XWPFHeaderFooter)body).createParagraph();
        } else {
            throw new UnsupportedOperationException("unkown IBody type :" + body.getClass());
        }
        return res;
    }

    protected boolean hasError(IConstruct construct) {
        boolean res = false;
        for (TemplateValidationMessage message : construct.getValidationMessages()) {
            if (message.getLevel() != ValidationMessageLevel.ERROR) continue;
            res = true;
            break;
        }
        return res;
    }

    @Override
    public XWPFParagraph caseQuery(Query query) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(query)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, query, INVALID_QUERY_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(query.getQuery(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, query, queryResult.getDiagnostic());
            } else {
                Object value = queryResult.getResult();
                XWPFRun styleRun = query.getStyleRun();
                currentParagraph = this.insertObject(currentParagraph, value, styleRun);
            }
        }
        return currentParagraph;
    }

    private XWPFParagraph insertObject(XWPFParagraph paragraph, Object object, XWPFRun run) {
        XWPFParagraph res;
        if (object instanceof Collection) {
            XWPFParagraph currentParagraph = paragraph;
            for (Object child : (Collection)object) {
                currentParagraph = this.insertObject(currentParagraph, child, run);
            }
            res = currentParagraph;
        } else if (object instanceof MHyperLink) {
            res = this.insertMHyperLink(paragraph, run, (MHyperLink)object);
        } else if (object instanceof MBookmark) {
            this.insertMBookmark(paragraph, run, (MBookmark)object);
            res = paragraph;
        } else if (object instanceof MImage) {
            if (object != MImage.EMPTY) {
                XWPFRun imageRun = this.insertFieldRunReplacement(paragraph, run, "");
                this.insertMImage((XWPFParagraph)imageRun.getParent(), imageRun, (MImage)object);
                res = (XWPFParagraph)imageRun.getParent();
            } else {
                res = paragraph;
            }
        } else if (object instanceof MText) {
            res = (XWPFParagraph)this.insertMText(paragraph, run, (MText)object).getParent();
        } else if (object instanceof MTable) {
            if (!((MTable)object).getRows().isEmpty()) {
                XWPFRun tableRun = run;
                tableRun.getCTR().getInstrTextList().clear();
                this.insertMTable(tableRun, (MTable)object);
                res = (XWPFParagraph)tableRun.getParent();
            } else {
                res = paragraph;
            }
        } else if (object instanceof MPagination) {
            res = this.insertMPagination(paragraph, run, (MPagination)object);
        } else if (object instanceof MParagraph) {
            res = this.insertMParagraph(this.generatedDocument, (MParagraph)object, run);
        } else if (object instanceof IBody) {
            XWPFRun bodyRun = this.insertFieldRunReplacement(paragraph, run, "");
            res = this.insertBody((XWPFParagraph)bodyRun.getParent(), (IBody)object);
        } else if (object instanceof GenerationResult) {
            XWPFRun generationRun = this.insertFieldRunReplacement(paragraph, run, "");
            res = this.insertGenerationResult((XWPFParagraph)generationRun.getParent(), (GenerationResult)object);
        } else {
            res = object == null ? (XWPFParagraph)this.insertFieldRunReplacement(paragraph, run, "").getParent() : (XWPFParagraph)this.insertFieldRunReplacement(paragraph, run, object.toString()).getParent();
        }
        return res;
    }

    private XWPFParagraph insertGenerationResult(XWPFParagraph paragraph, GenerationResult generationResult) {
        XWPFParagraph insertBody;
        for (TemplateValidationMessage message : generationResult.getMessages()) {
            this.result.addMessage(message);
        }
        this.currentGeneratedParagraph = insertBody = this.insertBody(paragraph, generationResult.getBody());
        return insertBody;
    }

    private XWPFParagraph insertBody(XWPFParagraph paragraph, IBody body) {
        XWPFParagraph res;
        try {
            res = this.copier.copyBody(paragraph, body, this.bookmarkManager);
        }
        catch (Exception e) {
            this.result.addMessage(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, e.getMessage()));
            res = paragraph;
        }
        return res;
    }

    private XWPFRun insertMText(XWPFParagraph paragraph, XWPFRun run, MText text) {
        XWPFRun res;
        if (text.getText() != null) {
            XWPFRun textRun = this.insertFieldRunReplacement(paragraph, run, text.getText());
            if (text.getStyle() != null) {
                this.applyMStyle(textRun, text.getStyle());
            }
            res = textRun;
        } else {
            res = run;
        }
        return res;
    }

    @Override
    public XWPFParagraph caseComment(Comment comment) {
        return this.currentGeneratedParagraph;
    }

    private void insertMBookmark(XWPFParagraph paragraph, XWPFRun run, MBookmark bookmark) {
        XWPFParagraph newParagraph = (XWPFParagraph)this.insertFieldRunReplacement(paragraph, run, "").getParent();
        if (bookmark.isReference()) {
            this.bookmarkManager.insertReference(newParagraph, bookmark.getId(), bookmark.getText());
        } else {
            this.bookmarkManager.startBookmark(this.result, newParagraph, bookmark.getId());
            this.insertFieldRunReplacement(newParagraph, run, bookmark.getText());
            this.bookmarkManager.endBookmark(this.result, newParagraph, bookmark.getId());
        }
    }

    private XWPFParagraph insertMHyperLink(XWPFParagraph paragraph, XWPFRun run, MHyperLink hyperLink) {
        XWPFRun linkRun = this.insertMText(paragraph, run, hyperLink);
        XWPFParagraph res = (XWPFParagraph)linkRun.getParent();
        String id = res.getBody().getPart().getPackagePart().addExternalRelationship(hyperLink.getUrl(), XWPFRelation.HYPERLINK.getRelation()).getId();
        CTHyperlink cLink = res.getCTP().addNewHyperlink();
        cLink.setId(id);
        if (hyperLink.getStyle() != null) {
            this.applyMStyle(linkRun, hyperLink.getStyle());
        }
        cLink.setRArray(new CTR[]{linkRun.getCTR()});
        res.removeRun(res.getRuns().indexOf(linkRun));
        return res;
    }

    private void insertMImage(XWPFParagraph paragraph, XWPFRun run, MImage image) {
        try {
            int heigth = Units.toEMU((double)image.getHeight());
            int width = Units.toEMU((double)image.getWidth());
            Throwable throwable = null;
            Object var7_10 = null;
            try (InputStream imageStream = image.getInputStream();){
                run.addPicture(imageStream, image.getType().getPoiType(), image.getURI().toString(), width, heigth);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InvalidFormatException e) {
            this.insertMessage(paragraph, ValidationMessageLevel.ERROR, String.format(PICTURE_INVALID_FORMAT, image.getURI().toString(), e.getMessage()));
        }
        catch (IOException e) {
            this.insertMessage(paragraph, ValidationMessageLevel.ERROR, String.format(AN_I_O_PROBLEM_OCCURED_WHILE_READING, image.getURI().toString(), e.getMessage()));
        }
    }

    private XWPFParagraph insertMPagination(XWPFParagraph paragraph, XWPFRun run, MPagination mPagination) {
        XWPFParagraph res;
        switch (mPagination) {
            case newColumn: {
                this.insertFieldRunReplacement(paragraph, run, "").addBreak(BreakType.COLUMN);
                res = paragraph;
                break;
            }
            case newParagraph: {
                res = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)run.getParent());
                break;
            }
            case newPage: {
                this.insertFieldRunReplacement(paragraph, run, "").addBreak(BreakType.PAGE);
                res = paragraph;
                break;
            }
            case newTableOfContent: {
                CTP ctP = paragraph.getCTP();
                CTSimpleField toc = ctP.addNewFldSimple();
                toc.setInstr("TOC \\h");
                toc.setDirty(STOnOff.TRUE);
                res = paragraph;
                break;
            }
            case newTextWrapping: {
                this.insertFieldRunReplacement(paragraph, run, "").addBreak(BreakType.TEXT_WRAPPING);
                res = paragraph;
                break;
            }
            case ligneBreak: {
                this.insertFieldRunReplacement(paragraph, run, "").addBreak();
                res = paragraph;
                break;
            }
            default: {
                throw new IllegalStateException("Not supported MPagination.");
            }
        }
        return res;
    }

    private XWPFParagraph insertMParagraph(IBody body, MParagraph paragraph, XWPFRun run) {
        XWPFParagraph newParagraph = this.createNewParagraph(body, (XWPFParagraph)run.getParent());
        if (paragraph.getStyleName() != null) {
            newParagraph.setStyle(paragraph.getStyleName());
        }
        if (paragraph.getHAlignment() != null) {
            newParagraph.setAlignment(this.getHAllignment(paragraph.getHAlignment()));
        }
        if (paragraph.getNumberingID() != null) {
            newParagraph.setNumID(BigInteger.valueOf(paragraph.getNumberingID()));
        }
        if (paragraph.getNumberingLevel() != null) {
            newParagraph.getCTP().getPPr().getNumPr().addNewIlvl().setVal(BigInteger.valueOf(paragraph.getNumberingLevel()));
        }
        return this.insertObject(newParagraph, paragraph.getContents(), run);
    }

    private void insertMTable(XWPFRun run, MTable table) {
        XWPFTable xwpfTable;
        if (this.generatedDocument instanceof XWPFDocument) {
            if (table.getLabel() != null) {
                XWPFRun captionRun = run;
                IRunBody runBody = captionRun.getParent();
                if (runBody instanceof XWPFParagraph) {
                    ((XWPFParagraph)runBody).setSpacingAfter(0);
                }
                captionRun.setText(table.getLabel());
                captionRun.setBold(true);
            }
            if ((xwpfTable = ((XWPFDocument)this.generatedDocument).createTable()).getRows().size() > 0) {
                xwpfTable.removeRow(0);
            }
        } else if (this.generatedDocument instanceof XWPFHeaderFooter) {
            XWPFHeaderFooter headerFooter = (XWPFHeaderFooter)this.generatedDocument;
            int index = headerFooter._getHdrFtr().getTblList().size();
            CTTbl ctTbl = headerFooter._getHdrFtr().insertNewTbl(index);
            xwpfTable = new XWPFTable(ctTbl, (IBody)headerFooter);
            if (xwpfTable.getRows().size() > 0) {
                xwpfTable.removeRow(0);
            }
            headerFooter.insertTable(index, xwpfTable);
        } else if (this.generatedDocument instanceof XWPFTableCell) {
            CTTbl ctTbl;
            XWPFTableCell tcell = (XWPFTableCell)this.generatedDocument;
            if (table.getLabel() != null) {
                XWPFRun captionRun = run;
                IRunBody runBody = captionRun.getParent();
                if (runBody instanceof XWPFParagraph) {
                    ((XWPFParagraph)runBody).setSpacingAfter(0);
                }
                captionRun.setText(table.getLabel());
                captionRun.setBold(true);
            }
            if ((xwpfTable = new XWPFTable(ctTbl = tcell.getCTTc().addNewTbl(), (IBody)tcell)).getRows().size() > 0) {
                xwpfTable.removeRow(0);
            }
            int tableRank = tcell.getTables().size();
            tcell.insertTable(tableRank, xwpfTable);
            tcell.addParagraph();
        } else {
            xwpfTable = null;
            this.insertMessage((XWPFParagraph)run.getParent(), ValidationMessageLevel.ERROR, "m:table can't be inserted here.");
        }
        if (xwpfTable != null) {
            this.fillTable(xwpfTable, table);
        }
    }

    private void fillTable(XWPFTable xwpfTable, MTable mTable) {
        boolean removeBorders;
        if (mTable.getStyleID() != null) {
            xwpfTable.setStyleID(mTable.getStyleID());
            removeBorders = true;
            if (xwpfTable.getCTTbl().getTblPr() != null && xwpfTable.getCTTbl().getTblPr().isSetTblBorders()) {
                xwpfTable.getCTTbl().getTblPr().unsetTblBorders();
            }
        } else {
            removeBorders = false;
        }
        for (MTable.MRow mRow : mTable.getRows()) {
            XWPFTableRow xwpfRow = xwpfTable.createRow();
            while (!xwpfRow.getTableCells().isEmpty()) {
                xwpfRow.removeCell(0);
            }
            xwpfRow.getCtRow().getTcList().clear();
            for (MTable.MCell mCell : mRow.getCells()) {
                XWPFTableCell xwpfCell = xwpfRow.createCell();
                XWPFParagraph xwpfCellParagraph = (XWPFParagraph)xwpfCell.getParagraphs().get(0);
                xwpfCellParagraph.setSpacingBefore(0);
                xwpfCellParagraph.setSpacingAfter(0);
                if (mCell != null && mCell.getHAlignment() != null) {
                    xwpfCellParagraph.setAlignment(this.getHAllignment(mCell.getHAlignment()));
                }
                this.setCellContent(xwpfCell, mCell);
                if (!removeBorders || xwpfCell.getCTTc().getTcPr() == null || !xwpfCell.getCTTc().getTcPr().isSetTcBorders()) continue;
                xwpfCell.getCTTc().getTcPr().unsetTcBorders();
            }
        }
    }

    private ParagraphAlignment getHAllignment(MElementContainer.HAlignment hAlignment) {
        ParagraphAlignment res;
        switch (hAlignment) {
            case BOTH: {
                res = ParagraphAlignment.BOTH;
                break;
            }
            case CENTER: {
                res = ParagraphAlignment.CENTER;
                break;
            }
            case DISTRIBUTE: {
                res = ParagraphAlignment.DISTRIBUTE;
                break;
            }
            case HIGH_KASHIDA: {
                res = ParagraphAlignment.HIGH_KASHIDA;
                break;
            }
            case LEFT: {
                res = ParagraphAlignment.LEFT;
                break;
            }
            case LOW_KASHIDA: {
                res = ParagraphAlignment.LOW_KASHIDA;
                break;
            }
            case MEDIUM_KASHIDA: {
                res = ParagraphAlignment.MEDIUM_KASHIDA;
                break;
            }
            case NUM_TAB: {
                res = ParagraphAlignment.NUM_TAB;
                break;
            }
            case RIGHT: {
                res = ParagraphAlignment.RIGHT;
                break;
            }
            case THAI_DISTRIBUTE: {
                res = ParagraphAlignment.THAI_DISTRIBUTE;
                break;
            }
            default: {
                throw new IllegalStateException("can't convert " + (Object)((Object)hAlignment));
            }
        }
        return res;
    }

    private void setCellContent(XWPFTableCell cell, MTable.MCell mCell) {
        XWPFParagraph cellParagraph = (XWPFParagraph)cell.getParagraphs().get(0);
        XWPFRun cellRun = cellParagraph.createRun();
        if (mCell != null) {
            Color backGroundColor;
            MElement contents = mCell.getContents();
            if (mCell.getVAlignment() != null) {
                cell.setVerticalAlignment(this.getVAglignment(mCell.getVAlignment()));
            }
            if (contents != null) {
                IBody savedGeneratedDocument = this.generatedDocument;
                XWPFParagraph savedGeneratedParagraph = this.currentGeneratedParagraph;
                XWPFParagraph savedTemplateParagraph = this.currentTemplateParagraph;
                this.generatedDocument = cell;
                this.currentGeneratedParagraph = cellParagraph;
                this.currentTemplateParagraph = cellParagraph;
                try {
                    this.insertObject(cellParagraph, contents, cellRun);
                }
                finally {
                    this.generatedDocument = savedGeneratedDocument;
                    this.currentGeneratedParagraph = savedGeneratedParagraph;
                    this.currentTemplateParagraph = savedTemplateParagraph;
                }
                cellParagraph.removeRun(cellParagraph.getRuns().indexOf(cellRun));
            }
            if ((backGroundColor = mCell.getBackgroundColor()) != null) {
                cell.setColor(M2DocEvaluator.hexColor(backGroundColor));
            }
        }
    }

    private XWPFTableCell.XWPFVertAlign getVAglignment(MTable.MCell.VAlignment vAlignment) {
        XWPFTableCell.XWPFVertAlign res;
        switch (vAlignment) {
            case BOTH: {
                res = XWPFTableCell.XWPFVertAlign.BOTH;
                break;
            }
            case BOTTOM: {
                res = XWPFTableCell.XWPFVertAlign.BOTTOM;
                break;
            }
            case CENTER: {
                res = XWPFTableCell.XWPFVertAlign.CENTER;
                break;
            }
            case TOP: {
                res = XWPFTableCell.XWPFVertAlign.TOP;
                break;
            }
            default: {
                throw new IllegalStateException("can't convert " + (Object)((Object)vAlignment));
            }
        }
        return res;
    }

    private void applyMStyle(XWPFRun run, MStyle style) {
        if (style.getFontSize() != -1) {
            run.setFontSize(style.getFontSize());
        }
        if (style.getFontName() != null) {
            run.setFontFamily(style.getFontName());
        }
        if (style.getFontModifiers() != -1) {
            run.setBold((style.getFontModifiers() & 1) != 0);
            run.setItalic((style.getFontModifiers() & 2) != 0);
            if ((style.getFontModifiers() & 4) != 0) {
                run.setUnderline(UnderlinePatterns.SINGLE);
            }
            run.setStrikeThrough((style.getFontModifiers() & 8) != 0);
        }
        if (style.getForegroundColor() != null) {
            run.setColor(M2DocEvaluator.hexColor(style.getForegroundColor()));
        }
        if (style.getBackgroundColor() != null) {
            CTRPr ctrpr = run.getCTR().getRPr() != null ? run.getCTR().getRPr() : run.getCTR().addNewRPr();
            CTShd ctshd = ctrpr.getShd() != null ? ctrpr.getShd() : ctrpr.addNewShd();
            ctshd.setVal(STShd.CLEAR);
            ctshd.setColor((Object)"auto");
            ctshd.setFill((Object)M2DocEvaluator.hexColor(style.getBackgroundColor()));
        }
    }

    private static String hexColor(Color color) {
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public XWPFParagraph caseRepetition(Repetition repetition) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(repetition)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, repetition, INVALID_REPETITION_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(repetition.getQuery(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, repetition, queryResult.getDiagnostic());
            } else {
                ArrayList<Object> iteration = new ArrayList<Object>();
                if (queryResult.getResult() instanceof Collection) {
                    iteration.addAll((Collection)queryResult.getResult());
                } else if (queryResult.getResult() != null) {
                    iteration.add(queryResult.getResult());
                } else {
                    this.insertMessage(currentParagraph, ValidationMessageLevel.WARNING, String.valueOf(repetition.getIterationVar()) + " value is null.");
                }
                HashMap<String, Object> newVariables = new HashMap<String, Object>(this.variablesStack.peek());
                this.variablesStack.push(newVariables);
                try {
                    for (Object e : iteration) {
                        newVariables.put(repetition.getIterationVar(), e);
                        currentParagraph = this.doSwitch(repetition.getBody());
                        this.closingRepretition(repetition);
                    }
                }
                finally {
                    this.variablesStack.pop();
                }
            }
        }
        return currentParagraph;
    }

    public XWPFParagraph doSwitch(EObject eObject) {
        if (!this.monitor.isCanceled()) {
            return (XWPFParagraph)super.doSwitch(eObject);
        }
        return null;
    }

    @Override
    public XWPFParagraph caseLet(Let let) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(let)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, let, INVALID_LET_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(let.getValue(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, let, queryResult.getDiagnostic());
            } else {
                HashMap<String, Object> newVariables = new HashMap<String, Object>(this.variablesStack.peek());
                this.variablesStack.push(newVariables);
                try {
                    newVariables.put(let.getName(), queryResult.getResult());
                    currentParagraph = this.doSwitch(let.getBody());
                }
                finally {
                    this.variablesStack.pop();
                }
            }
        }
        return currentParagraph;
    }

    @Override
    public XWPFParagraph caseUserDoc(UserDoc userDoc) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(userDoc)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, userDoc, INVALID_USERDOC_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(userDoc.getId(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, userDoc, queryResult.getDiagnostic());
            } else if (queryResult.getResult() == null) {
                this.insertMessage(currentParagraph, ValidationMessageLevel.ERROR, "User doc id can't be null.");
            } else {
                String id = queryResult.getResult().toString();
                currentParagraph = this.insertUserContent(currentParagraph, userDoc, id);
            }
        }
        return currentParagraph;
    }

    private XWPFParagraph insertUserContent(XWPFParagraph paragraph, UserDoc userDoc, String id) {
        XWPFParagraph currentParagraph = paragraph;
        currentParagraph = this.addStartUserDocField(currentParagraph, userDoc, id);
        this.manageUserDocIdUniqueness(currentParagraph, id, userDoc);
        UserContent userContent = this.userContentManager.consumeUserContent(id);
        boolean needNewParagraphBeforeEndTag = true;
        if (userContent == null) {
            currentParagraph = this.doSwitch(userDoc.getBody());
        } else {
            try {
                currentParagraph = this.copier.copyUserContent(userContent, currentParagraph);
                needNewParagraphBeforeEndTag = this.copier.needNewParagraph();
            }
            catch (Exception e) {
                this.insertMessage(currentParagraph, ValidationMessageLevel.ERROR, "userdoc copy error : " + e.getMessage());
            }
        }
        if (currentParagraph == null) {
            currentParagraph = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)((XWPFRun)userDoc.getRuns().get(0)).getParent());
            needNewParagraphBeforeEndTag = false;
        }
        if (!currentParagraph.getCTP().xmlText().contains("<w:instrText>" + TokenType.ENDUSERCONTENT.getValue() + "</w:instrText>")) {
            currentParagraph = this.addEndUserContentField(currentParagraph, userDoc, needNewParagraphBeforeEndTag);
        }
        return currentParagraph;
    }

    private void manageUserDocIdUniqueness(XWPFParagraph paragraph, String id, UserDoc userdoc) {
        if (!this.encountereduserDocIds.add(id)) {
            String msgError = "The id '" + id + "' is already used in generated document. Ids must be unique otherwise document part contained userContent could be lost at next generation.";
            this.insertMessage(paragraph, ValidationMessageLevel.ERROR, msgError);
            TemplateValidationMessage templateValidationMessage = new TemplateValidationMessage(ValidationMessageLevel.ERROR, msgError, (XWPFRun)userdoc.getRuns().get(userdoc.getRuns().size() - 1));
            userdoc.getValidationMessages().add((Object)templateValidationMessage);
        }
    }

    private XWPFParagraph addStartUserDocField(XWPFParagraph paragraph, UserDoc userDoc, String id) {
        XWPFParagraph res;
        if (paragraph == null || userDoc.getRuns().size() != 0 && ((XWPFRun)userDoc.getRuns().get(0)).getParent() != this.currentTemplateParagraph) {
            XWPFParagraph newParagraph = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)((XWPFRun)userDoc.getRuns().get(0)).getParent());
            this.insertTag(newParagraph, String.valueOf(TokenType.USERCONTENT.getValue()) + " " + id);
            res = newParagraph;
        } else {
            this.insertTag(paragraph, String.valueOf(TokenType.USERCONTENT.getValue()) + " " + id);
            res = paragraph;
        }
        return res;
    }

    private XWPFParagraph addEndUserContentField(XWPFParagraph paragraph, UserDoc userDoc, boolean needNewParagraph) {
        XWPFParagraph res;
        if (needNewParagraph) {
            XWPFParagraph newParagraph = this.createNewParagraph(this.generatedDocument, paragraph);
            this.insertTag(newParagraph, TokenType.ENDUSERCONTENT.getValue());
            res = newParagraph;
        } else {
            this.insertTag(paragraph, TokenType.ENDUSERCONTENT.getValue());
            res = paragraph;
        }
        return res;
    }

    private void insertTag(XWPFParagraph paragraph, String instrText) {
        paragraph.getCTP().addNewR().addNewFldChar().setFldCharType(STFldCharType.BEGIN);
        paragraph.getCTP().addNewR().addNewInstrText().setStringValue(instrText);
        paragraph.getCTP().addNewR().addNewFldChar().setFldCharType(STFldCharType.SEPARATE);
        paragraph.getCTP().addNewR().addNewFldChar().setFldCharType(STFldCharType.END);
    }

    private void closingRepretition(Repetition repetition) {
        int bodySize = repetition.getBody().getStatements().size();
        if (bodySize > 0 && ((Statement)repetition.getBody().getStatements().get(bodySize - 1)).getRuns().size() > 0) {
            IConstruct lastBodyPart = (IConstruct)repetition.getBody().getStatements().get(bodySize - 1);
            int runNumber = lastBodyPart.getRuns().size();
            XWPFRun lastRun = (XWPFRun)lastBodyPart.getRuns().get(runNumber - 1);
            int closingRunNumber = repetition.getClosingRuns().size();
            if (closingRunNumber > 0 && ((XWPFRun)repetition.getClosingRuns().get(0)).getParent() != lastRun.getParent()) {
                this.forceNewParagraph = true;
            }
        }
    }

    @Override
    public XWPFParagraph caseBlock(Block block) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(block)) {
            if (currentParagraph == null && block.getRuns().isEmpty()) {
                currentParagraph = this.createParagraph(this.generatedDocument);
            }
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, block, INVALID_BLOCK_STATEMENT);
        } else {
            for (IConstruct construct : block.getStatements()) {
                currentParagraph = this.doSwitch(construct);
            }
        }
        return currentParagraph;
    }

    @Override
    public XWPFParagraph caseConditional(Conditional conditional) {
        XWPFParagraph currentParagraph;
        block4: {
            block6: {
                block7: {
                    EvaluationResult evaluationResult;
                    block5: {
                        block3: {
                            currentParagraph = this.currentGeneratedParagraph;
                            if (!this.hasError(conditional)) break block3;
                            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, conditional, INVALID_CONDITIONAL_STATEMENT);
                            break block4;
                        }
                        evaluationResult = this.evaluator.eval(conditional.getCondition(), this.variablesStack.peek());
                        if (evaluationResult.getDiagnostic().getSeverity() == 0) break block5;
                        currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, conditional, evaluationResult.getDiagnostic());
                        for (XWPFRun tagRun : conditional.getClosingRuns()) {
                            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
                        }
                        break block4;
                    }
                    if (!(evaluationResult.getResult() instanceof Boolean)) break block6;
                    if (!((Boolean)evaluationResult.getResult()).booleanValue()) break block7;
                    currentParagraph = this.doSwitch(conditional.getThen());
                    break block4;
                }
                if (conditional.getElse() == null) break block4;
                currentParagraph = this.doSwitch(conditional.getElse());
                break block4;
            }
            for (XWPFRun tagRun : conditional.getRuns()) {
                currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
            }
            this.insertMessage(currentParagraph, ValidationMessageLevel.ERROR, "Condition evaluation result must be a boolean.");
            for (XWPFRun tagRun : conditional.getClosingRuns()) {
                currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
            }
        }
        return currentParagraph;
    }

    @Override
    public XWPFParagraph caseTable(Table table) {
        CTTbl copy = (CTTbl)table.getTable().getCTTbl().copy();
        copy.getTrList().clear();
        XWPFTable saveTable = this.currentGeneratedTable;
        try {
            XWPFTable newTable = POIServices.getInstance().createTable(this.generatedDocument);
            newTable.getCTTbl().set((XmlObject)copy);
            this.currentGeneratedTable = newTable;
            for (Row row : table.getRows()) {
                this.doSwitch(row);
            }
        }
        finally {
            this.currentGeneratedTable = saveTable;
        }
        this.currentTemplateParagraph = null;
        return null;
    }

    @Deprecated
    public static XWPFTable createTable(IBody body) {
        return POIServices.getInstance().createTable(body);
    }

    @Override
    public XWPFParagraph caseRow(Row row) {
        XWPFTableRow savedRow = this.currentGeneratedRow;
        try {
            this.currentGeneratedRow = new XWPFTableRow(this.currentGeneratedTable.getCTTbl().addNewTr(), this.currentGeneratedTable);
            CTRow ctRow = (CTRow)row.getTableRow().getCtRow().copy();
            ctRow.getTcList().clear();
            while (!this.currentGeneratedRow.getTableCells().isEmpty()) {
                this.currentGeneratedRow.removeCell(0);
            }
            this.currentGeneratedRow.getCtRow().set((XmlObject)ctRow);
            for (Cell cell : row.getCells()) {
                this.doSwitch(cell);
            }
        }
        finally {
            this.currentGeneratedRow = savedRow;
        }
        return this.currentGeneratedParagraph;
    }

    @Override
    public XWPFParagraph caseCell(Cell cell) {
        XWPFParagraph firstParagraph;
        XWPFTableCell newCell = new XWPFTableCell(this.currentGeneratedRow.getCtRow().addNewTc(), this.currentGeneratedRow, this.generatedDocument);
        CTTc ctCell = (CTTc)cell.getTableCell().getCTTc().copy();
        ctCell.getPList().clear();
        ctCell.getTblList().clear();
        ctCell.getSdtList().clear();
        newCell.getCTTc().set((XmlObject)ctCell);
        IBody savedGeneratedDocument = this.generatedDocument;
        XWPFParagraph savedGeneratedParagraph = this.currentGeneratedParagraph;
        XWPFParagraph savedTemplateParagraph = this.currentTemplateParagraph;
        this.generatedDocument = newCell;
        try {
            this.doSwitch(cell.getBody());
        }
        finally {
            this.generatedDocument = savedGeneratedDocument;
            this.currentGeneratedParagraph = savedGeneratedParagraph;
            this.currentTemplateParagraph = savedTemplateParagraph;
        }
        if (newCell.getParagraphs().size() == 1 && (firstParagraph = (XWPFParagraph)newCell.getParagraphs().get(0)).getRuns().isEmpty()) {
            newCell.getCTTc().addNewP();
        }
        return this.currentGeneratedParagraph;
    }

    @Override
    public XWPFParagraph caseBookmark(Bookmark bookmark) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(bookmark)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, bookmark, INVALID_BOOKMARK_STATEMENT);
        } else {
            EvaluationResult evaluationResult = this.evaluator.eval(bookmark.getName(), this.variablesStack.peek());
            if (evaluationResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, bookmark, evaluationResult.getDiagnostic());
            } else {
                if (currentParagraph == null) {
                    currentParagraph = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)bookmark.getStyleRun().getParent());
                }
                this.bookmarkManager.startBookmark(this.result, currentParagraph, evaluationResult.getResult().toString());
                currentParagraph = this.doSwitch(bookmark.getBody());
                this.bookmarkManager.endBookmark(this.result, currentParagraph, evaluationResult.getResult().toString());
            }
        }
        return currentParagraph;
    }

    @Override
    public XWPFParagraph caseContentControl(ContentControl contentControl) {
        CTSdtBlock sdtBlock;
        if (this.generatedDocument instanceof XWPFDocument) {
            sdtBlock = ((XWPFDocument)this.generatedDocument).getDocument().getBody().addNewSdt();
        } else if (this.generatedDocument instanceof XWPFHeaderFooter) {
            sdtBlock = ((XWPFHeaderFooter)this.generatedDocument)._getHdrFtr().addNewSdt();
        } else if (this.generatedDocument instanceof XWPFFootnote) {
            sdtBlock = ((XWPFFootnote)this.generatedDocument).getCTFtnEdn().addNewSdt();
        } else if (this.generatedDocument instanceof XWPFTableCell) {
            sdtBlock = ((XWPFTableCell)this.generatedDocument).getCTTc().addNewSdt();
        } else {
            throw new IllegalStateException("can't insert control in " + this.generatedDocument.getClass().getCanonicalName());
        }
        sdtBlock.set(contentControl.getBlock().copy());
        new XWPFSDT(sdtBlock, this.generatedDocument);
        return this.currentGeneratedParagraph;
    }

    protected XWPFParagraph insertQueryEvaluationMessages(XWPFParagraph paragraph, IConstruct construct, Diagnostic diagnostic) {
        XWPFParagraph currentParagraph = paragraph;
        for (XWPFRun tagRun : construct.getRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
        }
        for (TemplateValidationMessage message : M2DocUtils.appendDiagnosticMessage(currentParagraph, diagnostic)) {
            this.result.addMessage(message);
        }
        for (XWPFRun tagRun : construct.getClosingRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
        }
        return currentParagraph;
    }

    protected XWPFParagraph insertQuerySyntaxMessages(XWPFParagraph paragraph, IConstruct construct, String errorPrefix) {
        XWPFParagraph currentParagraph = paragraph;
        for (XWPFRun tagRun : construct.getRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
        }
        for (TemplateValidationMessage message : construct.getValidationMessages()) {
            this.insertMessage(currentParagraph, message.getLevel(), String.valueOf(errorPrefix) + message.getMessage());
        }
        for (XWPFRun tagRun : construct.getClosingRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
        }
        return currentParagraph;
    }

    protected void insertMessage(XWPFParagraph paragraph, ValidationMessageLevel level, String message) {
        this.result.addMessage(M2DocUtils.appendMessageRun(paragraph, level, message));
    }

    @Override
    public XWPFParagraph caseLink(Link link) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(link)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, link, INVALID_LINK_STATEMENT);
        } else {
            EvaluationResult nameResult = this.evaluator.eval(link.getName(), this.variablesStack.peek());
            if (nameResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, link, nameResult.getDiagnostic());
            } else {
                EvaluationResult textResult = this.evaluator.eval(link.getText(), this.variablesStack.peek());
                if (nameResult.getDiagnostic().getSeverity() != 0) {
                    currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, link, textResult.getDiagnostic());
                } else {
                    this.bookmarkManager.insertReference(currentParagraph, nameResult.getResult().toString(), textResult.getResult().toString());
                }
            }
        }
        return currentParagraph;
    }
}

