/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.debug;

import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.osgi.util.NLS;

class DebugUtil {
    private static final boolean IS_WINDOWS = Platform.getOS().equals("win32");

    DebugUtil() {
    }

    static String getDefaultExecutablePath(IProject project) {
        if (project == null) {
            return "";
        }
        IFile cargoFile = project.getFile("Cargo.toml");
        if (!cargoFile.exists()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(project.getName());
        builder.append("/target/debug/");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream file = cargoFile.getContents();){
                Properties properties = new Properties();
                properties.load(file);
                String name = properties.getProperty("name");
                if (!name.isEmpty()) {
                    name = name.substring(name.indexOf(34) + 1, name.lastIndexOf(34));
                }
                builder.append(name);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            CorrosionPlugin.logError(e);
        }
        if (IS_WINDOWS) {
            builder.append(".exe");
        }
        return builder.toString();
    }

    static String getMessageFromGdbExecutionException(CoreException e) {
        IStatus status = e.getStatus();
        String statusMessage = status.getMessage();
        Throwable statusException = status.getException();
        if (statusException != null) {
            String exceptionMessage = statusException.getLocalizedMessage();
            return NLS.bind((String)Messages.RustDebugTabGroup_gdbErrorMsg, (Object)statusMessage, (Object)exceptionMessage);
        }
        return statusMessage;
    }
}

