/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.tableviewer;

import org.eclipse.datatools.sqltools.common.core.tableviewer.DataSerializer;
import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.Messages;
import org.eclipse.datatools.sqltools.common.ui.util.Images;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class TableDataLabelProvider
implements ITableLabelProvider {
    protected Image checkedImage = Images.get("org.eclipse.datatools.sqltools.common.uichecked.gif");
    protected Image uncheckedImage = Images.get("org.eclipse.datatools.sqltools.common.uiunchecked.gif");

    public Image getColumnImage(Object element, int columnIndex) {
        IRowData rowData;
        int columnType;
        if (element instanceof IRowData && (columnType = (rowData = (IRowData)element).getTableData().getColumnType(columnIndex)) == 16) {
            if (rowData.getValue(columnIndex) == null) {
                return this.uncheckedImage;
            }
            if (rowData.getValue(columnIndex).equals("true")) {
                return this.checkedImage;
            }
            return this.uncheckedImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IRowData rowData;
        int columnType;
        if (!(element instanceof IRowData)) {
            return columnIndex == 0 ? Messages.TableDataLabelProvider_new_row : "";
        }
        if (element instanceof IRowData && (columnType = (rowData = (IRowData)element).getTableData().getColumnType(columnIndex)) == 16) {
            return "";
        }
        IRowData row = (IRowData)element;
        Object o = row.getValue(columnIndex);
        String s = DataSerializer.serialize(o, row.getTableData().getColumnType(columnIndex));
        return s == null ? Messages.TableDataLabelProvider_null : s;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

