/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.action.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.model.ASATableSchemaEditModel;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.model.ASATableSchemaImmutableModel;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.action.EditSchemaObjectAction;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;

public class EditASATableAction
extends EditSchemaObjectAction {
    protected BaseTable _table;
    protected String _taskTitle = Messages.EditASATableAction_open_asa_table_editor;
    private static final String ObjectTypeID = "org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.impl.SybaseASATableImpl";

    public EditASATableAction() {
    }

    public EditASATableAction(String text, ImageDescriptor image, BaseTable table) {
        super(text, image);
        this._table = table;
    }

    public EditASATableAction(String text, int style, BaseTable table) {
        super(text, style);
        this._table = table;
    }

    public EditASATableAction(String vendorName, String version, String objectTypeId, ISchemaObjectEditModel modelObj, DatabaseIdentifier databaseIdentifier, BaseTable table) {
        super(vendorName, version, objectTypeId, modelObj, databaseIdentifier);
        this._table = table;
    }

    public EditASATableAction(String vendorName, String version, String objectTypeId, String text, ImageDescriptor image, ISchemaObjectEditModel modelObj, BaseTable table) {
        super(vendorName, version, objectTypeId, text, image, modelObj);
        this._table = table;
    }

    public EditASATableAction(String vendorName, String version, String objectTypeId, String text, int style, ISchemaObjectEditModel modelObj, DatabaseIdentifier databaseIdentifier, BaseTable table) {
        super(vendorName, version, objectTypeId, text, style, modelObj, databaseIdentifier);
        this._table = table;
    }

    public EditASATableAction(String vendorName, String version, String objectTypeId, String text, ISchemaObjectEditModel modelObj, BaseTable table) {
        super(vendorName, version, objectTypeId, text, modelObj);
        this._table = table;
    }

    public EditASATableAction(String text, BaseTable table) {
        super(text);
        this._table = table;
    }

    private void init() {
        if (this.getSQLObject() instanceof Table) {
            this._table = (BaseTable)this.getSQLObject();
            Database db = this._table.getSchema().getDatabase();
            DatabaseIdentifier di = new DatabaseIdentifier(ModelUtil.getConnectionProfile((Database)db).getName(), this._table.getSchema().getCatalog().getName());
            this.setVendorName(db.getVendor());
            this.setVersion(db.getVersion());
            this.setDatabaseIdentifier(di);
        }
        this.setObjectTypeId(ObjectTypeID);
    }

    public void run(IProgressMonitor monitor) {
        this.init();
        if (this._table.getColumns().size() == 0) {
            ExamplePlugin.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                    MessageDialog d = new MessageDialog(ExamplePlugin.getActiveWorkbenchShell(), Messages.EditASATableAction_obj_not_found, null, NLS.bind((String)Messages.EditASATableAction_obj_not_found_detail, (Object)EditASATableAction.this._table.getName()), 1, buttons, 0);
                    d.open();
                }
            });
            return;
        }
        monitor.beginTask(this._taskTitle, -1);
        monitor.subTask(Messages.EditASATableAction_read_objects);
        HashMap additionalObjs = new HashMap();
        this.collectPrimaryTable(additionalObjs);
        if (monitor.isCanceled()) {
            return;
        }
        this.collectionAuthIds(additionalObjs);
        if (monitor.isCanceled()) {
            return;
        }
        this.collectIndexes(additionalObjs);
        monitor.worked(3);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.EditASATableAction_read_objects);
        ASATableSchemaImmutableModel editorModel = new ASATableSchemaImmutableModel(this._table, additionalObjs);
        DatabaseIdentifier di = new DatabaseIdentifier(ModelUtil.getConnectionProfile((Database)this._table.getSchema().getDatabase()).getName(), this._table.getSchema().getCatalog().getName());
        ASATableSchemaEditModel editModel = new ASATableSchemaEditModel(editorModel, di);
        this.setModelObj((ISchemaObjectEditModel)editModel);
        monitor.worked(5);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.EditASATableAction_initializing);
        ExamplePlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                EditASATableAction.this.checkAndOpenEditor();
                ISchemaObjectEditModel obj = (ISchemaObjectEditModel)EditASATableAction.this.getModelObj();
                IEditorPart part = EditASATableAction.this.getPart();
                if (part != null && part instanceof ISchemaObjectEditor) {
                    ((ISchemaObjectEditor)part).setEditorPartName(obj.getMainSQLObject().getName());
                }
                EditASATableAction.this.setActivePage();
            }
        });
        monitor.worked(2);
        monitor.done();
    }

    private void collectIndexes(Map additionalObjs) {
        EList indexes = this._table.getIndex();
        additionalObjs.put("indexes", indexes);
    }

    private void collectUDTs(Map additionalObjs) {
        Database db = this._table.getSchema().getDatabase();
        for (Schema s : db.getSchemas()) {
            additionalObjs.put(String.valueOf(s.getName()) + "UDT", s.getUserDefinedTypes());
        }
    }

    private void collectionAuthIds(Map additionalObjs) {
        EList authids = this._table.getSchema().getDatabase().getAuthorizationIds();
        additionalObjs.put("authids", authids);
    }

    private void collectPrimaryTable(Map additionalObjs) {
        Iterator iter = this._table.getForeignKeys().iterator();
        int i = 0;
        while (iter.hasNext()) {
            ForeignKey fk = (ForeignKey)iter.next();
            fk.getUniqueConstraint();
            additionalObjs.put("Primary_table_entry" + Integer.toString(i), fk.getReferencedTable());
            ++i;
        }
    }

    public String getTaskTitle() {
        return this._taskTitle;
    }

    public void setTaskTitle(String title) {
        this._taskTitle = title;
    }
}

