/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDistinctUserDefinedType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogStructuredUserDefinedType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWRowDataTypeImpl;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.Field;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogRowDataType
extends LUWRowDataTypeImpl
implements ICatalogObject {
    private boolean fieldsLoaded = false;

    public void refresh() {
        this.fieldsLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public EList getFields() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getFields();
        }
        if (!this.fieldsLoaded) {
            this.loadFileds();
        }
        return this.fields;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 10) {
            this.getFields();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadFileds() {
        if (this.fieldsLoaded) {
            return;
        }
        this.fieldsLoaded = true;
        EList fieldList = super.getFields();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            Connection connection = this.getConnection();
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("SELECT FIELDNAME, FIELDTYPESCHEMA, FIELDTYPEMODULENAME, FIELDTYPENAME, LENGTH, SCALE, CODEPAGE FROM SYSCAT.ROWFIELDS WHERE TYPENAME = '" + LUWUtil.getIdentifier(this.getName()) + "'" + " AND TYPESCHEMA='" + LUWUtil.getIdentifier(this.getSchema().getName()) + "'" + " AND TYPEMODULENAME IS NULL" + " ORDER BY ORDINAL ");
            while (r.next()) {
                PredefinedDataTypeDefinition typeDefinition;
                Field field = (Field)factory.create(SQLDataTypesPackage.eINSTANCE.getField());
                String fieldName = r.getString("FIELDNAME");
                field.setName(fieldName);
                String typeName = r.getString("FIELDTYPENAME");
                if (typeName.equalsIgnoreCase("FLOAT")) {
                    int length = r.getInt(4);
                    typeName = length == 4 ? "REAL" : "DOUBLE";
                }
                if ((typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName)) != null) {
                    EStructuralFeature feature;
                    int length;
                    int codePage;
                    if (typeDefinition.getPrimitiveType().getValue() == 0) {
                        int codePage2 = r.getInt("CODEPAGE");
                        if (codePage2 == 0) {
                            typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("CHAR () FOR BIT DATA");
                        }
                    } else if (typeDefinition.getPrimitiveType().getValue() == 1 && (codePage = r.getInt("CODEPAGE")) == 0) {
                        typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("VARCHAR () FOR BIT DATA");
                    }
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        length = r.getInt("LENGTH");
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)new Integer(length));
                    } else if (typeDefinition.isPrecisionSupported()) {
                        if (typeName.equals("TIMESTAMP")) {
                            length = r.getInt("LENGTH");
                            feature = type.eClass().getEStructuralFeature("fractionalSecondsPrecision");
                            type.eSet(feature, (Object)new Integer(length));
                        } else {
                            length = r.getInt("LENGTH");
                            if (typeName.equals("DECFLOAT")) {
                                length = length == 8 ? 16 : 34;
                            }
                            feature = type.eClass().getEStructuralFeature("precision");
                            type.eSet(feature, (Object)new Integer(length));
                        }
                    }
                    if (typeDefinition.isScaleSupported()) {
                        int scale = r.getInt("SCALE");
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)new Integer(scale));
                    }
                    field.setContainedType((SQLDataType)type);
                } else {
                    String typeSchemaName = r.getString("FIELDTYPESCHEMA").trim();
                    r.getString("FIELDTYPEMODULENAME");
                    field.setReferencedType(LUWCatalogRowDataType.getUserDefinedType(this, typeSchemaName, typeName));
                }
                fieldList.add((Object)field);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private static UserDefinedType getUserDefinedType(UserDefinedType type, String schemaName, String userDefinedTypeName) {
        LUWCatalogDistinctUserDefinedType userDefinedType2;
        Schema schema = LUWCatalogStructuredUserDefinedType.getSchema(type, schemaName);
        for (LUWCatalogDistinctUserDefinedType userDefinedType2 : schema.getUserDefinedTypes()) {
            if (!userDefinedType2.getName().equals(userDefinedTypeName)) continue;
            return userDefinedType2;
        }
        userDefinedType2 = new LUWCatalogDistinctUserDefinedType();
        userDefinedType2.setName(userDefinedTypeName);
        userDefinedType2.setSchema(schema);
        return userDefinedType2;
    }
}

