/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.model.impl;

import java.util.Collection;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWFederatedDataSource;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWOption;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWWrapper;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.WrapperType;
import org.eclipse.datatools.modelbase.sql.schema.impl.SQLObjectImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class LUWWrapperImpl
extends SQLObjectImpl
implements LUWWrapper {
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected static final String LIBRARY_EDEFAULT = null;
    protected String library = LIBRARY_EDEFAULT;
    protected static final boolean FENCED_EDEFAULT = true;
    protected boolean fenced = true;
    protected static final WrapperType WRAPPER_TYPE_EDEFAULT = WrapperType.RELATIONAL_LITERAL;
    protected WrapperType wrapperType = WRAPPER_TYPE_EDEFAULT;
    protected static final LUWFederatedDataSource DATA_SOURCE_EDEFAULT = LUWFederatedDataSource.DB2_LITERAL;
    protected LUWFederatedDataSource dataSource = DATA_SOURCE_EDEFAULT;
    protected EList discoveredLibraries;
    protected EList servers;
    protected LUWDatabase luwDatabase;
    protected EList options;

    protected LUWWrapperImpl() {
    }

    protected EClass eStaticClass() {
        return LUWPackage.Literals.LUW_WRAPPER;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldVersion, (Object)this.version));
        }
    }

    public String getLibrary() {
        return this.library;
    }

    public void setLibrary(String newLibrary) {
        String oldLibrary = this.library;
        this.library = newLibrary;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldLibrary, (Object)this.library));
        }
    }

    public boolean isFenced() {
        return this.fenced;
    }

    public void setFenced(boolean newFenced) {
        boolean oldFenced = this.fenced;
        this.fenced = newFenced;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldFenced, this.fenced));
        }
    }

    public WrapperType getWrapperType() {
        return this.wrapperType;
    }

    public void setWrapperType(WrapperType newWrapperType) {
        WrapperType oldWrapperType = this.wrapperType;
        WrapperType wrapperType = this.wrapperType = newWrapperType == null ? WRAPPER_TYPE_EDEFAULT : newWrapperType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldWrapperType, (Object)this.wrapperType));
        }
    }

    public LUWFederatedDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(LUWFederatedDataSource newDataSource) {
        LUWFederatedDataSource oldDataSource = this.dataSource;
        LUWFederatedDataSource lUWFederatedDataSource = this.dataSource = newDataSource == null ? DATA_SOURCE_EDEFAULT : newDataSource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldDataSource, (Object)this.dataSource));
        }
    }

    public EList getDiscoveredLibraries() {
        if (this.discoveredLibraries == null) {
            this.discoveredLibraries = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 13);
        }
        return this.discoveredLibraries;
    }

    public EList getServers() {
        if (this.servers == null) {
            this.servers = new EObjectWithInverseResolvingEList(LUWServer.class, (InternalEObject)this, 14, 11);
        }
        return this.servers;
    }

    public LUWDatabase getLUWDatabase() {
        if (this.luwDatabase != null && this.luwDatabase.eIsProxy()) {
            InternalEObject oldLUWDatabase = (InternalEObject)this.luwDatabase;
            this.luwDatabase = (LUWDatabase)this.eResolveProxy(oldLUWDatabase);
            if (this.luwDatabase != oldLUWDatabase && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 15, (Object)oldLUWDatabase, (Object)this.luwDatabase));
            }
        }
        return this.luwDatabase;
    }

    public LUWDatabase basicGetLUWDatabase() {
        return this.luwDatabase;
    }

    public NotificationChain basicSetLUWDatabase(LUWDatabase newLUWDatabase, NotificationChain msgs) {
        LUWDatabase oldLUWDatabase = this.luwDatabase;
        this.luwDatabase = newLUWDatabase;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldLUWDatabase, (Object)newLUWDatabase);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setLUWDatabase(LUWDatabase newLUWDatabase) {
        if (newLUWDatabase != this.luwDatabase) {
            NotificationChain msgs = null;
            if (this.luwDatabase != null) {
                msgs = ((InternalEObject)this.luwDatabase).eInverseRemove((InternalEObject)this, 18, LUWDatabase.class, msgs);
            }
            if (newLUWDatabase != null) {
                msgs = ((InternalEObject)newLUWDatabase).eInverseAdd((InternalEObject)this, 18, LUWDatabase.class, msgs);
            }
            if ((msgs = this.basicSetLUWDatabase(newLUWDatabase, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)newLUWDatabase, (Object)newLUWDatabase));
        }
    }

    public EList getOptions() {
        if (this.options == null) {
            this.options = new EObjectContainmentEList(LUWOption.class, (InternalEObject)this, 16);
        }
        return this.options;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 14: {
                return ((InternalEList)this.getServers()).basicAdd((Object)otherEnd, msgs);
            }
            case 15: {
                if (this.luwDatabase != null) {
                    msgs = ((InternalEObject)this.luwDatabase).eInverseRemove((InternalEObject)this, 18, LUWDatabase.class, msgs);
                }
                return this.basicSetLUWDatabase((LUWDatabase)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 14: {
                return ((InternalEList)this.getServers()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return this.basicSetLUWDatabase(null, msgs);
            }
            case 16: {
                return ((InternalEList)this.getOptions()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getVersion();
            }
            case 9: {
                return this.getLibrary();
            }
            case 10: {
                return this.isFenced() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.getWrapperType();
            }
            case 12: {
                return this.getDataSource();
            }
            case 13: {
                return this.getDiscoveredLibraries();
            }
            case 14: {
                return this.getServers();
            }
            case 15: {
                if (resolve) {
                    return this.getLUWDatabase();
                }
                return this.basicGetLUWDatabase();
            }
            case 16: {
                return this.getOptions();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setVersion((String)newValue);
                return;
            }
            case 9: {
                this.setLibrary((String)newValue);
                return;
            }
            case 10: {
                this.setFenced((Boolean)newValue);
                return;
            }
            case 11: {
                this.setWrapperType((WrapperType)((Object)newValue));
                return;
            }
            case 12: {
                this.setDataSource((LUWFederatedDataSource)((Object)newValue));
                return;
            }
            case 13: {
                this.getDiscoveredLibraries().clear();
                this.getDiscoveredLibraries().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getServers().clear();
                this.getServers().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setLUWDatabase((LUWDatabase)newValue);
                return;
            }
            case 16: {
                this.getOptions().clear();
                this.getOptions().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 9: {
                this.setLibrary(LIBRARY_EDEFAULT);
                return;
            }
            case 10: {
                this.setFenced(true);
                return;
            }
            case 11: {
                this.setWrapperType(WRAPPER_TYPE_EDEFAULT);
                return;
            }
            case 12: {
                this.setDataSource(DATA_SOURCE_EDEFAULT);
                return;
            }
            case 13: {
                this.getDiscoveredLibraries().clear();
                return;
            }
            case 14: {
                this.getServers().clear();
                return;
            }
            case 15: {
                this.setLUWDatabase(null);
                return;
            }
            case 16: {
                this.getOptions().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 9: {
                return LIBRARY_EDEFAULT == null ? this.library != null : !LIBRARY_EDEFAULT.equals(this.library);
            }
            case 10: {
                return !this.fenced;
            }
            case 11: {
                return this.wrapperType != WRAPPER_TYPE_EDEFAULT;
            }
            case 12: {
                return this.dataSource != DATA_SOURCE_EDEFAULT;
            }
            case 13: {
                return this.discoveredLibraries != null && !this.discoveredLibraries.isEmpty();
            }
            case 14: {
                return this.servers != null && !this.servers.isEmpty();
            }
            case 15: {
                return this.luwDatabase != null;
            }
            case 16: {
                return this.options != null && !this.options.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (version: ");
        result.append(this.version);
        result.append(", library: ");
        result.append(this.library);
        result.append(", fenced: ");
        result.append(this.fenced);
        result.append(", wrapperType: ");
        result.append((Object)this.wrapperType);
        result.append(", dataSource: ");
        result.append((Object)this.dataSource);
        result.append(", DiscoveredLibraries: ");
        result.append(this.discoveredLibraries);
        result.append(')');
        return result.toString();
    }
}

