/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.ui.sourceviewer;

import org.eclipse.datatools.enablement.oda.ecore.ui.sourceviewer.IOCLSourceViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class DefaultSourceViewer
implements IOCLSourceViewer {
    private IOCLSourceViewer state = new UninitializedState();

    public Composite createExpressionControl(Composite parent) {
        return this.state.createExpressionControl(parent);
    }

    public Composite getExpressionControl() {
        return this.state.getExpressionControl();
    }

    public String getExpression() {
        return this.state.getExpression();
    }

    public SourceViewer getSourceViewer() {
        return this.state.getSourceViewer();
    }

    public void setContext(EObject context) {
        this.state.setContext(context);
    }

    public void setExpression(String expression) {
        this.state.setExpression(expression);
    }

    public EObject getContext() {
        return this.state.getContext();
    }

    private static final class InitializedState
    implements IOCLSourceViewer {
        private final SourceViewer sourceViewer;
        private EObject context;

        InitializedState(SourceViewer sourceViewer) {
            this.sourceViewer = sourceViewer;
        }

        public Composite createExpressionControl(Composite parent) {
            throw new IllegalStateException("The expression control has already been created.");
        }

        public String getExpression() {
            return this.sourceViewer.getTextWidget().getText();
        }

        public Composite getExpressionControl() {
            return this.sourceViewer.getTextWidget();
        }

        public SourceViewer getSourceViewer() {
            return this.sourceViewer;
        }

        public void setContext(EObject context) {
            this.context = context;
        }

        public void setExpression(String expression) {
            this.sourceViewer.setDocument((IDocument)new Document(expression));
        }

        public EObject getContext() {
            return this.context;
        }
    }

    private final class UninitializedState
    implements IOCLSourceViewer {
        private UninitializedState() {
        }

        public Composite createExpressionControl(Composite parent) {
            SourceViewer sourceViewer = new SourceViewer(parent, null, 2048);
            sourceViewer.configure(new SourceViewerConfiguration());
            sourceViewer.setEditable(true);
            StyledText textWidget = sourceViewer.getTextWidget();
            DefaultSourceViewer.this.state = new InitializedState(sourceViewer);
            return textWidget;
        }

        public Composite getExpressionControl() {
            throw new IllegalStateException("The expression control has not been created.");
        }

        public String getExpression() {
            throw new IllegalStateException("The expression control has not been created.");
        }

        public SourceViewer getSourceViewer() {
            throw new IllegalStateException("The expression control has not been created.");
        }

        public void setContext(EObject context) {
            throw new IllegalStateException("The expression control has not been created.");
        }

        public void setExpression(String expression) {
            throw new IllegalStateException("The expression control has not been created.");
        }

        public EObject getContext() {
            throw new IllegalStateException("The expression control has not been created.");
        }
    }
}

