/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.enablement.oda.ecore.util.EPackageUtil;
import org.eclipse.datatools.enablement.oda.ecore.util.StringUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnDefinitionUtil {
    private static String COLUMN_NAME_DELIMITER = "::";

    public static ColumnDefinition createFor(String columnName) {
        ColumnDefinition definition = DesignFactory.eINSTANCE.createColumnDefinition();
        DataElementAttributes attributes = DesignFactory.eINSTANCE.createDataElementAttributes();
        attributes.setName(columnName);
        attributes.setNativeDataTypeCode(1);
        attributes.setUiDisplayName(columnName);
        definition.setAttributes(attributes);
        return definition;
    }

    public static ColumnDefinition createFor(ENamedElement[] featurePath) {
        return ColumnDefinitionUtil.createFor(ColumnDefinitionUtil.getColumnNameFor(featurePath));
    }

    public static EStructuralFeature[] featuresForColumn(EObject eObject, ColumnDefinition columnDefinition) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        String columnName = columnDefinition.getAttributes().getName();
        String[] decomposition = columnName.split(COLUMN_NAME_DELIMITER);
        String eClassName = decomposition[0];
        EClass eClass = ColumnDefinitionUtil.findEClass(eObject, eClassName);
        int i = 1;
        while (i < decomposition.length) {
            EStructuralFeature structuralFeature = eClass.getEStructuralFeature(decomposition[i]);
            if (structuralFeature == null) {
                return new EStructuralFeature[0];
            }
            features.add(structuralFeature);
            if (structuralFeature.getEType() instanceof EClass) {
                eClass = (EClass)structuralFeature.getEType();
            }
            ++i;
        }
        return features.toArray(new EStructuralFeature[features.size()]);
    }

    private static EClass findEClass(EObject eObject, String eClassName) {
        EClass eClass = eObject.eClass();
        ArrayList<EClass> eClassHierarchy = new ArrayList<EClass>();
        eClassHierarchy.add(eClass);
        eClassHierarchy.addAll((Collection<EClass>)eClass.getEAllSuperTypes());
        for (EClass type : eClassHierarchy) {
            if (!type.getName().equals(eClassName)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unable to locate");
    }

    private static String getColumnNameFor(ENamedElement[] featurePath) {
        ArrayList<String> names = new ArrayList<String>();
        ENamedElement[] eNamedElementArray = featurePath;
        int n = featurePath.length;
        int n2 = 0;
        while (n2 < n) {
            ENamedElement element = eNamedElementArray[n2];
            names.add(element.getName());
            ++n2;
        }
        return StringUtil.join(names.toArray(new String[names.size()]), COLUMN_NAME_DELIMITER);
    }

    public static ENamedElement[] getFeaturePath(ColumnDefinition columnDefinition, Set<EPackage> ePackages) {
        ArrayList<Object> path = new ArrayList<Object>();
        String columnName = columnDefinition.getAttributes().getName();
        String[] namePath = columnName.split(COLUMN_NAME_DELIMITER);
        EPackage ePackage = EPackageUtil.getPackageForClassifier(namePath[0], ePackages);
        if (ePackage != null) {
            EClass rootEClass = (EClass)ePackage.getEClassifier(namePath[0]);
            path.add(rootEClass);
            EStructuralFeature nextFeature = rootEClass.getEStructuralFeature(namePath[1]);
            path.add(rootEClass.getEStructuralFeature(namePath[1]));
            int i = 2;
            while (i < namePath.length) {
                String next = namePath[i];
                EStructuralFeature nextStructuralFeature = ((EClass)nextFeature.getEType()).getEStructuralFeature(next);
                path.add(nextStructuralFeature);
                nextFeature = nextStructuralFeature;
                ++i;
            }
        }
        return path.toArray(new ENamedElement[path.size()]);
    }
}

