/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.Enumeration;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.connectivity.internal.ui.wizards.DriverUIContributorComposite;
import org.eclipse.datatools.connectivity.sqm.core.SQMServices;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExtensibleProfileDetailsPropertyPage
extends ProfileDetailsPropertyPage
implements IDriverUIContributorInformation {
    private String driverCategoryID = "";
    private DriverListCombo driverCombo = null;
    private DriverUIContributorComposite contributedUIComposite = null;
    private Properties properties = null;

    public ExtensibleProfileDetailsPropertyPage() {
        this.noDefaultAndApplyButton();
        this.driverCategoryID = SQMServices.getProviderIDMappingRegistry().getCategoryIDforProviderID(this.getConnectionProfile().getProviderId());
    }

    public ExtensibleProfileDetailsPropertyPage(String driverCategoryID) {
        this.noDefaultAndApplyButton();
        this.driverCategoryID = driverCategoryID;
    }

    protected Properties collectProperties() {
        return this.getProperties();
    }

    protected void createCustomContents(Composite parent, boolean isReadOnly) {
        String tempDriverCategoryID = SQMServices.getProviderIDMappingRegistry().getCategoryIDforProviderID(this.getConnectionProfile().getProviderId());
        if (tempDriverCategoryID != null && tempDriverCategoryID.trim().length() > 0) {
            this.driverCategoryID = tempDriverCategoryID;
        }
        parent.setLayout((Layout)new GridLayout());
        this.driverCombo = new DriverListCombo(isReadOnly);
        this.driverCombo.setLabelText(ConnectivityUIPlugin.getDefault().getResourceString("ExtensibleProfileDetailsWizardPage.driverCombo.label"));
        this.driverCombo.setCategory(this.driverCategoryID);
        this.driverCombo.setNullDriverIsValid(false);
        this.driverCombo.createContents(parent);
        this.contributedUIComposite = new DriverUIContributorComposite(parent, (DialogPage)this, this, isReadOnly);
        this.driverCombo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ExtensibleProfileDetailsPropertyPage.this.handleDriverComboSelectionChangeEvent(e);
            }
        });
        if (this.driverCombo.getErrorMessage() != null) {
            this.setErrorMessage(this.driverCombo.getErrorMessage());
        }
        this.initialize();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"GENERIC_DB_PROFILE_PROPERTY_PAGE", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        return contents;
    }

    private void initialize() {
        IConnectionProfile connectionProfile = this.getConnectionProfile();
        String driverDefinitionID = connectionProfile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
        if (driverDefinitionID != null) {
            this.driverCombo.setSelectionToID(driverDefinitionID);
            this.handleDriverComboSelectionChangeEvent(new ChangeEvent(this.driverCombo.getCombo()));
        }
    }

    private void handleDriverComboSelectionChangeEvent(ChangeEvent e) {
        if (this.driverCombo.getErrorMessage() != null) {
            this.setErrorMessage(this.driverCombo.getErrorMessage());
        }
        if (this.driverCombo.getSelectedDriverInstance() != null) {
            this.properties = this.copyProperties(this.getConnectionProfile().getBaseProperties());
            this.properties.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", this.driverCombo.getSelectedDriverID());
        }
        this.contributedUIComposite.setDriverTemplateID(this.driverCombo.getSelectedDriverID());
    }

    public boolean determinePageCompletion() {
        boolean isComplete = this.contributedUIComposite.determineContributorCompletion();
        if (isComplete) {
            this.setErrorMessage(null);
        }
        this.setPingButtonEnabled(isComplete);
        return isComplete;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.determinePageCompletion();
    }

    private Properties copyProperties(Properties properties) {
        Properties copy = new Properties();
        Enumeration<Object> propertyKeys = properties.keys();
        while (propertyKeys.hasMoreElements()) {
            Object key = propertyKeys.nextElement();
            copy.put(key, properties.get(key));
        }
        return copy;
    }

    public Point computeSize() {
        return this.doComputeSize();
    }

    public void dispose() {
        this.driverCombo.dispose();
        super.dispose();
    }
}

