/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OdaScalarDataType implements Enumerator
{
    DATE_LITERAL(0, "Date", "Date"),
    DOUBLE_LITERAL(1, "Double", "Double"),
    INTEGER_LITERAL(2, "Integer", "Integer"),
    STRING_LITERAL(3, "String", "String"),
    TIME_LITERAL(4, "Time", "Time"),
    TIMESTAMP_LITERAL(5, "Timestamp", "Timestamp"),
    DECIMAL_LITERAL(6, "Decimal", "Decimal"),
    BLOB_LITERAL(7, "Blob", "Blob"),
    CLOB_LITERAL(8, "Clob", "Clob"),
    BOOLEAN_LITERAL(9, "Boolean", "Boolean"),
    JAVA_OBJECT_LITERAL(10, "JavaObject", "JavaObject");

    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    public static final int DATE = 0;
    public static final int DOUBLE = 1;
    public static final int INTEGER = 2;
    public static final int STRING = 3;
    public static final int TIME = 4;
    public static final int TIMESTAMP = 5;
    public static final int DECIMAL = 6;
    public static final int BLOB = 7;
    public static final int CLOB = 8;
    public static final int BOOLEAN = 9;
    public static final int JAVA_OBJECT = 10;
    private static final OdaScalarDataType[] VALUES_ARRAY;
    public static final List<OdaScalarDataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OdaScalarDataType[]{DATE_LITERAL, DOUBLE_LITERAL, INTEGER_LITERAL, STRING_LITERAL, TIME_LITERAL, TIMESTAMP_LITERAL, DECIMAL_LITERAL, BLOB_LITERAL, CLOB_LITERAL, BOOLEAN_LITERAL, JAVA_OBJECT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OdaScalarDataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OdaScalarDataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OdaScalarDataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OdaScalarDataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OdaScalarDataType get(int value) {
        switch (value) {
            case 0: {
                return DATE_LITERAL;
            }
            case 1: {
                return DOUBLE_LITERAL;
            }
            case 2: {
                return INTEGER_LITERAL;
            }
            case 3: {
                return STRING_LITERAL;
            }
            case 4: {
                return TIME_LITERAL;
            }
            case 5: {
                return TIMESTAMP_LITERAL;
            }
            case 6: {
                return DECIMAL_LITERAL;
            }
            case 7: {
                return BLOB_LITERAL;
            }
            case 8: {
                return CLOB_LITERAL;
            }
            case 9: {
                return BOOLEAN_LITERAL;
            }
            case 10: {
                return JAVA_OBJECT_LITERAL;
            }
        }
        return null;
    }

    private OdaScalarDataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

