/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.editorext;

import java.sql.SQLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.debugger.core.SQLDebuggerConfiguration;
import org.eclipse.datatools.sqltools.debugger.core.ui.DebuggerCoreUIPlugin;
import org.eclipse.datatools.sqltools.debugger.debug.BreakpointLocationHandler;
import org.eclipse.datatools.sqltools.debugger.editorext.SPBreakpointAnnotationModel;
import org.eclipse.datatools.sqltools.routineeditor.ui.IRoutineEditorDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.ui.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.ui.SQLRoutineDocumentProvider;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class SQLDebuggerDocumentProvider
extends SQLRoutineDocumentProvider
implements IRoutineEditorDocumentProvider {
    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof ProcEditorInput && SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)((ProcEditorInput)element).getProcIdentifier().getDatabaseIdentifier()) instanceof SQLDebuggerConfiguration) {
            return new SPBreakpointAnnotationModel(((ProcEditorInput)element).getProcIdentifier());
        }
        return super.createAnnotationModel(element);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        super.doSaveDocument(monitor, element, document, overwrite);
        if (element instanceof ProcEditorInput) {
            SQLEditor editor = (SQLEditor)DebuggerCoreUIPlugin.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            BreakpointLocationHandler.handleEditorSave(((ProcEditorInput)element).getProcIdentifier(), (IEditorPart)editor);
        }
    }

    public void refreshFromDatabase(Object element, IControlConnection controlCon, ProcIdentifier proc) throws CoreException, SQLException {
        if (SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)proc.getDatabaseIdentifier()) instanceof SQLDebuggerConfiguration) {
            IAnnotationModel model = this.getAnnotationModel(element);
            IDocument document = this.getDocument(element);
            if (model instanceof SPBreakpointAnnotationModel) {
                ((SPBreakpointAnnotationModel)model).updateMarkers(document);
                document.set(controlCon.getProcSource(proc));
                AbstractDocumentProvider.ElementInfo info = this.getElementInfo(element);
                info.fCanBeSaved = false;
                this.addUnchangedElementListeners(element, info);
                this.fireElementDirtyStateChanged(element, false);
                ((SPBreakpointAnnotationModel)model).documentSaved(document);
                controlCon.refresh(proc);
            }
        } else {
            super.refreshFromDatabase(element, controlCon, proc);
        }
    }
}

