/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.ui.impl;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.enablement.oda.ecore.ui.i18n.Messages;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataSourceSelectionPageHelper {
    private Text modelPathControl;
    private Button workspaceRadioButton;
    private Button filesystemRadioButton;
    private Button uriLiteralURIRadioButton;
    private final IUpdateStrategy updateStrategy;
    private Button browseButton;

    DataSourceSelectionPageHelper(WizardPage page) {
        this.updateStrategy = new WizardUpdateStrategy(page);
    }

    DataSourceSelectionPageHelper(PreferencePage page) {
        this.updateStrategy = new PreferenceUpdateStrategy(page);
    }

    void createCustomControl(Composite parent) {
        Group locationGroup = new Group(parent, 0);
        locationGroup.setText(Messages.getString("DataSourceWizardPage.group.modelLocation"));
        this.filesystemRadioButton = new Button((Composite)locationGroup, 16);
        this.filesystemRadioButton.setText(Messages.getString("DataSourceWizardPage.button.useFilesystem"));
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.filesystemRadioButton);
        this.filesystemRadioButton.setSelection(true);
        this.workspaceRadioButton = new Button((Composite)locationGroup, 16);
        this.workspaceRadioButton.setText(Messages.getString("DataSourceWizardPage.button.useWorkspace"));
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.workspaceRadioButton);
        this.workspaceRadioButton.setSelection(false);
        this.uriLiteralURIRadioButton = new Button((Composite)locationGroup, 16);
        this.uriLiteralURIRadioButton.setText(Messages.getString("DataSourceWizardPage.button.useLiteralURI"));
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.uriLiteralURIRadioButton);
        this.uriLiteralURIRadioButton.setSelection(false);
        Label label = new Label((Composite)locationGroup, 0);
        label.setText(Messages.getString("DataSourceWizardPage.label.model"));
        this.modelPathControl = new Text((Composite)locationGroup, 2052);
        this.modelPathControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataSourceSelectionPageHelper.this.dialogChanged();
            }
        });
        this.browseButton = new Button((Composite)locationGroup, 8);
        this.browseButton.setText(Messages.getString("DataSourceWizardPage.button.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourceSelectionPageHelper.this.handleBrowseForModel();
            }
        });
        this.filesystemRadioButton.addSelectionListener((SelectionListener)new ControlEnabler((Control)this.browseButton, true));
        this.workspaceRadioButton.addSelectionListener((SelectionListener)new ControlEnabler((Control)this.browseButton, true));
        this.uriLiteralURIRadioButton.addSelectionListener((SelectionListener)new ControlEnabler((Control)this.browseButton, false));
        GridLayoutFactory.fillDefaults().numColumns(3).generateLayout((Composite)locationGroup);
    }

    void initCustomControl(Properties properties) {
        String pathText;
        if (properties == null || properties.isEmpty() || !properties.containsKey("MODEL_URI")) {
            return;
        }
        String literalURI = properties.getProperty("MODEL_URI");
        URI uri = URI.createURI((String)literalURI);
        if (uri.isFile()) {
            pathText = uri.toFileString();
            this.filesystemRadioButton.setSelection(true);
            this.workspaceRadioButton.setSelection(false);
            this.uriLiteralURIRadioButton.setSelection(false);
        } else if (uri.isPlatformResource()) {
            pathText = uri.toPlatformString(true);
            this.workspaceRadioButton.setSelection(true);
            this.filesystemRadioButton.setSelection(false);
            this.uriLiteralURIRadioButton.setSelection(false);
        } else {
            pathText = literalURI;
            this.uriLiteralURIRadioButton.setSelection(true);
            this.workspaceRadioButton.setSelection(false);
            this.filesystemRadioButton.setSelection(false);
            this.browseButton.setEnabled(false);
        }
        this.modelPathControl.setText(pathText);
        this.dialogChanged();
    }

    Properties collectCustomProperties(Properties properties) {
        Properties toReturn = properties == null ? new Properties() : properties;
        String pathText = this.modelPathControl.getText();
        URI uri = this.filesystemRadioButton.getSelection() ? URI.createFileURI((String)pathText) : (this.workspaceRadioButton.getSelection() ? URI.createPlatformResourceURI((String)pathText, (boolean)true) : URI.createURI((String)pathText));
        toReturn.setProperty("MODEL_URI", uri.toString());
        return toReturn;
    }

    void dialogChanged() {
        String uriText = this.modelPathControl.getText();
        String message = null;
        if (uriText.length() == 0) {
            message = Messages.getString("DataSourceWizardPage.message.missingModel");
        }
        try {
            URI.createURI((String)uriText);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            message = Messages.getString("DataSourceWizardPage.message.invalidUri");
        }
        this.updateStrategy.updateStatus(message);
    }

    private void handleBrowseForModel() {
        String path = null;
        if (this.filesystemRadioButton.getSelection()) {
            FileDialog filesystemDialog = new FileDialog(this.modelPathControl.getShell());
            path = filesystemDialog.open();
        } else {
            String msg = Messages.getString("DataSourceWizardPage.dialog.workspace");
            IFile[] result = WorkspaceResourceDialog.openFileSelection((Shell)this.modelPathControl.getShell(), null, (String)msg, (boolean)false, null, null);
            if (result.length > 0) {
                path = result[0].getFullPath().toPortableString();
            }
        }
        if (path == null) {
            path = "";
        }
        this.modelPathControl.setText(path);
    }

    private static class ControlEnabler
    extends SelectionAdapter {
        private final boolean enableOrDisable;
        private final Control control;

        ControlEnabler(Control control, boolean enableOrDisable) {
            this.control = control;
            this.enableOrDisable = enableOrDisable;
        }

        public void widgetSelected(SelectionEvent e) {
            this.control.setEnabled(this.enableOrDisable);
        }
    }

    private static interface IUpdateStrategy {
        public void updateStatus(String var1);
    }

    private static final class PreferenceUpdateStrategy
    implements IUpdateStrategy {
        private final PreferencePage page;

        PreferenceUpdateStrategy(PreferencePage page) {
            this.page = page;
        }

        public void updateStatus(String message) {
            this.page.setErrorMessage(message);
            this.page.setValid(message == null);
        }
    }

    private static final class WizardUpdateStrategy
    implements IUpdateStrategy {
        private final WizardPage page;

        WizardUpdateStrategy(WizardPage page) {
            this.page = page;
        }

        public void updateStatus(String message) {
            this.page.setErrorMessage(message);
            this.page.setPageComplete(message == null);
        }
    }
}

